/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.xml;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static String criaXML(Registro reg, String[] camposChave) throws SQLException {
        return XMLUtil.criaXML("", reg, camposChave);
    }

    public static String criaXML(String root, Registro reg, String[] camposChave) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(root)) {
            buf.append("<" + root + ">");
        }
        for (String key : reg.getKeySet()) {
            buf.append("<campo><nome>");
            buf.append(key);
            buf.append("</nome><tipo>");
            int tipoCampo = 0;
            Object valor = reg.getValor(key);
            tipoCampo = valor == null ? 2 : (reg.isBoolean(key) ? 4 : (reg.isNumber(key) ? 2 : (reg.isDate(key) ? 1 : (reg.isTime(key) ? 3 : (reg.isTimestamp(key) ? 5 : 0)))));
            if (tipoCampo == 1 || tipoCampo == 5) {
                valor = valor.toString().replaceAll("/", "-");
            }
            buf.append(tipoCampo);
            buf.append("</tipo><valor>");
            buf.append(valor instanceof String ? StringUtil.textoXML(valor.toString()) : valor);
            buf.append("</valor><chave>");
            buf.append(XMLUtil.isPK(key, camposChave) ? "1" : "0");
            buf.append("</chave></campo>");
        }
        if (!Funcoes.textoVazio(root)) {
            buf.append("</" + root + ">");
        }
        return buf.toString();
    }

    public static boolean contemElementosFilhos(Node no) {
        NodeList list = no.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static List<Element> getElementosFilhos(Element ele) {
        ArrayList<Element> filhos = new ArrayList<Element>();
        if (ele != null) {
            NodeList list = ele.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                filhos.add((Element)list.item(i));
            }
        }
        return filhos;
    }

    public static Map<String, String> getAtributosDoElemento(Element ele) {
        HashMap<String, String> mapa = new HashMap<String, String>();
        if (ele != null) {
            NamedNodeMap atributos = ele.getAttributes();
            for (int i = 0; i < atributos.getLength(); ++i) {
                Node node = atributos.item(i);
                mapa.put(node.getNodeName(), node.getNodeValue());
            }
        }
        return mapa;
    }

    public static Document analisarXML(File arquivo) throws Exception {
        try {
            return XMLUtil.analisarXML(new FileInputStream(arquivo));
        }
        catch (Exception e) {
            throw new Exception(XMLUtil.construirMensagem(e));
        }
    }

    public static Document analisarXML(File arquivo, ErrorHandler handler) throws Exception {
        try {
            return XMLUtil.analisarXML(new FileInputStream(arquivo), handler);
        }
        catch (Exception e) {
            throw new Exception(XMLUtil.construirMensagem(e));
        }
    }

    public static Document analisarXML(InputStream input) throws Exception {
        return XMLUtil.analisarXML(input, null);
    }

    public static Document analisarXMLString(String xml) throws Exception {
        return XMLUtil.analisarXMLString(xml, null);
    }

    public static Document analisarXML(InputStream input, ErrorHandler handler) throws Exception {
        DocumentBuilder builder = XMLUtil.novoDocumentBuilder();
        if (builder != null) {
            try {
                if (handler != null) {
                    builder.setErrorHandler(handler);
                }
                return builder.parse(input);
            }
            catch (Exception e) {
                throw new Exception(XMLUtil.construirMensagem(e));
            }
        }
        return null;
    }

    public static Document analisarXMLString(String xml, ErrorHandler handler) throws Exception {
        DocumentBuilder builder = XMLUtil.novoDocumentBuilder();
        if (builder != null) {
            try {
                if (handler != null) {
                    builder.setErrorHandler(handler);
                }
                return builder.parse(new InputSource(new StringReader(xml)));
            }
            catch (Exception e) {
                throw new Exception(XMLUtil.construirMensagem(e));
            }
        }
        return null;
    }

    public static Document criaDocumentCDATA(Document doc, List<Element> elementoPai, String ... tags) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        for (Element element : elementoPai) {
            String tagElement = element.getTagName();
            if (XMLUtil.contemElementosFilhos(element)) {
                XMLUtil.criaDocumentCDATA(doc, XMLUtil.getElementosFilhos(element), tags);
                continue;
            }
            for (String tag : tags) {
                if (!tagElement.equals(tag)) continue;
                CDATASection cdata = doc.createCDATASection(element.getTextContent());
                element.setTextContent("");
                element.appendChild(cdata);
            }
        }
        return doc;
    }

    public static String adicionaCDATA(String xml, String codificao, String ... tags) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, Exception {
        Document doc = XMLUtil.analisarXMLString(xml);
        Element raiz = doc.getDocumentElement();
        List<Element> atrs = XMLUtil.getElementosFilhos(raiz);
        doc = XMLUtil.criaDocumentCDATA(doc, atrs, tags);
        xml = XMLUtil.documentToString(doc, codificao);
        return xml;
    }

    public static String processaCDataXml(String xml, String[] tags) {
        for (String tag : tags) {
            Pattern regex = Pattern.compile("<" + tag + ">(.*?)</" + tag + ">", 32);
            Matcher matcher = regex.matcher(xml);
            while (matcher.find()) {
                String valor = matcher.group(1);
                if (Funcoes.textoVazio(valor) || valor.indexOf("CDATA") > -1) continue;
                String valorCdata = StringUtil.getTag(tag, new String[]{valor.trim()});
                String valorAnterior = StringUtil.getTag(tag, valor);
                xml = StringUtil.replaceBuilder(xml, valorAnterior, valorCdata);
            }
        }
        return xml;
    }

    public static String documentToString(Document doc, String encoding) throws TransformerException, UnsupportedEncodingException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        transformer.setOutputProperty("encoding", encoding);
        return new String(writer.toString().getBytes(encoding));
    }

    public static Document novoDocumentoDOM() throws ParserConfigurationException {
        DocumentBuilder builder = XMLUtil.novoDocumentBuilder();
        return builder != null ? builder.newDocument() : null;
    }

    public static DocumentBuilder novoDocumentBuilder() throws ParserConfigurationException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationException(XMLUtil.construirMensagem(e));
        }
    }

    private static boolean isPK(String campo, String ... camposChave) {
        for (String s : camposChave) {
            if (!s.equalsIgnoreCase(campo)) continue;
            return true;
        }
        return false;
    }

    private static String construirMensagem(Exception e) {
        if (e.toString().contains("lineNumber:")) {
            String linhaXML = "";
            String colunaXML = "";
            for (String s : e.toString().split(";")) {
                if (s.contains("lineNumber:")) {
                    s = s.split(": ")[1];
                    linhaXML = s.substring(0, s.length());
                }
                if (!s.contains("columnNumber:")) continue;
                s = s.split(": ")[1];
                colunaXML = s.substring(0, s.length());
            }
            StringBuilder mensagem = new StringBuilder();
            mensagem.append(e.getMessage()).append("\nVerifique a linha ").append(linhaXML).append(" na coluna ").append(colunaXML).append(".");
            return mensagem.toString();
        }
        return e.getMessage();
    }
}

