/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.xml;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilderException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;

public class XMLStringBuilder {
    private ArrayList<StringBuilder> itens = new ArrayList();
    private Stack<String> tagsAbertas = new Stack();
    private int indentacao = 0;
    private boolean tratarEspeciais = false;

    public XMLStringBuilder() {
        this.tratarEspeciais = false;
    }

    public XMLStringBuilder(boolean tratarEspeciais) {
        this.tratarEspeciais = tratarEspeciais;
    }

    public void escreveHeader(String versaoXML, String codificacao) {
        if (Funcoes.textoVazio(versaoXML) || Funcoes.textoVazio(codificacao)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"").append(versaoXML).append("\" encoding=\"").append(codificacao).append("\"?>");
        this.itens.add(0, buf);
    }

    public void limpar() {
        this.itens.clear();
        this.tagsAbertas.clear();
        this.indentacao = 0;
    }

    public void abrir(String tag) {
        this.abrir(tag, null);
    }

    public void abrir(String tag, Map<String, String> atributos) {
        this.escrever("<", tag, this.getStringDeAtributos(atributos), ">");
        this.indentar();
        this.tagsAbertas.add(tag);
    }

    public void fechar(String tag) throws XMLStringBuilderException {
        if (this.tagsAbertas.isEmpty()) {
            throw new XMLStringBuilderException("A tag \"" + tag + "\" n\u00e3o pode ser fechada, pois n\u00e3o foi aberta");
        }
        if (!this.tagsAbertas.peek().equalsIgnoreCase(tag)) {
            throw new XMLStringBuilderException("A tag \"" + tag + "\" n\u00e3o pode ser fechada, pois a tag \"" + this.tagsAbertas.peek() + "\" ainda est\u00e1 aberta");
        }
        this.desindentar();
        this.escrever("</", tag, ">");
        this.tagsAbertas.pop();
    }

    public void escrever(String tag, String valor) {
        this.escrever(tag, this.tratarEspeciais ? StringUtil.tratarEntidadesHTML(valor, false) : valor, (Map<String, String>)null);
    }

    public void escrever(String tag, String valor, Map<String, String> atributos) {
        if (tag != null && tag.trim().length() > 0) {
            this.escrever("<", tag, this.getStringDeAtributos(atributos), ">", valor == null ? "" : valor, "</", tag, ">");
        }
    }

    public void escrever(String tag, XMLStringBuilder xml) {
        this.escrever(tag, xml, null);
    }

    public void escrever(String tag, XMLStringBuilder xml, Map<String, String> atributos) {
        if (tag != null && xml != null) {
            try {
                this.abrir(tag, atributos);
                for (StringBuilder bui : xml.itens) {
                    this.escrever(bui.toString());
                }
                this.fechar(tag);
            }
            catch (XMLStringBuilderException xMLStringBuilderException) {
                // empty catch block
            }
        }
    }

    public void escrever(String ... strs) {
        if (strs.length > 0) {
            StringBuilder bui = new StringBuilder();
            bui.append(StringUtil.repeteCaractere(' ', this.indentacao));
            for (String str : strs) {
                bui.append(str);
            }
            this.itens.add(bui);
        }
    }

    public void trimToSize() {
        if (this.itens != null) {
            this.itens.trimToSize();
            for (StringBuilder aux : this.itens) {
                aux.trimToSize();
            }
        }
    }

    public void escreverCData(String tag, String valor) {
        this.escrever("<", tag, ">", "<![CDATA[" + (valor == null ? "" : valor) + "]]>", "</", tag, ">");
    }

    public String getXML() {
        StringBuilder bui = new StringBuilder();
        for (StringBuilder item : this.itens) {
            bui.append(item.toString());
            bui.append('\n');
        }
        return bui.toString();
    }

    protected String getStringDeAtributos(Map<String, String> atributos) {
        StringBuilder bui = new StringBuilder();
        if (atributos != null) {
            for (String atr : atributos.keySet()) {
                bui.append(' ').append(atr).append("=\"").append(atributos.get(atr)).append("\"");
            }
        }
        return bui.toString();
    }

    private void indentar() {
        this.indentacao += 2;
    }

    private void desindentar() {
        this.indentacao = Math.max(0, this.indentacao - 2);
    }

    public boolean vazio() {
        return this.itens.size() == 0;
    }

    public String toString() {
        return this.getXML();
    }

    public void escreveHeaderAlvaro(String versaoXML, String codificacao) {
        if (Funcoes.textoVazio(versaoXML) || Funcoes.textoVazio(codificacao)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"").append(versaoXML).append("\" encoding=\"").append(codificacao).append("\"").append(" standalone=\"yes\"?>");
        this.itens.add(0, buf);
    }

    public void abrirTagAlvaro(String tag, Map<String, String> atributos) {
        this.escrever("<", tag, this.getStringDeAtributos(atributos), "/>");
        this.indentar();
        this.tagsAbertas.add(tag);
    }

    public void fecharTagAlvaro(String tag) throws XMLStringBuilderException {
        this.desindentar();
        this.escrever("</", tag, ">");
        this.tagsAbertas.pop();
    }
}

