/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.xml;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.EscreveArquivoXMLException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Stack;

public class EscreveArquivoXML {
    private String versao;
    private String encoding;
    private int indentacao = 0;
    private File arquivo;
    private BufferedWriter writer;
    private Stack<String> abertas = new Stack();
    private boolean tratarEspeciais;

    public EscreveArquivoXML() {
        this("1.0", "ISO_8859-1", false);
    }

    public EscreveArquivoXML(boolean tratarCaracteresEspeciais) {
        this("1.0", "ISO-8859-1", tratarCaracteresEspeciais);
    }

    public EscreveArquivoXML(String versao, String encoding, boolean tratarCaracteresEspeciais) {
        Funcoes.validarNaoNull(versao, "versao");
        Funcoes.validarNaoNull(encoding, "encoding");
        this.versao = versao;
        this.encoding = encoding;
        this.tratarEspeciais = tratarCaracteresEspeciais;
    }

    public void abrirArquivo(String nomeArquivo) throws EscreveArquivoXMLException {
        try {
            this.arquivo = new File(nomeArquivo);
            this.writer = new BufferedWriter(new FileWriter(this.arquivo));
            this.writer.write("<?xml version=\"");
            this.writer.write(this.versao);
            this.writer.write("\" encoding=\"");
            this.writer.write(this.encoding);
            this.writer.write("\"?>\n");
        }
        catch (IOException e) {
            throw new EscreveArquivoXMLException("N\u00e3o foi poss\u00edvel abrir o arquivo \"" + this.arquivo + "\"", e.getCause());
        }
    }

    public void fecharArquivo() throws EscreveArquivoXMLException {
        if (this.writer == null) {
            throw new EscreveArquivoXMLException("N\u00e3o \u00e9 possivel fechar o arquivo, pois n\u00e3o est\u00e1 aberto");
        }
        if (!this.abertas.isEmpty()) {
            throw new EscreveArquivoXMLException("O arquivo n\u00e3o pode ser fechado, pois a tag \"" + this.abertas.peek() + "\" ainda est\u00e1 aberta");
        }
        try {
            this.writer.close();
            this.writer = null;
            this.arquivo = null;
        }
        catch (IOException e) {
            throw new EscreveArquivoXMLException("N\u00e3o foi poss\u00edvel tentar fechar o arquivo");
        }
    }

    public void cancelar() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.arquivo.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void abrir(String tag) throws EscreveArquivoXMLException {
        this.escrever("<" + tag + ">");
        this.indentar();
        this.abertas.add(tag);
    }

    public void fechar(String tag) throws EscreveArquivoXMLException {
        if (this.abertas.isEmpty()) {
            throw new EscreveArquivoXMLException("A tag \"" + tag + "\" n\u00e3o pode ser fechada, pois n\u00e3o foi aberta");
        }
        if (!this.abertas.peek().equalsIgnoreCase(tag)) {
            throw new EscreveArquivoXMLException("A tag \"" + tag + "\" n\u00e3o pode ser fechada, pois a tag \"" + this.abertas.peek() + "\" ainda est\u00e1 aberta");
        }
        this.desindentar();
        this.escrever("</" + tag + ">");
        this.abertas.pop();
    }

    public void escreverItem(String tag, String valor) throws EscreveArquivoXMLException {
        if (tag != null && valor != null && tag.trim().length() > 0 && valor.trim().length() > 0) {
            this.escrever(StringUtil.getTag(tag, this.tratarEspeciais ? StringUtil.tratarEntidadesHTML(valor, false) : valor));
        }
    }

    private void escrever(String texto) throws EscreveArquivoXMLException {
        if (this.writer == null) {
            throw new EscreveArquivoXMLException("O arquivo n\u00e3o pode ser escrito, pois n\u00e3o foi aberto");
        }
        try {
            this.writer.write(StringUtil.repeteCaractere(' ', this.indentacao));
            this.writer.write(texto);
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new EscreveArquivoXMLException("N\u00e3o foi poss\u00edvel tentar escrever no arquivo");
        }
    }

    private void indentar() {
        this.indentacao += 2;
    }

    private void desindentar() {
        this.indentacao = Math.max(0, this.indentacao - 2);
    }

    public File getArquivo() {
        return this.arquivo;
    }
}

