/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.tabela;

import jalis.util.TableUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloTabela;
import jalis.util.tabela.TableSortMouseListener;
import java.awt.AWTKeyStroke;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class TabelaModelada
extends JTable {
    protected ModeloTabela modelo;
    private ArrayList<Boolean> colunas_fixadas;
    private ArrayList<Integer> tamanho_colunas;
    private boolean ordenavel_manualmente = true;
    private MouseListener mouse_sort = new TableSortMouseListener();

    public TabelaModelada(ArrayList<String> nomes_colunas) {
        try {
            this.jbInit(nomes_colunas);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TabelaModelada");
        }
    }

    public TabelaModelada(String[] nomes_colunas) {
        try {
            ArrayList<String> colunas = new ArrayList<String>();
            for (String c : nomes_colunas) {
                colunas.add(c);
            }
            this.jbInit(colunas);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TabelaModelada");
        }
    }

    public void jbInit(ArrayList<String> column_names) throws Exception {
        this.setSelectionMode(0);
        this.sizeColumnsToFit(-1);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().addMouseListener(this.mouse_sort);
        this.modelo = new ModeloTabela(this);
        this.setModel(this.modelo);
        this.modelo.setColumnNames(column_names);
        this.colunas_fixadas = new ArrayList();
        this.tamanho_colunas = new ArrayList();
        for (int i = 0; i < column_names.size(); ++i) {
            this.colunas_fixadas.add(false);
            this.tamanho_colunas.add(0);
        }
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        keys = new HashSet<AWTKeyStroke>(keys);
        keys.add(KeyStroke.getKeyStroke("TAB"));
        this.setFocusTraversalKeys(0, keys);
        keys = this.getFocusTraversalKeys(1);
        keys = new HashSet<AWTKeyStroke>(keys);
        keys.add(KeyStroke.getKeyStroke("shift TAB"));
        this.setFocusTraversalKeys(1, keys);
    }

    @Override
    public void resizeAndRepaint() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.colunas_fixadas == null || this.colunas_fixadas.size() <= i || !this.colunas_fixadas.get(i).booleanValue()) continue;
            this.forceSize(i, this.tamanho_colunas.get(i));
        }
        this.revalidate();
        this.repaint();
    }

    public void forceSize(int column, int width) {
        if (column < this.getColumnCount()) {
            this.getColumnModel().getColumn(column).setMinWidth(width);
        }
        if (column < this.getColumnCount()) {
            this.getColumnModel().getColumn(column).setMaxWidth(width);
        }
        if (column < this.getColumnCount()) {
            this.getColumnModel().getColumn(column).setPreferredWidth(width);
        }
        if (column < this.getColumnCount()) {
            this.getColumnModel().getColumn(column).setWidth(width);
            this.colunas_fixadas.set(column, true);
            this.tamanho_colunas.set(column, width);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.modelo.getValueAt(rowIndex, columnIndex);
    }

    public void deleteRow(int row) {
        this.modelo.deleteRow(row);
        this.resizeAndRepaint();
        if (row < this.getRowCount()) {
            this.selectRow(row);
        } else if (this.getRowCount() > 0 && --row < this.getRowCount()) {
            this.selectRow(row);
        }
    }

    public void selectRow(int row) {
        this.setRowSelectionInterval(row, row);
        TableUtil.scrollToVisible(this, row);
    }

    public void setOrdenavelManualmente(boolean ordenavel) {
        if (!ordenavel) {
            this.getTableHeader().removeMouseListener(this.mouse_sort);
            this.ordenavel_manualmente = false;
        } else if (!this.ordenavel_manualmente) {
            this.getTableHeader().addMouseListener(this.mouse_sort);
            this.ordenavel_manualmente = true;
        }
    }

    public void setColumnNames(ArrayList<String> column_names) {
        this.modelo.setColumnNames(column_names);
        this.colunas_fixadas = new ArrayList();
        this.tamanho_colunas = new ArrayList();
        for (int i = 0; i < column_names.size(); ++i) {
            this.colunas_fixadas.add(false);
            this.tamanho_colunas.add(0);
        }
    }

    public void addColumn(int index, String columnName, boolean fixed_size) {
        this.modelo.addColumn(index, columnName);
        this.colunas_fixadas.add(index, fixed_size);
        this.tamanho_colunas.add(index, 0);
    }

    public void addColumn(String columnName) {
        this.modelo.addColumn(columnName);
        this.colunas_fixadas.add(false);
        this.tamanho_colunas.add(0);
    }

    @Override
    public String getColumnName(int column) {
        return this.modelo.getColumnName(column);
    }

    public int getColunaOrdenada() {
        return this.modelo.getColunaOrdenada();
    }

    public void setData(ArrayList data) {
        this.modelo.setData(data);
    }

    public void setSortedData(ArrayList new_data, int col) {
        this.modelo.setSortedData(new_data, col);
    }

    public void setSortedData(ArrayList new_data, int col, boolean manterOrdem) {
        this.modelo.setSortedData(new_data, col, manterOrdem, true);
    }

    public void setSortedData(ArrayList new_data, int col, boolean manterOrdem, boolean atualizarTabela) {
        this.modelo.setSortedData(new_data, col, manterOrdem, atualizarTabela);
    }

    public Object[] getRow(int row) {
        return this.modelo.getRow(row);
    }

    public void setRow(int row, Object[] newdata) {
        this.modelo.setRow(row, newdata);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.modelo.setValueAt(value, rowIndex, columnIndex);
    }

    public void addRow(Object[] row) {
        this.modelo.addRow(row);
    }

    public void addSortedRow(Object[] row) {
        this.modelo.addSortedRow(row);
    }

    public void stepSelection() {
        int row = this.getSelectedRow();
        if (row + 1 < this.getRowCount()) {
            this.selectRow(++row);
        }
    }

    public void sortRowsByColumn(int col, boolean hold_selection, boolean mudarOrdem) {
        this.modelo.sortRowsByColumn(col, hold_selection, mudarOrdem);
    }

    public void sortRowsByColumn(int col, boolean hold_selection) {
        this.modelo.sortRowsByColumn(col, hold_selection, false);
    }
}

