/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.tabela;

import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Registro {
    Map<String, Object> valores = new HashMap<String, Object>();

    public static Registro[] getRegistros(ResultSet res) {
        ArrayList<Registro> arr = new ArrayList<Registro>();
        try {
            if (res != null && res.first()) {
                do {
                    arr.add(new Registro(res));
                } while (res.next());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Registro: 36");
        }
        return arr.toArray(new Registro[arr.size()]);
    }

    public static Registro novoRegistro(Object[] dados) {
        Registro reg = new Registro();
        if (dados != null && dados.length % 2 == 0) {
            for (int i = 0; i <= dados.length - 2; i += 2) {
                if (dados[i] == null) continue;
                reg.setValor(dados[i].toString(), dados[i + 1]);
            }
        }
        return reg;
    }

    public Registro() {
    }

    public Registro(ResultSet res) {
        this.carregar(res);
    }

    public Registro carregar(ResultSet res) {
        if (res != null) {
            try {
                ResultSetMetaData meta = res.getMetaData();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String colNome = meta.getColumnName(i);
                    Object colValor = res.getObject(colNome);
                    colValor = this.tipoData(meta.getColumnType(i)) && colValor != null ? colValor.toString().replace('-', '/') : colValor;
                    this.valores.put(colNome, colValor);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Registro: 93");
            }
        }
        return this;
    }

    public Registro carregar(Registro reg) {
        if (reg != null) {
            for (String key : reg.valores.keySet()) {
                this.valores.put(key, reg.valores.get(key));
            }
        }
        return this;
    }

    public void limpar() {
        this.valores.clear();
    }

    public Object getValor(String campo) {
        return this.valores.get(campo);
    }

    public <T> T getValor(String campo, Class<T> tipo) {
        if (tipo.isInstance(this.valores.get(campo))) {
            return tipo.cast(this.valores.get(campo));
        }
        return null;
    }

    public boolean possuiCampo(String campo) {
        return this.valores.containsKey(campo);
    }

    public int getInt(String campo) {
        Object o = this.valores.get(campo);
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String && o != null && Funcoes.isNumeric((String)o)) {
            return Integer.parseInt((String)o);
        }
        throw new ClassCastException("O campo " + campo + " n\u00e3o \u00e9 inst\u00e2ncia de Number.");
    }

    public double getDouble(String campo) {
        Object o = this.valores.get(campo);
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String && o != null && Funcoes.isNumeric(String.valueOf(o))) {
            return Double.valueOf((String)o);
        }
        throw new ClassCastException("O campo " + campo + " n\u00e3o \u00e9 inst\u00e2ncia de Number.");
    }

    public boolean getBoolean(String campo) {
        Object o = this.valores.get(campo);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return o != null && o.toString().trim().equals("true");
        }
        throw new ClassCastException("O campo " + campo + " n\u00e3o \u00e9 inst\u00e2ncia de Boolean.");
    }

    public Date getDate(String campo) throws ParseException {
        Object o = this.valores.get(campo);
        try {
            if (o instanceof String) {
                String tmp = o.toString();
                if (tmp.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{2}")) {
                    return new SimpleDateFormat("dd/MM/yy").parse(tmp);
                }
                if (tmp.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4}")) {
                    return new SimpleDateFormat("dd/MM/yyyy").parse(tmp);
                }
                if (tmp.matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01])")) {
                    return new SimpleDateFormat("yyyy/MM/dd").parse(tmp);
                }
                if (tmp.matches("\\d{4}-(0[1-9]|1[012])-(0[1-9]|[12]\\d|3[01])")) {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(tmp);
                }
                if (tmp.matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                    return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(tmp);
                }
                if (tmp.matches("([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                    return new SimpleDateFormat("HH:mm:ss").parse(tmp);
                }
            } else if (o instanceof Date) {
                return (Date)o;
            }
        }
        catch (ParseException e) {
            throw new ParseException("O campo " + campo + " n\u00e3o \u00e9 uma data v\u00e1lida.", 0);
        }
        return null;
    }

    public String getString(String campo) {
        Object o = this.valores.get(campo);
        return o != null ? o.toString() : "";
    }

    public boolean isNumber(String campo) {
        return this.valores.get(campo) instanceof Number;
    }

    public boolean isBoolean(String campo) {
        return this.valores.get(campo) instanceof Boolean;
    }

    public boolean isDate(String campo) {
        Object o = this.valores.get(campo);
        return o != null && o.toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01])");
    }

    public boolean isTimestamp(String campo) {
        Object o = this.valores.get(campo);
        return o != null && o.toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?");
    }

    public boolean isTime(String campo) {
        Object o = this.valores.get(campo);
        return o != null && o.toString().matches("([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?");
    }

    public boolean isString(String campo) {
        Object o = this.valores.get(campo);
        if (o instanceof String) {
            String tmp = (String)o;
            return !tmp.matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01])") && !tmp.matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?") && !tmp.matches("([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?");
        }
        return false;
    }

    public void setValor(String campo, Object valor) {
        this.valores.put(campo, valor);
    }

    public boolean contemValor(String campo, Object valor) {
        Object tmp = this.valores.get(campo);
        return tmp == null ? valor == null : tmp.equals(valor);
    }

    public boolean contemValor(String campo, String valor) {
        Object vlr = this.valores.get(campo);
        if (vlr != null) {
            vlr = String.valueOf(vlr);
        }
        return vlr == null ? false : vlr.equals(valor);
    }

    public boolean nulo(String campo) {
        return this.valores.get(campo) == null || this.valores.get(campo).equals("null");
    }

    private boolean tipoData(int i) {
        return i == 91 || i == 92 || i == 93;
    }

    public int getQtdeColunas() {
        return this.valores.size();
    }

    public String getNomeColuna(int pos) {
        if (pos < this.valores.size()) {
            int i = 0;
            for (String key : this.valores.keySet()) {
                if (i == pos) {
                    return key;
                }
                ++i;
            }
        }
        return null;
    }

    public Set<String> getKeySet() {
        return this.valores.keySet();
    }

    public Registro clone() {
        Registro registro = new Registro();
        Set<String> keys = this.getKeySet();
        for (String key : keys) {
            registro.setValor(key, this.getValor(key));
        }
        return registro;
    }

    public void substituirValor(String campo, Object valor) {
        if (this.valores.get(campo) == valor) {
            return;
        }
        this.valores.remove(campo);
        this.valores.put(campo, valor);
    }

    public Map<String, Object> getHashOriginal() {
        return this.valores;
    }
}

