/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.tabela;

import jalis.util.tabela.ObjectTableModelColumn;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ObjectTableModel<K>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Class<? extends K> dataClass;
    private List<ObjectTableModelColumn> columns;
    private List<K> data;

    public ObjectTableModel(Class<? extends K> dataClass, List<ObjectTableModelColumn> columns, List<K> data) throws SecurityException, NoSuchMethodException {
        this.dataClass = dataClass;
        this.setColumns(columns);
        this.setData(data);
    }

    public ObjectTableModel(Class<? extends K> dataClass, List<ObjectTableModelColumn> columns) throws SecurityException, NoSuchMethodException {
        this.dataClass = dataClass;
        this.setColumns(columns);
    }

    public ObjectTableModel(Class<? extends K> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnName = null;
        if (this.columns != null && this.columns.size() > columnIndex) {
            columnName = this.columns.get(columnIndex).getColumnName();
        }
        return columnName;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> columnClass = null;
        if (this.columns != null && this.columns.size() > columnIndex) {
            columnClass = this.columns.get(columnIndex).getGetMethod().getReturnType();
        }
        return columnClass;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (this.columns != null && this.data != null && this.columns.size() > columnIndex && this.data.size() > rowIndex) {
            Method getMethod = this.columns.get(columnIndex).getGetMethod();
            try {
                value = getMethod.invoke(this.data.get(rowIndex), new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public void setColumns(List<ObjectTableModelColumn> columns) throws SecurityException, NoSuchMethodException {
        this.columns = columns;
        this.findGetAndSetMethods();
        this.fireTableStructureChanged();
    }

    public void setData(List<K> data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public K getRow(int row) {
        return this.data != null && this.data.size() > row ? (K)this.data.get(row) : null;
    }

    private void findGetAndSetMethods() throws SecurityException, NoSuchMethodException {
        if (this.columns != null) {
            for (ObjectTableModelColumn column : this.columns) {
                column.findGetAndSetMethods(this.dataClass);
            }
        }
    }
}

