/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.tabela;

import jalis.util.Comparador;
import jalis.util.TableUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ModeloTabela
extends AbstractTableModel {
    private static String ARROW_UP = "\u25b2";
    private static String ARROW_DOWN = "\u25bc";
    ArrayList<String> nome_colunas = new ArrayList();
    ArrayList dados = new ArrayList();
    int coluna_ordenada = 0;
    boolean ordem_ascendente = false;
    JTable tabela;

    public ModeloTabela(JTable tabela) {
        this.tabela = tabela;
    }

    @Override
    public int getRowCount() {
        return this.dados.size();
    }

    @Override
    public int getColumnCount() {
        return this.nome_colunas.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser maior ou igual a zero.");
        }
        if (rowIndex > this.dados.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser menor que o tamanho da tabela.");
        }
        if (columnIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da coluna desejada deve ser maior ou igual a zero.");
        }
        if (columnIndex > ((Object[])this.dados.get(rowIndex)).length - 1) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da coluna desejada deve ser menor que a quantidade de colunas.");
        }
        return ((Object[])this.dados.get(rowIndex))[columnIndex];
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser maior ou igual a zero.");
        }
        if (rowIndex > this.dados.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser menor que o tamanho da tabela.");
        }
        if (columnIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da coluna desejada deve ser maior ou igual a zero.");
        }
        if (columnIndex > ((Object[])this.dados.get(rowIndex)).length - 1) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da coluna desejada deve ser menor que a quantidade de colunas.");
        }
        ((Object[])this.dados.get((int)rowIndex))[columnIndex] = value;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public int getColunaOrdenada() {
        return this.coluna_ordenada;
    }

    public void deleteRow(int row) {
        if (row < 0 && this.getRowCount() > 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser maior ou igual a zero.");
        }
        if (row > this.getRowCount() - 1 && this.getRowCount() > 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser menor que o tamanho da tabela.");
        }
        this.dados.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void setColumnNames(ArrayList column_names) {
        this.nome_colunas = column_names;
        this.fireTableStructureChanged();
    }

    public void addColumn(int index, String columnName) {
        this.nome_colunas.add(index, columnName);
        this.fireTableStructureChanged();
    }

    public void addColumn(String columnName) {
        this.nome_colunas.add(columnName);
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int col) {
        this.resetColumnNames();
        String arrow = this.ordem_ascendente ? ARROW_UP : ARROW_DOWN;
        return this.coluna_ordenada == col ? this.nome_colunas.get(col) + arrow : this.nome_colunas.get(col);
    }

    public void setData(ArrayList data) {
        this.dados.clear();
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            this.dados.add(itr.next());
        }
        this.fireTableDataChanged();
    }

    public void setSortedData(ArrayList new_data, int col) {
        this.setSortedData(new_data, col, true);
    }

    public void setSortedData(ArrayList new_data, int col, boolean manterOrdem) {
        this.setSortedData(new_data, col, manterOrdem, true);
    }

    public void setSortedData(ArrayList new_data, int col, boolean manterOrdem, boolean atualizarTabela) {
        this.dados.clear();
        this.dados.addAll(new_data);
        if (!manterOrdem) {
            this.ordem_ascendente = false;
        }
        if (this.dados.size() > 1) {
            this.sortRowsByColumn(col, false, atualizarTabela);
        }
        this.coluna_ordenada = col;
        this.fireTableDataChanged();
    }

    public Object[] getRow(int row) {
        if (row < 0 && this.getRowCount() > 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser maior ou igual a zero.");
        }
        if (row > this.getRowCount() - 1 && this.getRowCount() > 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser menor que o tamanho da tabela.");
        }
        return (Object[])this.dados.get(row);
    }

    public void setRow(int row, Object[] newdata) {
        if (row < 0 && this.getRowCount() > 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser maior ou igual a zero.");
        }
        if (row > this.getRowCount() - 1 && this.getRowCount() > 0) {
            throw new ArrayIndexOutOfBoundsException("O \u00edndice da linha desejada deve ser menor que o tamanho da tabela.");
        }
        this.dados.set(row, newdata);
        this.fireTableDataChanged();
    }

    public void addRow(Object[] row) {
        this.dados.add(row);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void addSortedRow(Object[] row) {
        this.dados.add(row);
        this.ordem_ascendente = !this.ordem_ascendente;
        this.sortRowsByColumn(this.coluna_ordenada, false);
        this.fireTableDataChanged();
    }

    public void resetColumnNames() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i >= this.tabela.getColumnCount()) continue;
            this.tabela.getTableHeader().getColumnModel().getColumn(i).setHeaderValue(this.nome_colunas.get(i));
        }
    }

    private void insereMarcadorOrdenacao(int col, boolean ascendente) {
        this.resetColumnNames();
        this.tabela.getTableHeader().getColumnModel().getColumn(col).setHeaderValue(this.nome_colunas.get(col) + (ascendente ? ARROW_UP : ARROW_DOWN));
        this.tabela.getTableHeader().resizeAndRepaint();
    }

    private void removeMarcadorOrdenacao(int col) {
        this.tabela.getTableHeader().getColumnModel().getColumn(col).setHeaderValue(this.nome_colunas.get(col));
        this.tabela.getTableHeader().resizeAndRepaint();
    }

    public void sortRowsByColumn(int col, boolean hold_selection) {
        this.sortRowsByColumn(col, hold_selection, true);
    }

    public void sortRowsByColumn(int col, boolean hold_selection, boolean mudarOrdem) {
        Object[] antiga;
        this.fireTableDataChanged();
        if (col >= this.getColumnCount()) {
            return;
        }
        Object[] objectArray = antiga = this.tabela.getSelectedRow() < 0 ? null : (Object[])((Object[])this.dados.get(this.tabela.getSelectedRow())).clone();
        if (col == this.coluna_ordenada) {
            if (mudarOrdem) {
                this.ordem_ascendente = !this.ordem_ascendente;
            }
            this.insereMarcadorOrdenacao(col, this.ordem_ascendente);
        } else {
            this.ordem_ascendente = true;
            this.removeMarcadorOrdenacao(this.coluna_ordenada);
            this.insereMarcadorOrdenacao(col, this.ordem_ascendente);
            this.coluna_ordenada = col;
        }
        Collections.sort(this.dados, new Comparador(col, this.ordem_ascendente ? 1 : -1));
        this.fireTableDataChanged();
        if (hold_selection && antiga != null) {
            for (int i = 0; i < this.dados.size(); ++i) {
                Object[] atual = (Object[])this.dados.get(i);
                if (!Arrays.equals(antiga, atual)) continue;
                this.tabela.setRowSelectionInterval(i, i);
                TableUtil.scrollToVisible(this.tabela, i);
                break;
            }
        }
    }

    private class DescendentComparator
    implements Comparator {
        private DescendentComparator() {
        }

        public int compare(Object a, Object b) {
            if (a instanceof String) {
                String i = a != null ? (String)a : "";
                String j = b != null ? (String)b : "";
                return j.compareTo(i);
            }
            if (a instanceof Boolean) {
                boolean i = (Boolean)a;
                boolean j = (Boolean)b;
                if (i && !j) {
                    return 1;
                }
                if (!i && j) {
                    return -1;
                }
                return 0;
            }
            if (a instanceof Integer && b instanceof Integer) {
                return ((Integer)b).compareTo((Integer)a);
            }
            return 0;
        }

        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }
    }

    private class AscendentComparator
    implements Comparator {
        private AscendentComparator() {
        }

        public int compare(Object a, Object b) {
            if (a instanceof String) {
                String i = a != null ? (String)a : "";
                String j = b != null ? (String)b : "";
                return i.compareTo(j);
            }
            if (a instanceof Boolean) {
                boolean i = (Boolean)a;
                boolean j = (Boolean)b;
                if (i && !j) {
                    return -1;
                }
                if (!i && j) {
                    return 1;
                }
                return 0;
            }
            if (a instanceof Integer && b instanceof Integer) {
                return ((Integer)a).compareTo((Integer)b);
            }
            return 0;
        }

        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }
    }
}

