/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.tabela;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class ModeloResultSet
extends AbstractTableModel
implements Cloneable,
MouseListener {
    protected String[] cols = new String[0];
    protected ArrayList<String> editaveis = new ArrayList();
    protected ArrayList<Registro> regs = new ArrayList();
    protected ArrayList<Registro> filtrados = new ArrayList();
    protected HashMap<String, ValorUnico> valoresUnicos = new HashMap();
    private boolean ordenar = false;
    private int colunaOrdenada = -1;
    private int ultCol = -1;
    private int ultSentido = -1;
    private int[] tamanhoColunas;
    private JTable tabela;

    public ModeloResultSet(String ... colunas) {
        if (colunas != null && colunas.length % 2 == 0) {
            this.cols = colunas;
        }
    }

    public ModeloResultSet(ResultSet dados, String ... colunas) {
        this(colunas);
        this.carregarDeResultSet(dados);
    }

    public void setColunas(String ... colunas) {
        if (colunas != null && colunas.length % 2 == 0) {
            this.cols = colunas;
            if (this.tamanhoColunas != null && this.tabela != null) {
                this.setTamanhoColunas(this.tabela, this.tamanhoColunas);
            }
        }
    }

    public void setOrdenarColunas(boolean b) {
        this.ordenar = b;
    }

    public boolean getOrdenarColunas() {
        return this.ordenar;
    }

    public void setColunaOrdenada(int coluna, int sentido) {
        if (coluna > -1 && coluna < this.cols.length) {
            this.ordenarColuna(coluna, sentido);
        }
    }

    public int getColunaOrdenada() {
        return this.ultCol;
    }

    public int getSentidoOrdenacao() {
        return this.ultSentido;
    }

    public void limpar() {
        this.limpar(true);
    }

    public void limpar(boolean atualizar) {
        this.ultSentido = -1;
        this.colunaOrdenada = -1;
        this.regs.clear();
        this.filtrados.clear();
        if (atualizar) {
            this.fireTableDataChanged();
        }
    }

    public void limparColunasEditaveis() {
        this.limparColunasEditaveis(true);
    }

    public void limparColunasEditaveis(boolean atualizar) {
        this.editaveis.clear();
        if (atualizar) {
            this.fireTableStructureChanged();
        }
    }

    public void setColunaEditavel(String coluna) {
        if (!this.editaveis.contains(coluna)) {
            this.editaveis.add(coluna);
        }
        this.fireTableStructureChanged();
    }

    public void setColunaValorUnico(String coluna, Object valorUnico, Object valorDefault) {
        this.valoresUnicos.put(coluna, new ValorUnico(valorUnico, valorDefault));
    }

    public int getIndice(Registro reg) {
        int indice = 0;
        for (Registro r : this.filtrados) {
            if (r == reg) {
                return indice;
            }
            ++indice;
        }
        return -1;
    }

    public int getIndice(String campo, Object valor) {
        int indice = 0;
        Object obj = null;
        for (Registro reg : this.filtrados) {
            obj = reg.getValor(campo);
            if (obj != null && obj.equals(valor)) {
                return indice;
            }
            ++indice;
        }
        return -1;
    }

    public void addRegistro(Registro reg) {
        if (reg != null) {
            this.regs.add(reg);
            this.filtrados.add(reg);
        }
    }

    public void addRegistros(Collection<Registro> regs) {
        if (regs != null) {
            this.regs.addAll(regs);
            this.filtrados.addAll(regs);
        }
    }

    public void addRegistros(Registro[] regs) {
        if (regs != null) {
            for (Registro r : regs) {
                this.regs.add(r);
                this.filtrados.add(r);
            }
        }
    }

    public void addRegistro(Registro reg, String campoDeOrdenacao) {
        ModeloResultSet.addRegistro(this.regs, reg, campoDeOrdenacao);
        ModeloResultSet.addRegistro(this.filtrados, reg, campoDeOrdenacao);
    }

    private static void addRegistro(List<Registro> list, Registro reg, String campoDeOrdenacao) {
        if (reg != null && campoDeOrdenacao != null) {
            int pos = -1;
            int cont = 0;
            int valor = reg.getInt(campoDeOrdenacao);
            for (Registro r : list) {
                if (r.getInt(campoDeOrdenacao) >= valor) {
                    pos = cont;
                    break;
                }
                ++cont;
            }
            if (pos == -1) {
                list.add(reg);
            } else {
                list.add(pos, reg);
            }
        }
    }

    public void filtrar(String campo, String str) {
        if (str != null) {
            this.filtrados.clear();
            if (str.matches(" *")) {
                this.filtrados.addAll(this.regs);
            } else {
                for (Registro reg : this.regs) {
                    String valor = reg.getString(campo);
                    if (!StringUtil.removerAcentos(valor).toLowerCase().contains(StringUtil.removerAcentos(str).toLowerCase())) continue;
                    this.filtrados.add(reg);
                }
            }
            this.fireTableDataChanged();
        }
    }

    public Registro getRegistro(int indice) {
        if (indice >= 0 && indice < this.filtrados.size()) {
            return this.filtrados.get(indice);
        }
        return null;
    }

    public List<Registro> getRegistros(int[] indices) {
        ArrayList<Registro> list = new ArrayList<Registro>();
        for (int i : indices) {
            Registro reg = this.getRegistro(i);
            if (reg == null) continue;
            list.add(reg);
        }
        return list;
    }

    public List<Registro> getRegistros() {
        return this.filtrados;
    }

    public void removerRegistro(Registro reg) {
        this.regs.remove(reg);
        this.filtrados.remove(reg);
    }

    public void removerRegistro(int indice) {
        this.removerRegistro(this.getRegistro(indice));
    }

    public void removerRegistros(int[] indices) {
        for (Registro reg : this.getRegistros(indices)) {
            this.removerRegistro(reg);
        }
    }

    public void carregarDeResultSet(ResultSet dados) {
        try {
            if (dados.first()) {
                this.regs.clear();
                this.filtrados.clear();
                do {
                    Registro reg = new Registro(dados);
                    this.regs.add(reg);
                    this.filtrados.add(reg);
                } while (dados.next());
                this.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean contemValor(String coluna, Object valor) {
        for (Registro reg : this.filtrados) {
            if (!reg.contemValor(coluna, valor)) continue;
            return true;
        }
        return false;
    }

    public boolean contemValor(String coluna, String valor) {
        for (Registro reg : this.filtrados) {
            if (!reg.contemValor(coluna, valor)) continue;
            return true;
        }
        return false;
    }

    public boolean contemValor(String coluna, Integer valor) {
        for (Registro reg : this.filtrados) {
            if (!reg.contemValor(coluna, valor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Registro reg = this.getRegistro(row);
        if (reg != null && col * 2 + 1 < this.cols.length) {
            return reg.getValor(this.cols[col * 2 + 1]);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Registro reg = this.getRegistro(row);
        if (reg != null && col * 2 + 1 < this.cols.length) {
            String coluna = this.cols[col * 2 + 1];
            reg.setValor(coluna, value);
            this.verificarValoresUnicos(coluna, value, row, col);
        }
    }

    private void verificarValoresUnicos(String coluna, Object value, int row, int col) {
        ValorUnico vu = this.valoresUnicos.get(coluna);
        if (vu != null && vu.valorUnico.equals(value)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Registro r = this.getRegistro(i);
                if (i == row || !vu.valorUnico.equals(r.getValor(coluna))) continue;
                r.setValor(coluna, vu.valorDefault);
                this.fireTableCellUpdated(i, col);
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        if (col * 2 < this.cols.length) {
            return this.cols[col * 2];
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex * 2 + 1 < this.cols.length) {
            return this.editaveis.contains(this.cols[columnIndex * 2 + 1]);
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.filtrados.size();
    }

    @Override
    public int getColumnCount() {
        return this.cols.length / 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object value;
        Registro reg;
        if (columnIndex * 2 + 1 < this.cols.length && (reg = this.getRegistro(0)) != null && (value = reg.getValor(this.cols[columnIndex * 2 + 1])) != null) {
            return value.getClass();
        }
        return Object.class;
    }

    public void setTamanhoColunas(JTable tabela, int ... tamanhoColunas) {
        if (tamanhoColunas != null && tabela != null && this.cols.length / 2 == tamanhoColunas.length) {
            this.tamanhoColunas = tamanhoColunas;
            this.tabela = tabela;
            for (int i = 0; i < tamanhoColunas.length; ++i) {
                if (tamanhoColunas[i] <= 0) continue;
                tabela.getColumnModel().getColumn(i).setPreferredWidth(tamanhoColunas[i]);
                tabela.getColumnModel().getColumn(i).setMinWidth(tamanhoColunas[i]);
                tabela.getColumnModel().getColumn(i).setMaxWidth(tamanhoColunas[i]);
            }
        }
    }

    public Object clone() {
        ModeloResultSet clone = null;
        try {
            clone = (ModeloResultSet)super.clone();
            clone.cols = (String[])this.cols.clone();
            clone.regs = (ArrayList)this.regs.clone();
            clone.filtrados = (ArrayList)this.filtrados.clone();
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return clone;
    }

    public void ordenarColuna(int col) {
        this.ultSentido = col == this.ultCol ? (this.ultSentido *= -1) : 1;
        this.ordenarColuna(col, this.ultSentido);
        this.fireTableDataChanged();
    }

    public void ordenarColunaSemMudarSentido(int col) {
        this.ordenarColuna(col, this.ultSentido);
        this.fireTableDataChanged();
    }

    public void ordenarColuna(final int col, final int sentido) {
        if (col > -1 && col < this.cols.length) {
            if (col != this.ultCol) {
                this.ultCol = col;
            }
            Collections.sort(this.filtrados, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String coluna = ModeloResultSet.this.cols[col * 2 + 1];
                    if (((Registro)o1).getValor(coluna) instanceof Number && ((Registro)o2).getValor(coluna) instanceof Number) {
                        return (((Registro)o1).getDouble(coluna) < ((Registro)o2).getDouble(coluna) ? -1 : (((Registro)o1).getDouble(coluna) == ((Registro)o2).getDouble(coluna) ? 0 : 1)) * sentido;
                    }
                    if (Funcoes.isNumeric(((Registro)o1).getString(coluna)) && Funcoes.isNumeric(((Registro)o2).getString(coluna))) {
                        return (Double.parseDouble(Funcoes.limpaDecimal(((Registro)o1).getString(coluna))) < Double.parseDouble(Funcoes.limpaDecimal(((Registro)o2).getString(coluna))) ? -1 : (Double.parseDouble(Funcoes.limpaDecimal(((Registro)o1).getString(coluna))) == Double.parseDouble(Funcoes.limpaDecimal(((Registro)o2).getString(coluna))) ? 0 : 1)) * sentido;
                    }
                    return ((Registro)o1).getString(coluna).toUpperCase().compareTo(((Registro)o2).getString(coluna).toUpperCase()) * sentido;
                }
            });
            if (this.tamanhoColunas != null && this.tabela != null) {
                this.setTamanhoColunas(this.tabela, this.tamanhoColunas);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int col;
        JTableHeader header;
        Rectangle rec;
        Object o = e.getSource();
        if (this.ordenar && o instanceof JTableHeader && (rec = (header = (JTableHeader)o).getHeaderRect(col = header.getColumnModel().getColumnIndexAtX(e.getX()))).contains(e.getPoint())) {
            this.ordenarColuna(col);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.ordenar && e.getSource() instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)e.getSource();
            header.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class ValorUnico {
        final Object valorUnico;
        final Object valorDefault;

        ValorUnico(Object valorUnico, Object valorDefault) {
            Funcoes.validarNaoNull(valorUnico, "valorUnico");
            Funcoes.validarNaoNull(valorDefault, "valorDefault");
            this.valorUnico = valorUnico;
            this.valorDefault = valorDefault;
        }
    }
}

