/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.tabela;

import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class CorTableCellRenderer
extends DefaultTableCellRenderer
implements Cloneable {
    private static Border bordaSemFoco = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private HashMap<Posicao, Color> cores = new HashMap();
    private HashMap<Posicao, String> hints = new HashMap();
    private HashMap<Coluna, Integer> alinhamentos = new HashMap();

    public static CorTableCellRenderer novaInstancia(int ... alinhamentos) {
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        for (int i = 0; i < alinhamentos.length; ++i) {
            if (alinhamentos[i] <= -1) continue;
            renderer.setAlinhamentoColuna(i, alinhamentos[i]);
        }
        return renderer;
    }

    public void limpar() {
        this.cores.clear();
        this.hints.clear();
    }

    public void limparAlinhamentos() {
        this.alinhamentos.clear();
    }

    public void setCorLinha(Color cor, int linha) {
        this.cores.put(new Linha(linha), cor);
    }

    public void setCorLinhas(Color cor, int[] linhas) {
        if (linhas != null) {
            for (int linha : linhas) {
                this.setCorLinha(cor, linha);
            }
        }
    }

    public void setCorLinhas(Color cor, List<Integer> linhas) {
        if (linhas != null) {
            for (Integer lin : linhas) {
                this.setCorLinha(cor, lin);
            }
        }
    }

    public void setCorColuna(Color cor, int coluna) {
        this.cores.put(new Coluna(coluna), cor);
    }

    public void setCorColunas(Color cor, int[] colunas) {
        if (colunas != null) {
            for (int coluna : colunas) {
                this.setCorColuna(cor, coluna);
            }
        }
    }

    public void setCorColunas(Color cor, List<Integer> colunas) {
        if (colunas != null) {
            for (Integer col : colunas) {
                this.setCorColuna(cor, col);
            }
        }
    }

    public void setCorCelula(Color cor, int linha, int coluna) {
        this.cores.put(new Celula(linha, coluna), cor);
    }

    public void setCorCelulas(Color cor, int[] linhas, int[] colunas) {
        if (linhas != null && colunas != null && linhas.length == colunas.length) {
            for (int i : linhas) {
                this.setCorCelula(cor, linhas[i], colunas[i]);
            }
        }
    }

    public void setCorCelulas(Color cor, List<Integer> linhas, List<Integer> colunas) {
        if (linhas != null && colunas != null && linhas.size() == colunas.size()) {
            for (int i = 0; i < linhas.size(); ++i) {
                this.setCorCelula(cor, linhas.get(i), colunas.get(i));
            }
        }
    }

    public void setAlinhamentoColuna(int coluna, int alin) {
        if (alin == 2 || alin == 0 || alin == 4) {
            this.alinhamentos.put(new Coluna(coluna), alin);
        }
    }

    public void setHintCelula(int linha, int coluna, String hint) {
        this.hints.put(new Celula(linha, coluna), hint);
    }

    public void setHintLinha(int linha, String hint) {
        this.hints.put(new Linha(linha), hint);
    }

    public void setHintColuna(int coluna, String hint) {
        this.hints.put(new Coluna(coluna), hint);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null) {
            this.setText(value == null ? "" : value.toString());
            Integer alin = this.alinhamentos.get(new Coluna(column));
            this.setHorizontalAlignment(alin != null ? alin : 2);
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : bordaSemFoco);
            Color cor = null;
            cor = isSelected ? table.getSelectionForeground() : (cor == null ? table.getForeground() : cor);
            this.setForeground(cor);
            cor = this.cores.get(new Celula(row, column));
            if (cor == null) {
                cor = this.cores.get(new Linha(row));
            }
            if (cor == null) {
                cor = this.cores.get(new Coluna(column));
            }
            if (cor == null) {
                cor = isSelected ? table.getSelectionBackground() : table.getBackground();
            } else if (isSelected) {
                cor = ScreenUtil.escurecerCor(cor, 30);
            }
            this.setBackground(cor);
            String hint = this.hints.get(new Celula(row, column));
            if (hint == null) {
                hint = this.hints.get(new Linha(row));
            }
            if (hint == null) {
                hint = this.hints.get(new Coluna(column));
            }
            this.setToolTipText(hint);
        }
        return this;
    }

    public Object clone() {
        try {
            CorTableCellRenderer renderer = (CorTableCellRenderer)super.clone();
            renderer.cores = (HashMap)this.cores.clone();
            return renderer;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    private class Celula
    implements Posicao {
        private int linha;
        private int coluna;

        public Celula(int lin, int col) {
            this.linha = lin;
            this.coluna = col;
        }

        public int hashCode() {
            return this.linha * this.coluna;
        }

        public boolean equals(Object o) {
            if (o instanceof Celula) {
                Celula cel = (Celula)o;
                return this.linha == cel.linha && this.coluna == cel.coluna;
            }
            return false;
        }
    }

    private class Coluna
    implements Posicao {
        private int coluna;

        public Coluna(int col) {
            this.coluna = col;
        }

        public int hashCode() {
            return this.coluna;
        }

        public boolean equals(Object o) {
            return o instanceof Coluna && this.coluna == ((Coluna)o).coluna;
        }
    }

    private class Linha
    implements Posicao {
        private int linha;

        public Linha(int lin) {
            this.linha = lin;
        }

        public int hashCode() {
            return this.linha;
        }

        public boolean equals(Object o) {
            return o instanceof Linha && this.linha == ((Linha)o).linha;
        }
    }

    private static interface Posicao {
    }
}

