/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.Funcoes;
import jalis.util.sql.DadosCampos;
import jalis.util.sql.SalvaDadosException;
import java.util.ArrayList;
import java.util.Date;

public class SalvaDados {
    public static final int INSERT = 0;
    public static final int DELETE = 1;
    public static final int UPDATE = 2;
    public static final int VALOR_CURRENT_TIMESTAMP = 0;
    public static final int VALOR_CURRENT_DATE = 1;
    public static final int VALOR_CURRENT_TIME = 2;
    private final String VALOR_NULL = "Valor null n\u00e3o permitido para o campo ";
    private int tipoOperacao = 0;
    private String tabela;
    private ArrayList<DadosCampos> campos = new ArrayList();
    private boolean mostrarComando = false;
    private boolean isAdicionarAspasSimplesString = true;

    public SalvaDados(String tabela) {
        this.setTabela(tabela);
    }

    public SalvaDados(String tabela, int operacao) {
        this.setTabela(tabela);
        this.setOperacao(operacao);
    }

    public SalvaDados() {
    }

    public void setOperacao(int operacao) {
        this.tipoOperacao = operacao;
    }

    public int getOperacao() {
        return this.tipoOperacao;
    }

    public void setTabela(String tabela) {
        this.tabela = tabela;
    }

    public String getTabela() {
        return this.tabela;
    }

    public void removerCampo(String nomeCampo) {
        int pos = -1;
        for (int i = 0; i < this.campos.size(); ++i) {
            DadosCampos c = this.campos.get(i);
            if (!c.getNome().equalsIgnoreCase(nomeCampo)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            this.campos.remove(pos);
        }
    }

    public void adicionaCampo(String nomeCampo, int tipoCampo, boolean permitirNull, boolean chavePrimaria) {
        this.campos.add(new DadosCampos(nomeCampo, tipoCampo, chavePrimaria, permitirNull));
    }

    public void adicionaCampo(String nomeCampo, int tipoCampo, boolean permitirNull, boolean chavePrimaria, Object valor) {
        DadosCampos c = new DadosCampos(nomeCampo, tipoCampo, chavePrimaria, permitirNull);
        c.setValor(valor);
        this.campos.add(c);
    }

    public void setValor(String nomeCampo, Object valor) {
        for (DadosCampos c : this.campos) {
            if (!c.getNome().equalsIgnoreCase(nomeCampo)) continue;
            c.setValor(valor);
            break;
        }
    }

    public void limpar() {
        this.campos.clear();
    }

    public String getComando() throws SalvaDadosException {
        String retorno = "";
        if (this.tipoOperacao == 0) {
            retorno = this.montaComandoInsert();
        } else if (this.tipoOperacao == 2) {
            retorno = this.montaComandoUpdate();
        } else if (this.tipoOperacao == 1) {
            retorno = this.montaComandoDelete();
        }
        if (this.mostrarComando) {
            System.out.println(retorno);
        }
        return retorno;
    }

    public String getSelect() throws SalvaDadosException {
        return this.montaComandoSelect();
    }

    private String montaComandoInsert() throws SalvaDadosException {
        StringBuilder fields = new StringBuilder();
        StringBuilder values = new StringBuilder("");
        for (int i = 0; i < this.campos.size(); ++i) {
            DadosCampos campo = this.campos.get(i);
            fields.append(campo.getNome());
            if (i < this.campos.size() - 1) {
                fields.append(", ");
            }
            if (campo.getValor() == null || campo.getTipo() != 0 && (Funcoes.textoVazio(campo.getValor().toString()) || campo.getValor().toString().equalsIgnoreCase("null"))) {
                if (campo.getPermitirNull()) {
                    values.append("null");
                } else {
                    new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
                }
            } else if (campo.getTipo() == 2) {
                if (Funcoes.isNumeric(campo.getValor().toString())) {
                    values.append(campo.getValor().toString());
                }
            } else if (campo.getTipo() == 4) {
                if (campo.getValor() != null) {
                    values.append(campo.getValor() instanceof Boolean && (Boolean)campo.getValor() != false ? "TRUE" : "FALSE");
                }
            } else if (campo.getTipo() == 0) {
                if (this.isAdicionarAspasSimplesString) {
                    values.append("'");
                }
                values.append(campo.getValor().toString());
                if (this.isAdicionarAspasSimplesString) {
                    values.append("'");
                }
            } else if (campo.getTipo() == 5) {
                if (campo.getValor() instanceof Date) {
                    values.append("'");
                    values.append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", (Date)campo.getValor()));
                    values.append("'");
                } else if (Funcoes.verificaTimestamp(campo.getValor().toString())) {
                    values.append("'");
                    values.append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", campo.getValor().toString()));
                    values.append("'");
                } else if (campo.getValor() instanceof Integer) {
                    if (campo.getValor().equals(0)) {
                        values.append("'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("'");
                    } else {
                        values.append("null");
                    }
                } else if (!campo.getPermitirNull()) {
                    new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
                } else {
                    values.append("null");
                }
            } else if (campo.getTipo() == 1) {
                if (campo.getValor() instanceof Date) {
                    values.append("'");
                    values.append(Funcoes.formataData("MM/dd/yyyy", (Date)campo.getValor()));
                    values.append("'");
                } else if (Funcoes.verificaData(campo.getValor().toString())) {
                    values.append("'");
                    values.append(Funcoes.formataData("MM/dd/yyyy", campo.getValor().toString()));
                    values.append("'");
                } else if (campo.getValor() instanceof Integer) {
                    if (campo.getValor().equals(1)) {
                        values.append("'").append(Funcoes.formataData("yyyy-MM-dd", new Date())).append("'");
                    } else {
                        values.append("null");
                    }
                } else if (!campo.getPermitirNull()) {
                    new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
                } else {
                    values.append("null");
                }
            } else if (campo.getTipo() == 3) {
                if (Funcoes.verificaHora(campo.getValor().toString())) {
                    values.append("'");
                    values.append(campo.getValor().toString());
                    values.append("'");
                } else if (campo.getValor() instanceof Integer) {
                    if (campo.getValor().equals(2)) {
                        values.append("'").append(Funcoes.formataData("HH:mm:ss", new Date()));
                    } else {
                        values.append("null");
                    }
                } else if (!campo.getPermitirNull()) {
                    new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
                } else {
                    values.append("null");
                }
            } else if (campo.getTipo() == 6) {
                if (Funcoes.verificaIntervaloHora(campo.getValor().toString())) {
                    values.append("'");
                    values.append(campo.getValor().toString());
                    values.append("'");
                } else if (!campo.getPermitirNull()) {
                    new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
                } else {
                    values.append("null");
                }
            }
            if (i >= this.campos.size() - 1) continue;
            values.append(", ");
        }
        StringBuilder retorno = new StringBuilder("insert into ");
        retorno.append(this.tabela);
        retorno.append(" (");
        retorno.append((CharSequence)fields);
        retorno.append(") values (");
        retorno.append((CharSequence)values);
        retorno.append(")");
        return retorno.toString();
    }

    private String montaComandoUpdate() {
        StringBuilder pk = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        for (int i = 0; i < this.campos.size(); ++i) {
            DadosCampos campo = this.campos.get(i);
            if (campo.getPK()) {
                if (pk.length() > 0) {
                    pk.append(" and ");
                }
                pk.append(this.montaCampoUpdate(campo));
                continue;
            }
            if (valores.length() > 0) {
                valores.append(", ");
            }
            valores.append(this.montaCampoUpdate(campo));
        }
        StringBuilder retorno = new StringBuilder("update ");
        retorno.append(this.tabela);
        retorno.append(" set ");
        retorno.append((CharSequence)valores);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private String montaComandoSelect() {
        StringBuilder pk = new StringBuilder();
        StringBuilder camposBusca = new StringBuilder("");
        for (int i = 0; i < this.campos.size(); ++i) {
            DadosCampos campo = this.campos.get(i);
            if (!campo.getPK()) continue;
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            if (camposBusca.length() > 0) {
                camposBusca.append(", ");
            }
            camposBusca.append(campo.getNome());
            pk.append(this.montaCampoUpdate(campo));
        }
        StringBuilder retorno = new StringBuilder("select ");
        retorno.append((CharSequence)camposBusca);
        retorno.append(" from ");
        retorno.append(this.tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private String montaCampoUpdate(DadosCampos campo) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(campo.getNome());
        tmp.append(" = ");
        if (campo.getValor() == null || campo.getTipo() != 0 && Funcoes.textoVazio(campo.getValor().toString())) {
            if (campo.getPermitirNull()) {
                tmp.append("null");
            } else {
                new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
            }
        } else if (campo.getTipo() == 2) {
            tmp.append(campo.getValor().toString());
        } else if (campo.getTipo() == 0) {
            if (this.isAdicionarAspasSimplesString) {
                tmp.append("'");
            }
            tmp.append(campo.getValor().toString());
            if (this.isAdicionarAspasSimplesString) {
                tmp.append("'");
            }
        } else if (campo.getTipo() == 5) {
            if (Funcoes.verificaTimestamp(campo.getValor().toString())) {
                tmp.append("'");
                tmp.append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", campo.getValor().toString()));
                tmp.append("'");
            } else if (campo.getValor() instanceof Integer) {
                if (campo.getValor().equals(0)) {
                    tmp.append("'");
                    tmp.append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date()));
                    tmp.append("'");
                } else {
                    tmp.append("null");
                }
            } else if (!campo.getPermitirNull()) {
                new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipo() == 1) {
            if (campo.getValor() instanceof Date) {
                tmp.append("'");
                tmp.append(Funcoes.formataData("MM/dd/yyyy", (Date)campo.getValor()));
                tmp.append("'");
            } else if (Funcoes.verificaData(campo.getValor().toString())) {
                tmp.append("'");
                tmp.append(Funcoes.formataData("MM/dd/yyyy", campo.getValor().toString()));
                tmp.append("'");
            } else if (campo.getValor() instanceof Integer) {
                if (campo.getValor().equals(1)) {
                    tmp.append("current_date");
                } else {
                    tmp.append("null");
                }
            } else if (!campo.getPermitirNull()) {
                new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipo() == 3) {
            if (Funcoes.verificaHora(campo.getValor().toString())) {
                tmp.append("'");
                tmp.append(campo.getValor().toString());
                tmp.append("'");
            } else if (campo.getValor() instanceof Integer) {
                if (campo.getValor().equals(2)) {
                    tmp.append("current_time");
                } else {
                    tmp.append("null");
                }
            } else if (!campo.getPermitirNull()) {
                new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipo() == 4) {
            if (campo.getValor() instanceof Boolean) {
                tmp.append((Boolean)campo.getValor() != false ? "TRUE" : "FALSE");
            } else if (!campo.getPermitirNull()) {
                new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipo() == 6) {
            if (Funcoes.verificaIntervaloHora(campo.getValor().toString())) {
                tmp.append("'");
                tmp.append(campo.getValor().toString());
                tmp.append("'");
            } else if (!campo.getPermitirNull()) {
                new SalvaDadosException("Valor null n\u00e3o permitido para o campo " + campo.getNome());
            } else {
                tmp.append("null");
            }
        }
        return tmp.toString();
    }

    private String montaComandoDelete() {
        StringBuilder pk = new StringBuilder();
        for (int i = 0; i < this.campos.size(); ++i) {
            DadosCampos campo = this.campos.get(i);
            if (!campo.getPK()) continue;
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(this.montaCampoUpdate(campo));
        }
        StringBuilder retorno = new StringBuilder("delete from ");
        retorno.append(this.tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    public boolean isMostrarComando() {
        return this.mostrarComando;
    }

    public void setMostrarComando(boolean mostrarComando) {
        this.mostrarComando = mostrarComando;
    }

    public void setAdicionarAspasSimplesString(boolean isAdicionarAspasSimplesString) {
        this.isAdicionarAspasSimplesString = isAdicionarAspasSimplesString;
    }
}

