/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.sql.SQLScanner;
import jalis.util.sql.SQLTokens;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class SQLStyledDocument
extends DefaultStyledDocument {
    private Map<SQLTokens, AttributeSet> atributos = new HashMap<SQLTokens, AttributeSet>();

    public SQLStyledDocument() {
        SimpleAttributeSet temp = new SimpleAttributeSet();
        this.atributos.put(SQLTokens.IDENTIFICADOR, temp);
        this.atributos.put(SQLTokens.DESCONHECIDO, temp);
        temp = new SimpleAttributeSet();
        StyleConstants.setBold(temp, true);
        this.atributos.put(SQLTokens.KEYWORD, temp);
        temp = new SimpleAttributeSet();
        StyleConstants.setForeground(temp, Color.red);
        this.atributos.put(SQLTokens.TEXTO, temp);
        temp = new SimpleAttributeSet();
        StyleConstants.setForeground(temp, Color.blue);
        this.atributos.put(SQLTokens.SEPARADOR, temp);
        this.atributos.put(SQLTokens.NUMERO, temp);
        temp = new SimpleAttributeSet();
        StyleConstants.setForeground(temp, new Color(0, 100, 0));
        this.atributos.put(SQLTokens.COMENTARIO, temp);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int ini;
        String conteudo = this.getText(0, this.getLength());
        boolean desfezComentario = offs > 0 && offs < conteudo.length() && (conteudo.charAt(offs) == '*' && (conteudo.charAt(offs - 1) == '/' || offs < conteudo.length() - 1 && conteudo.charAt(offs + 1) == '/') || conteudo.charAt(offs) == '/' && (conteudo.charAt(offs - 1) == '*' || offs < conteudo.length() - 1 && conteudo.charAt(offs + 1) == '*'));
        super.insertString(offs, str, a);
        conteudo = this.getText(0, this.getLength());
        int fim = offs + str.length() - 1;
        int len = conteudo.length();
        for (ini = offs; ini > 0 && !Character.isWhitespace(conteudo.charAt(ini - 1)); --ini) {
        }
        while (fim < len - 1 && !Character.isWhitespace(conteudo.charAt(fim + 1))) {
            ++fim;
        }
        String trecho = conteudo.substring(ini, fim + 1);
        Contexto ctx = SQLStyledDocument.getContexto(conteudo, ini);
        if (desfezComentario || trecho.contains("/*") || trecho.contains("*/") || trecho.contains("'")) {
            ini = 0;
            fim = conteudo.length() - 1;
        } else if (ctx != Contexto.NORMAL) {
            String fecha;
            String abre = ctx == Contexto.COMENTARIO ? "/*" : "'";
            String string = fecha = ctx == Contexto.COMENTARIO ? "*/" : "'";
            if (!trecho.contains(fecha)) {
                return;
            }
            ini = conteudo.lastIndexOf(abre, ini);
            fim = conteudo.length() - 1;
        }
        this.destacarTokens(ini, fim - ini + 1);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        int ini;
        String trecho = this.getText(offs, len);
        super.remove(offs, len);
        if (len == 0) {
            return;
        }
        String conteudo = this.getText(0, this.getLength());
        int fim = offs;
        for (ini = offs; ini > 0 && ini < conteudo.length() && Character.isWhitespace(conteudo.charAt(ini)); --ini) {
        }
        while (ini > 0 && !Character.isWhitespace(conteudo.charAt(ini - 1))) {
            --ini;
        }
        while (fim < conteudo.length() - 1 && Character.isWhitespace(conteudo.charAt(fim))) {
            ++fim;
        }
        while (fim < conteudo.length() - 1 && !Character.isWhitespace(fim + 1)) {
            ++fim;
        }
        Contexto ctx = SQLStyledDocument.getContexto(conteudo, ini);
        if (trecho.contains("/*") || trecho.contains("*/") || trecho.contains("'") || trecho.charAt(0) == '*' && offs > 0 && conteudo.charAt(offs - 1) == '/' || trecho.charAt(0) == '/' && offs > 0 && conteudo.charAt(offs - 1) == '*' || trecho.charAt(trecho.length() - 1) == '*' && offs < conteudo.length() && conteudo.charAt(offs) == '/' || trecho.charAt(trecho.length() - 1) == '/' && offs < conteudo.length() && conteudo.charAt(offs) == '*') {
            ini = 0;
            fim = conteudo.length() - 1;
        } else if (ctx != Contexto.NORMAL) {
            String fecha;
            String abre = ctx == Contexto.COMENTARIO ? "/*" : "'";
            String string = fecha = ctx == Contexto.COMENTARIO ? "*/" : "'";
            if (!trecho.contains(abre) && !trecho.contains(fecha)) {
                return;
            }
            ini = 0;
            fim = conteudo.length() - 1;
        }
        this.destacarTokens(ini, fim - ini + 1);
    }

    private void destacarTokens(int offs, int len) throws BadLocationException {
        this.setParagraphAttributes(offs, len, this.atributos.get((Object)SQLTokens.DESCONHECIDO), true);
        SQLScanner scanner = new SQLScanner(this.getText(offs, len));
        scanner.proximo();
        while (scanner.token != SQLTokens.EOF) {
            this.setCharacterAttributes(scanner.posToken + offs, scanner.lexTamanho, this.atributos.get((Object)scanner.token), true);
            scanner.proximo();
        }
    }

    private static Contexto getContexto(String conteudo, int offset) {
        Contexto ctx = Contexto.NORMAL;
        if (offset < conteudo.length()) {
            block5: for (int pos = 0; pos < offset; ++pos) {
                switch (conteudo.charAt(pos)) {
                    case '\'': {
                        if (ctx == Contexto.NORMAL) {
                            ctx = Contexto.TEXTO;
                            continue block5;
                        }
                        if (ctx != Contexto.TEXTO) continue block5;
                        ctx = Contexto.NORMAL;
                        continue block5;
                    }
                    case '*': {
                        if (pos <= 0 || conteudo.charAt(pos - 1) != '/' || ctx != Contexto.NORMAL) continue block5;
                        ctx = Contexto.COMENTARIO;
                        continue block5;
                    }
                    case '/': {
                        if (pos <= 0 || conteudo.charAt(pos - 1) != '*' || ctx != Contexto.COMENTARIO) continue block5;
                        ctx = Contexto.NORMAL;
                    }
                }
            }
        }
        return ctx;
    }

    private static enum Contexto {
        NORMAL,
        TEXTO("'"),
        COMENTARIO("/*");

        String padrao;

        private Contexto() {
            this("");
        }

        private Contexto(String padrao) {
            this.padrao = padrao;
        }
    }
}

