/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.sql.SQLTokens;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

class SQLScanner {
    private static final char NULO = '\u0000';
    SQLTokens token;
    int posToken;
    int lexTamanho;
    private String exp;
    private char ch;
    private int pos;
    private Set<String> keywords = new HashSet<String>();

    public SQLScanner(String sql) {
        this.exp = sql;
        this.pos = 0;
        this.token = SQLTokens.DESCONHECIDO;
        this.lexTamanho = 0;
        this.posToken = -1;
        this.carregarKeywords();
        this.scanChar();
    }

    public void proximo() {
        while (Character.isWhitespace(this.ch)) {
            this.scanChar();
        }
        this.posToken = this.pos - 1;
        this.lexTamanho = 0;
        switch (this.ch) {
            case '\u0000': {
                this.token = SQLTokens.EOF;
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                ++this.lexTamanho;
                this.scanChar();
                this.scanIdentOuKeyword();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                ++this.lexTamanho;
                this.scanChar();
                this.scanNumero();
                break;
            }
            case '.': {
                ++this.lexTamanho;
                this.scanChar();
                if (Character.isDigit(this.ch)) {
                    this.scanParteDecimal();
                    break;
                }
                this.token = SQLTokens.SEPARADOR;
                break;
            }
            case '\'': {
                ++this.lexTamanho;
                this.scanChar();
                this.scanTexto();
                break;
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ';': 
            case '<': 
            case '=': 
            case '>': {
                ++this.lexTamanho;
                char tmp = this.ch;
                this.scanChar();
                if (tmp == '/' && this.ch == '*') {
                    ++this.lexTamanho;
                    this.scanChar();
                    this.scanComentario();
                    break;
                }
                if ((tmp == '>' || tmp == '<') && (this.ch == '=' || tmp == '<' && this.ch == '>')) {
                    ++this.lexTamanho;
                    this.scanChar();
                }
                this.token = SQLTokens.SEPARADOR;
                break;
            }
            default: {
                this.token = SQLTokens.DESCONHECIDO;
                this.scanChar();
            }
        }
    }

    private void scanIdentOuKeyword() {
        while (Character.isLetterOrDigit(this.ch) || this.ch == '_') {
            ++this.lexTamanho;
            this.scanChar();
        }
        this.token = this.keyword(this.exp.substring(this.posToken, this.posToken + this.lexTamanho)) ? SQLTokens.KEYWORD : SQLTokens.IDENTIFICADOR;
    }

    private void scanNumero() {
        this.scanInteiros();
        if (this.ch == '.' || this.ch == 'E' || this.ch == 'e') {
            ++this.lexTamanho;
            if (this.ch == '.') {
                this.scanChar();
                this.scanParteDecimal();
            } else {
                this.scanChar();
                this.scanParteExponencial();
            }
        } else {
            this.token = SQLTokens.NUMERO;
        }
    }

    private void scanInteiros() {
        while (Character.isDigit(this.ch)) {
            ++this.lexTamanho;
            this.scanChar();
        }
    }

    private void scanParteDecimal() {
        this.scanInteiros();
        if (this.ch == 'E' || this.ch == 'e') {
            ++this.lexTamanho;
            this.scanChar();
            this.scanParteExponencial();
        } else {
            this.token = SQLTokens.NUMERO;
        }
    }

    private void scanParteExponencial() {
        if (this.ch == '+' || this.ch == '-') {
            ++this.lexTamanho;
            this.scanChar();
        }
        this.scanInteiros();
        this.token = SQLTokens.NUMERO;
    }

    private void scanTexto() {
        ++this.lexTamanho;
        int tmp = 0;
        while (this.ch != '\u0000' && (this.ch != '\'' || tmp == 92)) {
            tmp = this.ch;
            this.scanChar();
            if (this.ch == '\u0000') continue;
            ++this.lexTamanho;
        }
        this.token = SQLTokens.TEXTO;
        this.scanChar();
    }

    private void scanComentario() {
        int tmp = 0;
        ++this.lexTamanho;
        while (this.ch != '\u0000' && (tmp != 42 || this.ch != '/')) {
            tmp = this.ch;
            this.scanChar();
            if (this.ch == '\u0000') continue;
            ++this.lexTamanho;
        }
        this.token = SQLTokens.COMENTARIO;
        this.scanChar();
    }

    private boolean keyword(String lex) {
        return this.keywords.contains(lex.toLowerCase());
    }

    private void scanChar() {
        this.ch = this.pos < this.exp.length() ? this.exp.charAt(this.pos++) : (char)'\u0000';
    }

    private void carregarKeywords() {
        ResourceBundle rb = ResourceBundle.getBundle("jalis.util.sql.SQLKeywords");
        String str = rb.getString("keywords");
        for (String key : rb.getString("keywords").split("\\s+")) {
            this.keywords.add(key.toLowerCase());
        }
    }
}

