/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ExportaConsulta;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.table.TableModel;

public class ExportaParaTexto
implements ExportaConsulta {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportar(TableModel modelo, String arquivo) {
        if (modelo != null && arquivo != null) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(arquivo));
                int[] cols = this.calculaColunas(modelo);
                int linha = 0;
                int coluna = 0;
                if (coluna < cols.length) {
                    StringBuilder temp = new StringBuilder();
                    writer.write(32);
                    temp.append('-');
                    writer.write(StringUtil.preencheString(modelo.getColumnName(coluna), cols[coluna], ' ', 2));
                    temp.append(StringUtil.preencheString("", cols[coluna++], '-', 0));
                    while (coluna < cols.length) {
                        writer.write(" | ");
                        temp.append("-+-");
                        writer.write(StringUtil.preencheString(modelo.getColumnName(coluna), cols[coluna], ' ', 2));
                        temp.append(StringUtil.preencheString("", cols[coluna++], '-', 0));
                    }
                    writer.write(" \n");
                    writer.write(temp.toString());
                    writer.write("-\n");
                }
                while (linha < modelo.getRowCount()) {
                    coluna = 0;
                    if (0 < cols.length) {
                        Object valor = modelo.getValueAt(linha, coluna);
                        writer.write(32);
                        writer.write(StringUtil.preencheString(StringUtil.notNull(valor), cols[coluna++], ' ', this.getAlinhamento(valor)));
                        while (coluna < cols.length) {
                            valor = modelo.getValueAt(linha, coluna);
                            writer.write(" | ");
                            writer.write(StringUtil.preencheString(StringUtil.notNull(valor), cols[coluna++], ' ', this.getAlinhamento(valor)));
                        }
                        writer.write(" \n");
                    }
                    ++linha;
                }
            }
            catch (IOException ioe) {
                ErrorLogger.mostraMensagem(null, ioe.getMessage(), ioe.getStackTrace());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
    }

    private int[] calculaColunas(TableModel modelo) {
        int[] cols = new int[modelo.getColumnCount()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = Math.max(10, modelo.getColumnName(i).length());
        }
        for (int row = 0; row < modelo.getRowCount(); ++row) {
            for (int col = 0; col < modelo.getColumnCount(); ++col) {
                cols[col] = Math.max(cols[col], StringUtil.notNull(modelo.getValueAt(row, col)).length());
            }
        }
        return cols;
    }

    private int getAlinhamento(Object valor) {
        if (valor instanceof Number) {
            return 1;
        }
        if (valor instanceof Boolean) {
            return 2;
        }
        return 0;
    }
}

