/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ExportaConsulta;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.table.TableModel;

public class ExportaParaHTML
implements ExportaConsulta {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportar(TableModel modelo, String arquivo) {
        if (modelo != null && arquivo != null) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(arquivo));
                writer.write("<html>\n<body>\n\n<table align=\"center\" border=1 style=\"border:1px solid black\">\n");
                int linha = 0;
                int coluna = 0;
                if (coluna < modelo.getColumnCount()) {
                    writer.write("  <tr>");
                    while (coluna < modelo.getColumnCount()) {
                        writer.write("<td align=\"center\">");
                        writer.write(modelo.getColumnName(coluna++));
                        writer.write("</td>");
                    }
                    writer.write("</tr>\n");
                }
                while (linha < modelo.getRowCount()) {
                    coluna = 0;
                    if (0 < modelo.getColumnCount()) {
                        writer.write("  <tr>");
                        while (coluna < modelo.getColumnCount()) {
                            Object valor = modelo.getValueAt(linha, coluna++);
                            writer.write("<td");
                            writer.write(this.getAlinhamento(valor));
                            writer.write(62);
                            writer.write(this.tratarValor(valor));
                            writer.write("</td>");
                        }
                        writer.write("</tr>\n");
                    }
                    ++linha;
                }
                writer.write("</table>\n\n</body>\n</html>");
            }
            catch (IOException ioe) {
                ErrorLogger.mostraMensagem(null, ioe.getMessage(), ioe.getStackTrace());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
    }

    private String getAlinhamento(Object value) {
        if (value instanceof Number) {
            return " align=\"right\"";
        }
        if (value instanceof Boolean) {
            return " align=\"center\"";
        }
        return " align=\"left\"";
    }

    private String tratarValor(Object valor) {
        String v = StringUtil.notNull(valor);
        return v.matches(" *") ? "&nbsp;" : v;
    }
}

