/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ExportaConsulta;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.table.TableModel;

public class ExportaParaCSV
implements ExportaConsulta {
    private char separador;

    public ExportaParaCSV() {
        this(',');
    }

    public ExportaParaCSV(char separador) {
        this.separador = separador;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportar(TableModel modelo, String arquivo) {
        if (modelo != null && arquivo != null) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(arquivo));
                int linha = 0;
                int coluna = 0;
                if (coluna < modelo.getColumnCount()) {
                    writer.write(modelo.getColumnName(coluna++));
                    while (coluna < modelo.getColumnCount()) {
                        writer.write(this.separador);
                        writer.write(modelo.getColumnName(coluna++));
                    }
                    writer.write(10);
                }
                while (linha < modelo.getRowCount()) {
                    coluna = 0;
                    if (0 < modelo.getColumnCount()) {
                        writer.write(StringUtil.notNull(modelo.getValueAt(linha, coluna++)));
                        while (coluna < modelo.getColumnCount()) {
                            writer.write(this.separador);
                            writer.write(StringUtil.notNull(modelo.getValueAt(linha, coluna++)));
                        }
                    }
                    writer.write(10);
                    ++linha;
                }
            }
            catch (IOException ioe) {
                ErrorLogger.mostraMensagem(null, ioe.getMessage(), ioe.getStackTrace());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
    }
}

