/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.util.sql.AbstractConstrutorSQL;
import jalis.util.sql.ConstrutorException;

public class ConstrutorInsert
extends AbstractConstrutorSQL {
    public ConstrutorInsert(String tabela) throws ConstrutorException {
        this.setTabela(tabela);
    }

    public void setTabela(String tabela) throws ConstrutorException {
        if (tabela == null) {
            throw new ConstrutorException("O par\u00e2metro tabela n\u00e3o pode ser nulo.");
        }
        if (tabela.matches("[ ]+")) {
            throw new ConstrutorException("O par\u00e2metro tabela n\u00e3o pode ser uma string vazia.");
        }
        this.tabela = tabela;
    }

    public void limpar() {
        this.campos.clear();
        this.valores.clear();
    }

    public void limpar(String tabela) throws ConstrutorException {
        this.setTabela(tabela);
        this.limpar();
    }

    public void addCampoValor(String campo, Object valor) throws ConstrutorException {
        this.addCampoValor(campo, valor, false);
    }

    public void addCampoValor(String campo, Object valor, boolean aspas) throws ConstrutorException {
        if (campo == null) {
            throw new ConstrutorException("O par\u00e2metro campo n\u00e3o pode ser nulo.");
        }
        if (campo.matches("[ ]+")) {
            throw new ConstrutorException("O par\u00e2metro campo n\u00e3o pode ser uma string vazia.");
        }
        if (valor == null) {
            throw new ConstrutorException("O par\u00e2metro valor n\u00e3o pode ser nulo.");
        }
        if (valor.toString().matches("[ ]+")) {
            throw new ConstrutorException("O par\u00e2metro valor n\u00e3o pode ser uma string vazia.");
        }
        String tmp = aspas ? "'" : "";
        this.campos.add(campo);
        this.valores.add(tmp + valor.toString() + tmp);
    }

    public void trocaCampoValor(String campo, Object valor, boolean aspas) throws ConstrutorException {
        if (campo == null) {
            throw new ConstrutorException("O par\u00e2metro campo n\u00e3o pode ser nulo.");
        }
        if (campo.matches("[ ]+")) {
            throw new ConstrutorException("O par\u00e2metro campo n\u00e3o pode ser uma string vazia.");
        }
        if (valor == null) {
            throw new ConstrutorException("O par\u00e2metro valor n\u00e3o pode ser nulo.");
        }
        if (valor.toString().matches("[ ]+")) {
            throw new ConstrutorException("O par\u00e2metro valor n\u00e3o pode ser uma string vazia.");
        }
        String tmp = aspas ? "'" : "";
        int pos = this.campos.indexOf(campo);
        if (pos > -1) {
            this.valores.set(pos, tmp + valor.toString() + tmp);
        } else {
            this.campos.add(campo);
            this.valores.add(tmp + valor.toString() + tmp);
        }
    }

    @Override
    public String getSQL() {
        StringBuilder bui = new StringBuilder("insert into ");
        bui.append(this.tabela);
        bui.append("(");
        bui.append(this.concatenar(this.campos));
        bui.append(") values(");
        bui.append(this.concatenar(this.valores));
        bui.append(")");
        return bui.toString();
    }

    public String getSelect() {
        StringBuilder bui = new StringBuilder("select ");
        bui.append(this.concatenar(this.campos));
        bui.append(" from ").append(this.tabela);
        bui.append(" where ");
        for (int i = 0; i < this.campos.size(); ++i) {
            bui.append((String)this.campos.get(i)).append(" = ").append((String)this.valores.get(i));
            if (i == this.campos.size() - 1) continue;
            bui.append(" and ");
        }
        return bui.toString();
    }

    public String toString() {
        return this.getSQL();
    }
}

