/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sql;

import jalis.comum.Conexao;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.util.Funcoes;
import jalis.util.NumeroLinhas;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ExportaConsulta;
import jalis.util.sql.ExportadorFactory;
import jalis.util.sql.SQLStyledDocument;
import jalis.util.sql.SolicitarSeparador;
import jalis.util.sql.SolicitarVariavel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConsoleSQL
extends JPanel
implements ActionListener {
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private JTextPane textSQL = ComponenteFactory.novoJTextPane(null, new Font("Monospaced", 0, 12));
    private SQLStyledDocument styledDoc = new SQLStyledDocument();
    private JPanel panelRetorno = new JPanel(new BorderLayout());
    private JPanel panelBase = new JPanel(new BorderLayout());
    private JProgressBar progress = new JProgressBar();
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'I', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'x', this, null, null);
    private JButton buttonExecParar = ComponenteFactory.novoJButton("Executar", 'E', this, null, null);
    private JButton buttonLimpar = ComponenteFactory.novoJButton("Limpar", 'L', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JSplitPane split;
    private TableModel modeloConsulta;
    private DefaultListModel modelHistorico = new DefaultListModel();
    private JList listHistorico = null;
    private JScrollPane scrollHistorico = null;
    private JButton buttonHistorico = ComponenteFactory.novoJButton("Hist\u00f3rico", 'H', this, null, null);
    private JSplitPane splitHistorico = null;
    private JPopupMenu popupExportar = new JPopupMenu();
    private JMenuItem itemExportarSQL = new JMenuItem("Instru\u00e7\u00e3o SQL");
    private JMenuItem itemExportarResultado = new JMenuItem("Resultado");
    private int posHistorico = -1;
    private boolean executando;
    private boolean alterouBanco;
    private JLabel labelCronometro = new JLabel("", 0);
    private Timer cronometro = new Timer(1000, this);
    private long tempo = 0L;
    private Statement st = null;
    private Executar executar;

    public ConsoleSQL() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Console SQL", "Executa comandos SQL na base de dados", "configuracoes/console_sql.jpg");
        JScrollPane scroll = new JScrollPane(this.textSQL);
        scroll.setRowHeaderView(new NumeroLinhas(this.textSQL));
        this.textSQL.setStyledDocument(this.styledDoc);
        this.textSQL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConsoleSQL.this.habilitarDesabilitarBotoes();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConsoleSQL.this.habilitarDesabilitarBotoes();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConsoleSQL.this.habilitarDesabilitarBotoes();
            }
        });
        this.split = new JSplitPane(0, scroll, this.panelBase);
        this.split.setDividerLocation(100);
        this.split.setDividerSize(2);
        this.panelBase.add((Component)this.panelRetorno, "Center");
        this.panelBase.add((Component)this.progress, "South");
        this.add((Component)this.split, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "South");
        JPanel panelAux = new JPanel(new FlowLayout(0, 3, 3));
        panel.add((Component)panelAux, "West");
        panelAux.add(this.buttonImportar);
        panelAux.add(this.buttonExportar);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        panel.add((Component)panelAux, "Center");
        panelAux.add(this.buttonExecParar);
        panelAux.add(this.buttonHistorico);
        panelAux.add(this.buttonLimpar);
        panelAux.add(this.buttonFechar);
        this.progress.setVisible(false);
        this.habilitarDesabilitarBotoes();
        this.definirTeclas();
        this.cronometro.setInitialDelay(0);
        this.itemExportarResultado.addActionListener(this);
        this.itemExportarSQL.addActionListener(this);
        this.popupExportar.add(this.itemExportarResultado);
        this.popupExportar.add(this.itemExportarSQL);
        ScreenUtil.requisitarFoco(this.textSQL);
    }

    public static long getModuloAcesso() {
        return 500700000L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.cronometro) {
            this.labelCronometro.setText(StringUtil.formataSegundos(this.tempo++));
        } else if (o == this.buttonFechar) {
            if (!this.alterouBanco || Funcoes.mensagem(this, "Deseja cancelar as altera\u00e7\u00f5es", 4) == 0) {
                if (this.getParent() != null) {
                    this.getParent().removeAll();
                }
                this.setVisible(false);
            }
        } else if (o == this.buttonExecParar) {
            if (this.executando) {
                this.executando = false;
                try {
                    if (this.st != null) {
                        this.st.cancel();
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            } else {
                this.buttonExecParar.setText("Parar");
                this.buttonExecParar.setMnemonic('P');
                this.executar = new Executar();
                this.executar.start();
            }
        } else if (o == this.buttonLimpar) {
            this.textSQL.setText("");
            this.limparRetorno();
            ScreenUtil.requisitarFoco(this.textSQL);
        } else if (o == this.buttonImportar) {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Instru\u00e7\u00f5es SQL (*.sql)", "sql"));
            if (chooser.showOpenDialog(this) == 0) {
                this.limparRetorno();
                try {
                    this.textSQL.setText(StringUtil.lerArquivoTexto(chooser.getSelectedFile().getPath()));
                }
                catch (Exception e2) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel ler o arquivo.\nMensagem: " + e2.getMessage(), 1);
                }
                ScreenUtil.requisitarFoco(this.textSQL);
            }
        } else if (o == this.buttonExportar) {
            this.popupExportar.show(this.buttonExportar.getParent(), this.buttonExportar.getX(), this.buttonExportar.getY() + this.buttonExportar.getHeight());
        } else if (o == this.buttonHistorico) {
            if (this.listHistorico == null) {
                this.listHistorico = new JList(this.modelHistorico);
                this.listHistorico.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            ConsoleSQL.this.carregaHistorico();
                        }
                    }
                });
                this.scrollHistorico = new JScrollPane(this.listHistorico);
                this.scrollHistorico.setBorder(ComponenteFactory.novoTitledEtchedBorder("Hist\u00f3rico"));
                this.splitHistorico = new JSplitPane(1, this.split, this.scrollHistorico);
                this.splitHistorico.setDividerLocation(400);
                this.splitHistorico.setDividerSize(4);
                this.add((Component)this.splitHistorico, "Center");
            } else {
                this.remove(this.splitHistorico);
                this.scrollHistorico = null;
                this.splitHistorico = null;
                this.listHistorico = null;
                this.add((Component)this.split, "Center");
            }
            this.revalidate();
            this.repaint();
        } else if (o == this.itemExportarResultado) {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            FileFilter html = ComponenteFactory.novoFileFilter("Documento HTML (*.html)", "html");
            chooser.addChoosableFileFilter(html);
            FileFilter txt = ComponenteFactory.novoFileFilter("Arquivo texto formatado em colunas (*.txt)", "txt");
            chooser.addChoosableFileFilter(txt);
            FileFilter csv = ComponenteFactory.novoFileFilter("Arquivo texto com valores separados por v\u00edrgula (*.csv)", "csv");
            chooser.addChoosableFileFilter(csv);
            chooser.setFileFilter(html);
            if (chooser.showSaveDialog(this) == 0) {
                ExportaConsulta exporta = null;
                String arquivo = chooser.getSelectedFile().getPath();
                if (arquivo.endsWith(".html") || arquivo.endsWith(".txt")) {
                    exporta = ExportadorFactory.novoExportaConsulta(arquivo.substring(arquivo.lastIndexOf(46) + 1), ' ');
                } else if (chooser.getFileFilter() == html) {
                    exporta = ExportadorFactory.novoExportaConsulta("html", ' ');
                } else if (chooser.getFileFilter() == txt) {
                    exporta = ExportadorFactory.novoExportaConsulta("txt", ' ');
                } else if (chooser.getFileFilter() == csv || arquivo.endsWith(".csv")) {
                    SolicitarSeparador tela = new SolicitarSeparador();
                    tela.setLocation(ScreenUtil.getCentralizado(new Rectangle(0, 0, this.screenSize.width, this.screenSize.height), tela.getSize()));
                    tela.setVisible(true);
                    exporta = ExportadorFactory.novoExportaConsulta("csv", tela.getSeparador());
                    tela = null;
                }
                if (exporta != null) {
                    exporta.exportar(this.modeloConsulta, chooser.getSelectedFile().getPath());
                }
            }
        } else if (o == this.itemExportarSQL) {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            FileFilter sql = ComponenteFactory.novoFileFilter("Arquivo SQL (*.sql)", "sqls");
            chooser.addChoosableFileFilter(sql);
            chooser.setFileFilter(sql);
            if (chooser.showSaveDialog(this) == 0) {
                Object exporta = null;
                String arquivo = chooser.getSelectedFile().getPath();
                try {
                    StringUtil.escreverArquivoTexto(arquivo, this.textSQL.getText());
                }
                catch (IOException e1) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar o SQL.\nMensagem: " + e1.getMessage(), 1);
                }
                catch (Exception e1) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar o SQL.\nMensagem: " + e1.getMessage(), 1);
                }
            }
        }
    }

    private JTextArea carregarMensagem(String mensagem) {
        JTextArea text = new JTextArea(mensagem);
        text.setEditable(false);
        return text;
    }

    private JScrollPane carregarTabela(ResultSet res) throws SQLException {
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<Object[]> dados = new ArrayList<Object[]>();
        ResultSetMetaData metaData = res.getMetaData();
        for (int col = 1; col <= metaData.getColumnCount(); ++col) {
            cols.add(metaData.getColumnLabel(col));
        }
        if (res.first()) {
            do {
                Object[] linha = new Object[metaData.getColumnCount()];
                for (int col = 1; col <= metaData.getColumnCount(); ++col) {
                    linha[col - 1] = res.getObject(col);
                }
                dados.add(linha);
            } while (res.next());
        }
        this.modeloConsulta = new DefaultTableModel((Object[][])dados.toArray((T[])new Object[dados.size()][]), cols.toArray(new Object[cols.size()]));
        JTable table = new JTable(this.modeloConsulta);
        table.getTableHeader().setReorderingAllowed(false);
        FontMetrics fm = table.getFontMetrics(table.getFont());
        TableColumnModel model = table.getColumnModel();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            int displaySize = metaData.getColumnDisplaySize(i + 1);
            int labelSize = fm.stringWidth(metaData.getColumnLabel(i + 1) + "  ");
            model.getColumn(i).setPreferredWidth(Math.max(displaySize, labelSize));
        }
        table.setAutoResizeMode(model.getTotalColumnWidth() < this.panelRetorno.getWidth() ? 4 : 0);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(table);
        scroll.setHorizontalScrollBarPolicy(30);
        table.tableChanged(null);
        return scroll;
    }

    private void adicionarAoHistorico(String sql) {
        this.modelHistorico.addElement(sql);
        if (this.modelHistorico.getSize() > 50) {
            this.modelHistorico.remove(0);
        }
        this.posHistorico = this.modelHistorico.getSize();
    }

    private Map<Integer, String> getSQLs() {
        LinkedHashMap<Integer, String> sqls = new LinkedHashMap<Integer, String>();
        int offset = 0;
        boolean aspas = false;
        String str = this.textSQL.getText();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ';' && !aspas) {
                String s = str.substring(offset, i);
                this.adicionarSQL(sqls, offset, this.parseVariaveis(s));
                offset = i + 1;
                continue;
            }
            if (ch != '\'' || i != 0 && str.charAt(i - 1) == '\\') continue;
            aspas = !aspas;
        }
        if (offset < str.length()) {
            String s = str.substring(offset, str.length());
            this.adicionarSQL(sqls, offset, this.parseVariaveis(s));
        }
        return sqls;
    }

    private void adicionarSQL(Map<Integer, String> map, int pos, String sql) {
        int aux = 0;
        while (aux < sql.length() && Character.isWhitespace(sql.charAt(aux))) {
            ++aux;
            ++pos;
        }
        if (aux < sql.length()) {
            map.put(pos, sql.substring(aux));
        }
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void reportarErro(String sql, String mensagem) {
        this.textSQL.setText(sql);
        JTextArea text = new JTextArea(mensagem);
        text.setForeground(Color.red);
        text.setEditable(false);
        this.limparRetorno();
        this.panelRetorno.add((Component)text, "Center");
        this.panelRetorno.revalidate();
        this.panelRetorno.repaint();
    }

    private void habilitarDesabilitarBotoes() {
        boolean textVazio = this.textSQL.getText().trim().length() == 0;
        this.buttonImportar.setEnabled(!this.executando);
        this.buttonExportar.setEnabled(!this.executando && this.modeloConsulta != null);
        this.buttonExecParar.setEnabled(this.executando || !textVazio);
        this.buttonLimpar.setEnabled(!textVazio || this.panelRetorno.getComponentCount() > 0);
        this.buttonFechar.setEnabled(!this.executando);
    }

    private void limparRetorno() {
        this.panelRetorno.removeAll();
        this.panelRetorno.revalidate();
        this.panelRetorno.repaint();
        this.modeloConsulta = null;
    }

    private void definirTeclas() {
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(37, 512), "anterior", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleSQL.this.posHistorico = ConsoleSQL.this.posHistorico < 0 ? ConsoleSQL.this.modelHistorico.getSize() - 1 : ConsoleSQL.this.posHistorico - 1;
                ConsoleSQL.this.textSQL.setText(ConsoleSQL.this.posHistorico < 0 ? "" : (String)ConsoleSQL.this.modelHistorico.getElementAt(ConsoleSQL.this.posHistorico));
            }
        });
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(39, 512), "posterior", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleSQL.this.posHistorico = ConsoleSQL.this.posHistorico >= ConsoleSQL.this.modelHistorico.getSize() ? 0 : ConsoleSQL.this.posHistorico + 1;
                ConsoleSQL.this.textSQL.setText(ConsoleSQL.this.posHistorico >= ConsoleSQL.this.modelHistorico.getSize() ? "" : (String)ConsoleSQL.this.modelHistorico.getElementAt(ConsoleSQL.this.posHistorico));
            }
        });
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(10, 512), "focoSQL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenUtil.requisitarFoco(ConsoleSQL.this.textSQL);
            }
        });
    }

    private void carregaHistorico() {
        int index = this.listHistorico.getSelectedIndex();
        if (index >= 0) {
            this.textSQL.setText((String)this.modelHistorico.get(index));
        }
    }

    private String parseVariaveis(String sql) {
        SolicitarVariavel tela = new SolicitarVariavel();
        tela.setLocation(ScreenUtil.getCentralizado(new Rectangle(0, 0, this.screenSize.width, this.screenSize.height), tela.getSize()));
        int ini = -1;
        int fim = -1;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '[') {
                ini = i;
            } else if (c == ']' && ini >= 0) {
                fim = i;
            }
            if (ini < 0 || fim <= ini) continue;
            String var = sql.substring(ini, fim + 1).trim();
            tela.setVariavelNome(var);
            tela.setVisible(true);
            sql = sql.substring(0, ini) + tela.getValor() + sql.substring(fim + 1);
            ini = -1;
            fim = -1;
        }
        return sql;
    }

    class Executar
    extends Thread {
        Executar() {
        }

        @Override
        public void run() {
            ConsoleSQL.this.executando = true;
            ConsoleSQL.this.habilitarDesabilitarBotoes();
            boolean contando = ControlaTempoInativo.contando();
            if (contando) {
                ControlaTempoInativo.parar();
            }
            ConsoleSQL.this.limparRetorno();
            ConsoleSQL.this.labelCronometro.setText(StringUtil.formataSegundos(ConsoleSQL.this.tempo = 0L));
            ConsoleSQL.this.panelRetorno.add((Component)ConsoleSQL.this.labelCronometro, "Center");
            ConsoleSQL.this.cronometro.start();
            Map sqls = ConsoleSQL.this.getSQLs();
            Integer[] pos = sqls.keySet().toArray(new Integer[sqls.keySet().size()]);
            int posSQL = 0;
            try {
                ConsoleSQL.this.adicionarAoHistorico(ConsoleSQL.this.textSQL.getText());
                if (sqls.size() > 1) {
                    ConsoleSQL.this.progress.setMaximum(sqls.size());
                    ConsoleSQL.this.progress.setValue(0);
                    ConsoleSQL.this.progress.setVisible(true);
                    ConsoleSQL.this.panelBase.revalidate();
                    ConsoleSQL.this.panelBase.repaint();
                }
                ConsoleSQL.this.st = Conexao.getStatement();
                if (ConsoleSQL.this.st != null) {
                    for (posSQL = 0; ConsoleSQL.this.executando && posSQL < pos.length - 1; ++posSQL) {
                        if (!ConsoleSQL.this.st.execute((String)sqls.get(pos[posSQL]))) {
                            ConsoleSQL.this.alterouBanco = true;
                        }
                        ConsoleSQL.this.progress.setValue(ConsoleSQL.this.progress.getValue() + 1);
                    }
                    if (ConsoleSQL.this.executando) {
                        posSQL = pos.length - 1;
                        boolean retorno = ConsoleSQL.this.st.execute((String)sqls.get(pos[posSQL]));
                        ConsoleSQL.this.cronometro.stop();
                        ConsoleSQL.this.limparRetorno();
                        if (retorno) {
                            ConsoleSQL.this.panelRetorno.add((Component)ConsoleSQL.this.carregarTabela(ConsoleSQL.this.st.getResultSet()), "Center");
                        } else {
                            ConsoleSQL.this.alterouBanco = true;
                            ConsoleSQL.this.panelRetorno.add((Component)ConsoleSQL.this.carregarMensagem("Alterou registros"), "Center");
                        }
                        ConsoleSQL.this.progress.setValue(ConsoleSQL.this.progress.getMaximum());
                    }
                }
                if (ConsoleSQL.this.executando) {
                    ConsoleSQL.this.textSQL.setText("");
                } else {
                    Conexao.anulaSQL();
                    ConsoleSQL.this.textSQL.select(pos[posSQL], pos[posSQL] + ((String)sqls.get(pos[posSQL])).length());
                    ConsoleSQL.this.alterouBanco = false;
                    ConsoleSQL.this.cronometro.stop();
                    ConsoleSQL.this.limparRetorno();
                }
            }
            catch (SQLException e) {
                ConsoleSQL.this.anularSQL();
                ConsoleSQL.this.reportarErro((String)sqls.get(pos[posSQL]), e.getMessage());
                ConsoleSQL.this.alterouBanco = false;
            }
            catch (OutOfMemoryError error) {
                ConsoleSQL.this.anularSQL();
                ConsoleSQL.this.reportarErro((String)sqls.get(pos[posSQL]), "Sem mem\u00f3ria suficiente para execu\u00e7\u00e3o");
                ConsoleSQL.this.alterouBanco = false;
            }
            ConsoleSQL.this.executando = false;
            ConsoleSQL.this.buttonExecParar.setText("Executar");
            ConsoleSQL.this.buttonExecParar.setMnemonic('E');
            ConsoleSQL.this.progress.setVisible(false);
            ConsoleSQL.this.panelBase.revalidate();
            ConsoleSQL.this.panelBase.repaint();
            ConsoleSQL.this.panelRetorno.revalidate();
            ConsoleSQL.this.panelRetorno.repaint();
            ConsoleSQL.this.habilitarDesabilitarBotoes();
            if (contando) {
                ControlaTempoInativo.iniciar();
            }
            ScreenUtil.requisitarFoco(ConsoleSQL.this.textSQL);
        }
    }
}

