/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms.utils;

import jalis.util.Funcoes;
import jalis.util.sms.comunicacao.PortaSerial;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    private static final char FD = '\u00fd';
    private static final String sNUL = "[NUL]";
    private static final String sSOH = "[SOH]";
    private static final String sSTX = "[STX]";
    private static final String sETX = "[ETX]";
    private static final String sEOT = "[EOT]";
    private static final String sENQ = "[ENQ]";
    private static final String sACK = "[ACK]";
    private static final String sLF = "[LF]";
    private static final String sSB = "[SB]";
    private static final String sCR = "[CR]";
    private static final String sDLE = "[DLE]";
    private static final String sDC1 = "[D1C]";
    private static final String sNAK = "[NAK]";
    private static final String sSYN = "[SYN]";
    private static final String sETB = "[ETB]";
    private static final String sCAN = "[CAN]";
    private static final String sSUB = "[SUB]";
    private static final String sSP = "[SP]";
    private static final String sDEL = "[DEL]";
    private static final String sLINE = "[LINE]";

    public static boolean stringIsEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String getXMLTagValue(String xml, String tag, boolean caseSensitive) {
        int end;
        StringBuilder res = new StringBuilder(xml);
        StringBuilder sIni = new StringBuilder();
        StringBuilder sEnd = new StringBuilder();
        sIni.append('<');
        sIni.append(tag);
        sIni.append('>');
        int start = caseSensitive ? res.toString().toUpperCase().indexOf(sIni.toString().toUpperCase()) : res.indexOf(sIni.toString());
        int startPos = caseSensitive ? res.toString().toUpperCase().indexOf(sIni.toString().toUpperCase(), start + sIni.length()) : res.indexOf(sIni.toString(), start + sIni.length());
        sEnd.setLength(0);
        sEnd.append("</");
        sEnd.append(tag);
        sEnd.append('>');
        int n = end = caseSensitive ? res.toString().toUpperCase().indexOf(sEnd.toString().toUpperCase()) : res.toString().indexOf(sEnd.toString());
        while (startPos > -1 && startPos < end) {
            startPos = caseSensitive ? res.toString().toUpperCase().indexOf(sIni.toString().toUpperCase(), end + sEnd.length()) : res.indexOf(sIni.toString(), end + sEnd.length());
            end = caseSensitive ? res.toString().toUpperCase().indexOf(sEnd.toString().toUpperCase(), end + sEnd.length()) : res.toString().indexOf(sEnd.toString(), end + sEnd.length());
        }
        return start > -1 && end > -1 ? res.substring(start + tag.length() + 2, end) : "";
    }

    public static String removeChars(String mensagem) {
        char[] chars;
        StringBuilder s = new StringBuilder();
        for (char c : chars = mensagem.toCharArray()) {
            if (c <= ' ' || c >= '~') continue;
            s.append(c);
        }
        return s.toString();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat dtfFormat = new SimpleDateFormat(format);
        try {
            return dtfFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void limpaLogArquivos(final String dia, final String fileNamePrefix) {
        File file = new File(System.getProperty("user.home"));
        for (File arquivos : file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith(fileNamePrefix) && name.endsWith(".log")) {
                    int d = Integer.parseInt(dia);
                    for (int i = 0; i < 5; ++i) {
                        if (d == 0) {
                            d = 31;
                        }
                        if (name.endsWith(String.format("%s.log", Funcoes.preencheZero(d, 2)))) {
                            return false;
                        }
                        --d;
                    }
                    return true;
                }
                return false;
            }
        })) {
            arquivos.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean escreverArquivoTexto(String nomeArquivo, String texto) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(nomeArquivo, true));
            out.write(texto);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String parseMessage(String message) {
        String newMessage = "";
        if (message != null && message.length() > 0) {
            char[] a = message.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                char c = a[i];
                if (c == PortaSerial.NUL) {
                    newMessage = newMessage + sNUL;
                    continue;
                }
                if (c == PortaSerial.SOH) {
                    newMessage = newMessage + sSOH;
                    continue;
                }
                if (c == PortaSerial.STX) {
                    newMessage = newMessage + sSTX;
                    continue;
                }
                if (c == PortaSerial.ETX) {
                    newMessage = newMessage + sETX;
                    continue;
                }
                if (c == PortaSerial.EOT) {
                    newMessage = newMessage + sEOT;
                    continue;
                }
                if (c == PortaSerial.ENQ) {
                    newMessage = newMessage + sENQ;
                    continue;
                }
                if (c == PortaSerial.ACK) {
                    newMessage = newMessage + sACK;
                    continue;
                }
                if (c == PortaSerial.LF) {
                    newMessage = newMessage + sLF;
                    newMessage = newMessage + "\n";
                    continue;
                }
                if (c == PortaSerial.CR) {
                    if (i + 1 < a.length && a[i + 1] == PortaSerial.LF) {
                        newMessage = newMessage + sLINE;
                        ++i;
                        continue;
                    }
                    newMessage = newMessage + sCR;
                    continue;
                }
                newMessage = c == PortaSerial.DLE ? newMessage + sDLE : (c == PortaSerial.DC1 ? newMessage + sDC1 : (c == PortaSerial.NAK ? newMessage + sNAK : (c == PortaSerial.SYN ? newMessage + sSYN : (c == PortaSerial.ETB ? newMessage + sETB : (c == PortaSerial.CAN ? newMessage + sCAN : (c == PortaSerial.SP ? newMessage + sSP : (c == PortaSerial.DEL ? newMessage + sDEL : (c == PortaSerial.SUB ? newMessage + sSUB : newMessage + c))))))));
            }
        }
        return newMessage;
    }
}

