/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms.comunicacao;

import jalis.util.sms.utils.SmsEnum;

public enum Velocidade implements SmsEnum
{
    V1200("1", 1200, "1200"),
    V2400("2", 2400, "2400"),
    V4800("3", 4800, "4800"),
    V9600("4", 9600, "9600"),
    V19200("5", 19200, "19200"),
    V115200("6", 115200, "115200");

    private String codigo;
    private Integer velocidade;
    private String descricao;

    private Velocidade(String codigo, Integer velocidade, String descricao) {
        this.codigo = codigo;
        this.velocidade = velocidade;
        this.descricao = descricao;
    }

    public static Velocidade[] getVelocidades() {
        return Velocidade.values();
    }

    public String getCodigo() {
        return this.codigo;
    }

    public Integer getVelocidade() {
        return this.velocidade;
    }

    public String getDescricao() {
        return this.descricao;
    }

    @Override
    public Object getTextValue() {
        return this.getCodigo();
    }

    public static SmsEnum getTipoPadrao() {
        return V1200;
    }

    @Override
    public SmsEnum getTipo(Object tipo) {
        String velocidade = (String)tipo;
        for (Velocidade v : Velocidade.values()) {
            if (!v.getCodigo().equals(velocidade)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.getDescricao();
    }
}

