/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms.comunicacao;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import jalis.util.Funcoes;
import jalis.util.sms.comunicacao.DataBits;
import jalis.util.sms.comunicacao.Fluxo;
import jalis.util.sms.comunicacao.HandShakeListener;
import jalis.util.sms.comunicacao.LogListener;
import jalis.util.sms.comunicacao.Paridade;
import jalis.util.sms.comunicacao.Porta;
import jalis.util.sms.comunicacao.StopBits;
import jalis.util.sms.comunicacao.Velocidade;
import jalis.util.sms.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;

public class PortaSerial
extends Porta {
    public static char NUL = '\u0000';
    public static char SOH = '\u0001';
    public static char STX = (char)2;
    public static char ETX = (char)3;
    public static char EOT = (char)4;
    public static char ENQ = (char)5;
    public static char ACK = (char)6;
    public static char LF = (char)10;
    public static char CR = (char)13;
    public static char DLE = (char)16;
    public static char DC1 = (char)17;
    public static char NAK = (char)21;
    public static char SYN = (char)22;
    public static char ETB = (char)23;
    public static char CAN = (char)24;
    public static char SUB = (char)26;
    public static char SP = (char)32;
    public static char DEL = (char)127;
    public static String LINE = String.valueOf(CR) + String.valueOf(LF);
    private String porta;
    private Velocidade velocidade;
    private DataBits dataBits;
    private StopBits stopBits;
    private Paridade paridade;
    private Fluxo fluxo;
    private SerialPort portaCom;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean gravaLog;
    protected ArrayList<HandShakeListener> handshakeListeners;

    public PortaSerial(String porta, Velocidade velocidade, DataBits dataBits, StopBits stopBits, Paridade paridade, Fluxo fluxo, boolean gravaLog) {
        this.porta = porta;
        this.velocidade = velocidade;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.paridade = paridade;
        this.fluxo = fluxo;
        this.gravaLog = gravaLog;
        if (gravaLog) {
            String dia = Funcoes.formataData("dd", Calendar.getInstance().getTime());
            Utils.limpaLogArquivos(dia, "MODEM");
            String arqLog = String.format("%s%sMODEM-%s.log", System.getProperty("user.home"), System.getProperty("file.separator"), dia);
            this.addLogListener(new LogPortFile(arqLog));
        }
        this.handshakeListeners = new ArrayList();
    }

    public void carregar() throws Exception {
        CommPortIdentifier portaId = null;
        try {
            portaId = CommPortIdentifier.getPortIdentifier((String)this.porta);
        }
        catch (NoSuchPortException e) {
            throw new Exception("O modem n\u00e3o foi detectado.");
        }
        if (portaId.isCurrentlyOwned()) {
            throw new Exception("A porta informada ja esta sendo utilizada.");
        }
        CommPort portaCom = null;
        try {
            portaCom = portaId.open("VInterface", 30000);
        }
        catch (Exception e) {
            throw new Exception("Nenhum modem conectado na porta \"" + portaId.toString() + "\" para o envio de SMS.\nConecte o modem e reinicie o jalis para continuar enviando SMS.");
        }
        if (!(portaCom instanceof SerialPort)) {
            throw new Exception("A porta informada n\u00e3o \u00e9 uma porta serial.");
        }
        int dataBits = Integer.parseInt(this.dataBits.getCodigo());
        int stopBits = Integer.parseInt(this.stopBits.getCodigo());
        int paridade = Integer.parseInt(this.paridade.getCodigo());
        int flowControl = 0;
        if (this.fluxo == Fluxo.Software) {
            flowControl = 12;
        } else if (this.fluxo == Fluxo.Hardware) {
            flowControl = 3;
        }
        this.portaCom = (SerialPort)portaCom;
        this.portaCom.setSerialPortParams(this.velocidade.getVelocidade().intValue(), dataBits, stopBits, paridade);
        this.portaCom.setFlowControlMode(flowControl);
        this.inputStream = this.portaCom.getInputStream();
        this.outputStream = this.portaCom.getOutputStream();
        this.portaCom.addEventListener((SerialPortEventListener)new SerialReaderEvent());
        this.portaCom.notifyOnDataAvailable(true);
    }

    public void write(String message) throws IOException {
        if (this.portaCom != null && !Utils.stringIsEmpty(message)) {
            this.fireLogOutput(message);
            try {
                this.outputStream.write(message.getBytes());
                try {
                    this.outputStream.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void read() {
        int size = 0;
        try {
            byte[] buffer = new byte[4096];
            StringBuilder s = new StringBuilder();
            while (this.inputStream.available() > 0) {
                size = this.inputStream.read(buffer);
                s.append(new String(buffer, 0, size));
            }
            String sRead = s.toString();
            this.fireLogInput(sRead);
            if (sRead.length() == 1 && this.isHandShakeChar(sRead.charAt(0))) {
                this.fireHandShake(sRead.charAt(0));
            } else {
                this.fireDataReceive(sRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isHandShakeChar(char c) {
        return c == ACK || c == NAK || c == ENQ || c == SYN || c == DEL || c == CAN || c == NUL || c == EOT || c == DLE || c == DC1;
    }

    public void addHandShakeListener(HandShakeListener listener) {
        this.handshakeListeners.add(listener);
    }

    protected void fireHandShake(char handShake) {
        for (HandShakeListener l : this.handshakeListeners) {
            l.handShakeReceive(handShake);
        }
    }

    public void desconectar() {
        if (this.portaCom != null) {
            try {
                this.outputStream.close();
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.portaCom.close();
        }
    }

    class LogPortFile
    implements LogListener {
        private String arqLog;

        public LogPortFile(String arqLog) {
            this.arqLog = arqLog;
        }

        @Override
        public void inputLog(String log) {
            if (!Funcoes.textoVazio(this.arqLog)) {
                Utils.escreverArquivoTexto(this.arqLog, String.format("%s %s %s\n", Funcoes.formataData("yyyy/MM/dd HH:mm:ss:SSS", Calendar.getInstance().getTime()), ">>", Utils.parseMessage(log)));
            }
        }

        @Override
        public void outputLog(String log) {
            if (!Funcoes.textoVazio(this.arqLog)) {
                Utils.escreverArquivoTexto(this.arqLog, String.format("%s %s %s\n", Funcoes.formataData("yyyy/MM/dd HH:mm:ss:SSS", Calendar.getInstance().getTime()), "<<", Utils.parseMessage(log)));
            }
        }
    }

    class SerialReaderEvent
    implements SerialPortEventListener {
        SerialReaderEvent() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.getEventType() == 1) {
                PortaSerial.this.read();
            } else {
                PortaSerial.this.fireLogOutput("Evento PortaSerial: [ " + event.getEventType() + " ]");
            }
        }
    }
}

