/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms.comunicacao;

import jalis.util.sms.utils.SmsEnum;

public enum Paridade implements SmsEnum
{
    Nenhuma("0", "Nenhuma"),
    Impar("1", "Impar"),
    Par("2", "Par");

    private String codigo;
    private String descricao;
    private static Paridade[] paridades;

    private Paridade(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public static Paridade[] getParidades() {
        return paridades;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    @Override
    public Object getTextValue() {
        return this.getCodigo();
    }

    public static SmsEnum getTipoPadrao() {
        return Nenhuma;
    }

    @Override
    public SmsEnum getTipo(Object tipo) {
        String paridade = (String)tipo;
        for (Paridade v : paridades) {
            if (!v.getCodigo().equals(paridade)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.getDescricao();
    }

    static {
        paridades = new Paridade[]{Nenhuma, Impar, Par};
    }
}

