/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms.comunicacao;

import jalis.util.sms.utils.SmsEnum;

public enum Fluxo implements SmsEnum
{
    Nenhum("N", "Nenhum"),
    Software("S", "Software"),
    Hardware("H", "Hardware");

    private String codigo;
    private String descricao;
    private static Fluxo[] fluxos;

    private Fluxo(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public static Fluxo[] getFluxos() {
        return fluxos;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    @Override
    public Object getTextValue() {
        return this.getCodigo();
    }

    public static SmsEnum getTipoPadrao() {
        return Nenhum;
    }

    @Override
    public SmsEnum getTipo(Object tipo) {
        String fluxo = (String)tipo;
        for (Fluxo v : fluxos) {
            if (!v.getCodigo().equals(fluxo)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.getDescricao();
    }

    static {
        fluxos = new Fluxo[]{Nenhum, Software, Hardware};
    }
}

