/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms;

import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.sms.SMSObject;
import jalis.util.sms.SmsBean;
import jalis.util.sms.SmsSituacaoListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;

public class SmsSenderAPI
implements Runnable {
    private final String URL = "https://zero.thread.com.br/api/sms";
    private String codigoCliente;
    private String key;
    private boolean parar = false;
    private boolean enviando = false;
    private boolean enviandoSMS = false;
    private boolean erroLocalizado = false;
    private long tempoIntervalo = 30000L;
    private boolean gravaLog = false;
    boolean cmgrRecebido = false;
    boolean cmgsRecebido = false;
    private String lastId = "";
    private ArrayList<SMSObject> smsAPI = new ArrayList();
    private ArrayList<SmsSituacaoListener> smsSituacaoListener;
    private ArrayList<SmsBean> smsEnviar;
    private ExportacaoMonitor exportacaoMonitor = null;
    private Date tempoIteracaoAnterior = null;
    private boolean naoiniciado = true;
    private Thread threadEnvio;
    private long delayEnvioSms = 20000L;

    public SmsSenderAPI(String porta, String codigoCliente, String key, ExportacaoMonitor exportacaoMonitor) {
        this.codigoCliente = codigoCliente;
        this.key = key;
        this.exportacaoMonitor = exportacaoMonitor;
        this.smsSituacaoListener = new ArrayList();
        this.smsEnviar = new ArrayList();
    }

    public void carregar() throws Exception {
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.threadEnvio = new Thread(this);
    }

    public void addSmsSituacaoListener(SmsSituacaoListener listener) {
        this.smsSituacaoListener.add(listener);
    }

    public void removeSmsSituacaoListener(SmsSituacaoListener listener) {
        this.smsSituacaoListener.remove(listener);
    }

    public void addSmsEnvio(SmsBean sms) {
        this.smsEnviar.add(sms);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
        }
    }

    public void startServico() {
        if (this.naoiniciado && this.threadEnvio != null) {
            this.parar = false;
            this.threadEnvio.start();
            this.naoiniciado = false;
        }
    }

    public void addSmsEnvioUrgente(SmsBean sms) {
        this.smsEnviar.add(0, sms);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
        }
    }

    protected void fireSmsEnviadaOperadora(SmsBean sms) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.smsEnviadaOperadora(sms);
        }
    }

    protected void fireSmsNaoEnviada(SmsBean sms) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.smsNaoEnviada(sms);
        }
    }

    private void enviarSMS() throws Exception {
        int tempo = this.delayEnvioSms / 1000L > 0L ? (int)(this.delayEnvioSms / 1000L) : 20;
        int qtdeEnviadas = 0;
        if (this.smsEnviar.size() > 0) {
            SmsBean beanSMS;
            SMSObject smsObject;
            int i;
            ArrayList<Integer> posRemover = new ArrayList<Integer>();
            for (i = 0; i < this.smsEnviar.size() && !this.validaCampos(smsObject = this.gerarSmsEnvio(beanSMS = this.smsEnviar.get(i))); ++i) {
                Laboratorio.setIconeEnvioSMS(ExportaSMS.ICONE_ENVIANDO_SMS_ON);
                this.enviando = true;
                if (this.exportacaoMonitor != null) {
                    this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
                    this.atualizaTempoEntreIteracoes();
                    this.exportacaoMonitor.setOperacaoAtual("Enviando SMS para: " + beanSMS.getNumero() + ".");
                }
                Laboratorio.setIconeEnvioSMS(ExportaSMS.ICONE_ENVIANDO_SMS_OFF);
                this.exportacaoMonitor.setTempoProximaIteracao(tempo * 1000);
                String codRetornoEnviarSMS = this.enviaSMSViaAPI(smsObject);
                if (codRetornoEnviarSMS.contains("Success")) {
                    this.exportacaoMonitor.setOperacaoAtual("SMS Enviado com Sucesso!");
                    ++qtdeEnviadas;
                    this.fireSmsEnviadaOperadora(beanSMS);
                    posRemover.add(i);
                    continue;
                }
                this.exportacaoMonitor.setOperacaoAtual("N\u00e3o foi possivel enviar mensagem SMS para: " + beanSMS.getNumero() + "\n" + codRetornoEnviarSMS);
                this.fireSmsNaoEnviada(beanSMS);
                posRemover.add(i);
            }
            Collections.sort(posRemover);
            for (i = posRemover.size() - 1; i >= 0; --i) {
                this.smsEnviar.remove((Integer)posRemover.get(i));
            }
        }
        this.enviando = false;
        this.exportacaoMonitor.setQuantidadeLogEnvio(qtdeEnviadas);
    }

    private boolean validaCampos(SMSObject smsObject) {
        if (smsObject.getCodigoThread() == null) {
            this.exportacaoMonitor.setOperacaoAtual("C\u00f3digo Thread n\u00e3o informado. " + smsObject.getCelular());
            return true;
        }
        if (smsObject.getCodigoJalis() == null) {
            this.exportacaoMonitor.setOperacaoAtual("C\u00f3digo Jalis n\u00e3o informado. " + smsObject.getCelular());
            return true;
        }
        if (smsObject.getChave() == null) {
            this.exportacaoMonitor.setOperacaoAtual("Chave n\u00e3o informado. " + smsObject.getCelular());
            return true;
        }
        if (smsObject.getCelular() == null) {
            this.exportacaoMonitor.setOperacaoAtual("Celular n\u00e3o informado. ");
            return true;
        }
        if (smsObject.getMensagem() == null) {
            this.exportacaoMonitor.setOperacaoAtual("C\u00f3digo Mensagem n\u00e3o informada." + smsObject.getCelular());
            return true;
        }
        return false;
    }

    private String enviaSMSViaAPI(SMSObject smsObject) throws IOException {
        HttpURLConnection conn = null;
        StringBuilder response = new StringBuilder();
        if (null != smsObject) {
            try {
                String inputLine;
                URL url = new URL("https://zero.thread.com.br/api/sms");
                ObjectMapper mapper = new ObjectMapper();
                String jsonSMS = mapper.writeValueAsString((Object)smsObject);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                OutputStream os = conn.getOutputStream();
                os.write(jsonSMS.getBytes());
                os.flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
            }
            catch (MalformedURLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "URL de envio de SMS inv\u00e1lida. Favor verificar.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (ConnectException e) {
                this.exportacaoMonitor.setOperacaoAtual("N\u00e3o foi poss\u00edvel conectar ao servi\u00e7o. \n" + e.getMessage());
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Ocorreu uma situa\u00e7\u00e3o inesperada ao enviar SMS.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return response.toString();
    }

    private String retornaErro(HttpURLConnection conn) throws IOException {
        String erro;
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((erro = br.readLine()) != null) {
        }
        conn.disconnect();
        return erro;
    }

    private SMSObject gerarSmsEnvio(SmsBean sms) {
        SMSObject smsObject = new SMSObject();
        smsObject.setCodigoThread(String.valueOf(ParametrosGerais.getCodigoCliente()));
        smsObject.setCodigoJalis(Funcoes.preencheZero(sms.getFilial(), 3));
        smsObject.setChave(this.key);
        smsObject.setCelular(sms.getNumero());
        smsObject.setMensagem(sms.getMensagem());
        return smsObject;
    }

    public boolean isErroLocalizado() {
        return this.erroLocalizado;
    }

    public void pararEnvio() {
        if (this.smsEnviar.size() > 0) {
            while (this.smsEnviar.size() > 0) {
                this.fireSmsNaoEnviada(this.smsEnviar.remove(0));
            }
        }
        this.parar = true;
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
        }
    }

    public int getQuantidadeSmsEnviar() {
        return this.smsEnviar.size();
    }

    public boolean isEnviando() {
        return this.smsEnviar.size() > 0 && !this.enviando;
    }

    @Override
    public void run() {
        while (!this.parar) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
            if (this.smsEnviar.size() > 0 && !this.enviando) {
                try {
                    this.enviarSMS();
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Ocorreu uma situa\u00e7\u00e3o inesperada ao enviar SMS.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            try {
                Thread.sleep(this.tempoIntervalo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Ocorreu uma situa\u00e7\u00e3o inesperada ao enviar SMS.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void atualizaTempoEntreIteracoes() {
        if (this.tempoIteracaoAnterior != null) {
            Calendar calAnterior = Calendar.getInstance();
            calAnterior.setTime(this.tempoIteracaoAnterior);
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new Date());
            long qtde = calAtual.getTimeInMillis() - calAnterior.getTimeInMillis();
            this.exportacaoMonitor.setTempoEntreIteracoes(qtde);
            this.tempoIteracaoAnterior = calAtual.getTime();
        } else {
            this.tempoIteracaoAnterior = new Date();
        }
    }

    public ArrayList<SmsBean> getSmsEnviar() {
        return this.smsEnviar;
    }
}

