/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.sms;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.sms.SmsBean;
import jalis.util.sms.SmsSituacaoListener;
import jalis.util.sms.StatusReportBean;
import jalis.util.sms.comunicacao.DataBits;
import jalis.util.sms.comunicacao.DataReceiveListener;
import jalis.util.sms.comunicacao.Fluxo;
import jalis.util.sms.comunicacao.Paridade;
import jalis.util.sms.comunicacao.PortaSerial;
import jalis.util.sms.comunicacao.StopBits;
import jalis.util.sms.comunicacao.Velocidade;
import jalis.util.sms.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SmsSender
implements DataReceiveListener,
Runnable {
    private String porta;
    private Velocidade velocidade;
    private DataBits dataBits;
    private StopBits stopBits;
    private Paridade paridade;
    private Fluxo fluxo;
    private boolean parar = false;
    private boolean enviando = false;
    private boolean atEncontrado = false;
    private boolean enviandoSMS = false;
    private boolean erroLocalizado = false;
    private boolean enviandoConfiguracao = false;
    private long tempoIntervalo = 30000L;
    private boolean gravaLog = false;
    boolean cmgrRecebido = false;
    boolean cmgsRecebido = false;
    private PortaSerial portaSerial;
    private String lastId = "";
    private int valorSinal = 0;
    private ArrayList<String> tx = new ArrayList();
    private ArrayList<String> rx = new ArrayList();
    private ArrayList<String> configTx = new ArrayList();
    private ArrayList<SmsSituacaoListener> smsSituacaoListener;
    private ArrayList<SmsBean> smsEnviar;
    private List<SmsBean> smsEnviadas;
    private ExportacaoMonitor exportacaoMonitor = null;
    private Date tempoIteracaoAnterior = null;
    private String numeroCelular = "";
    private String ultimaMensagemEnviada = null;
    private SmsBean ultimaSmsEnviada = null;
    private boolean naoiniciado = true;
    private Thread threadEnvio;
    private long delayEnvioSms = 20000L;
    private static final String MASCARA_DATA = "yyyy/MM/dd HH:mm:ss:SSS";
    private static final int LIMITE_CARACTERES = 140;

    public SmsSender() {
        this.smsSituacaoListener = new ArrayList();
        this.smsEnviar = new ArrayList();
        this.smsEnviadas = new LinkedList<SmsBean>();
    }

    public SmsSender(String porta, Velocidade velocidade, DataBits dataBits, StopBits stopBits, Paridade paridade, Fluxo fluxo, boolean gravaLog, long delayEnvioSms, ExportacaoMonitor exportacaoMonitor) {
        this.porta = porta;
        this.velocidade = velocidade;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.paridade = paridade;
        this.fluxo = fluxo;
        this.gravaLog = gravaLog;
        this.delayEnvioSms = delayEnvioSms;
        this.exportacaoMonitor = exportacaoMonitor;
    }

    public void config(String porta, Velocidade velocidade, DataBits dataBits, StopBits stopBits, Paridade paridade, Fluxo fluxo, boolean gravaLog, long delayEnvioSms, ExportacaoMonitor exportacaoMonitor) {
        this.porta = porta;
        this.velocidade = velocidade;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.paridade = paridade;
        this.fluxo = fluxo;
        this.gravaLog = gravaLog;
        this.delayEnvioSms = delayEnvioSms;
        this.exportacaoMonitor = exportacaoMonitor;
    }

    public void config(String xml) {
        this.porta = Utils.getXMLTagValue(xml, "porta", true);
        this.velocidade = (Velocidade)Velocidade.V19200.getTipo(Utils.getXMLTagValue(xml, "velocidade", true));
        this.dataBits = (DataBits)DataBits.D8.getTipo(Utils.getXMLTagValue(xml, "dataBits", true));
        this.stopBits = (StopBits)StopBits.S1.getTipo(Utils.getXMLTagValue(xml, "stopBits", true));
        this.paridade = (Paridade)Paridade.Nenhuma.getTipo(Utils.getXMLTagValue(xml, "paridade", true));
        this.fluxo = (Fluxo)Fluxo.Nenhum.getTipo(Utils.getXMLTagValue(xml, "fluxo", true));
    }

    public void carregar() throws Exception {
        if (!Funcoes.textoVazio(this.porta)) {
            try {
                Class.forName("gnu.io.CommDriver");
                this.portaSerial = new PortaSerial(this.porta, this.velocidade, this.dataBits, this.stopBits, this.paridade, this.fluxo, this.gravaLog);
                this.portaSerial.carregar();
                this.portaSerial.addDataReceiveListener(this);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar com a porta " + this.porta + ".", e.getStackTrace());
                this.portaSerial.desconectar();
            }
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.threadEnvio = new Thread(this);
    }

    public void configModem() throws IOException {
        ArrayList<String> tx = new ArrayList<String>();
        StringBuilder cmd = new StringBuilder();
        cmd.append("AT").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CMEE=2").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT&W").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CSMP?").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CSMP=49,167,0,0").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CPMS=\"SR\"").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CNMI=1,2,2,2,0").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CMGF=1").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CREG=2").append(PortaSerial.CR);
        tx.add(cmd.toString());
        this.configTx.addAll(tx);
        this.enviarConfigTx();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void enviarProximaConfiguracao() {
        try {
            this.enviarConfigTx();
            Thread.sleep(500L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addSmsSituacaoListener(SmsSituacaoListener listener) {
        this.smsSituacaoListener.add(listener);
    }

    public void removeSmsSituacaoListener(SmsSituacaoListener listener) {
        this.smsSituacaoListener.remove(listener);
    }

    public void addSmsEnvio(SmsBean sms) {
        this.smsEnviar.add(sms);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
        }
    }

    public void startServico() {
        if (this.naoiniciado && this.threadEnvio != null) {
            this.parar = false;
            this.threadEnvio.start();
            this.naoiniciado = false;
        }
    }

    public void addSmsEnvioUrgente(SmsBean sms) {
        this.smsEnviar.add(0, sms);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
        }
    }

    protected void fireSmsEnviada(SmsBean sms) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.smsEnviada(sms);
        }
    }

    protected void fireSmsEnviadaOperadora(SmsBean sms) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.smsEnviadaOperadora(sms);
        }
    }

    protected void fireSmsNaoEnviada(SmsBean sms) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.smsNaoEnviada(sms);
        }
    }

    protected void fireStatusReportRecebido(StatusReportBean sr) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.statusReportRecebido(sr);
        }
    }

    protected void fireValorSinalRecebido(int valorSinal) {
        for (SmsSituacaoListener l : this.smsSituacaoListener) {
            l.valorSinalRecebido(valorSinal);
        }
    }

    @Override
    public synchronized void dataReceive(String message) {
        this.rx.add(message);
        if (message.indexOf(PortaSerial.LINE) >= 0) {
            this.parse();
        }
    }

    private synchronized void parse() {
        LinkedList<String> mensagens = new LinkedList<String>();
        StringBuilder mensagem = new StringBuilder();
        while (this.rx.size() > 0) {
            String m = this.rx.remove(0);
            int idx = m.indexOf(PortaSerial.LINE);
            if (idx >= 0) {
                if (idx < m.length() - 2) {
                    String o = m.substring(idx + 2);
                    m = m.substring(0, idx);
                    this.rx.add(0, o);
                }
                mensagens.add(m);
                continue;
            }
            mensagem.append(m);
        }
        if (mensagem.length() > 0) {
            this.rx.add(0, mensagem.toString());
        }
        this.parse(mensagens);
    }

    public synchronized void parse(List<String> messages) {
        for (String message : messages) {
            SmsBean sms;
            message = message.toLowerCase();
            message = message.replace("\r", "");
            if (Funcoes.textoVazio(message = message.replace("\n", ""))) continue;
            while (message.indexOf(32) == 0) {
                message = message.substring(1);
            }
            if (message.equals("at") && this.enviandoConfiguracao) {
                this.atEncontrado = true;
                if (!this.enviandoConfiguracao) continue;
                try {
                    this.enviarConfigTx();
                    Thread.sleep(500L);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.atEncontrado && message.startsWith("ok")) {
                this.atEncontrado = false;
                this.okRecebido();
                continue;
            }
            if (message.startsWith("at+cmgs=")) {
                this.atEncontrado = false;
                this.okRecebido();
                this.numeroCelular = Utils.removeChars(message.substring(message.indexOf("=") + 1).replaceAll("\"", ""));
                this.cmgsRecebido = true;
                continue;
            }
            if (message.contains("+cms error: 500")) {
                System.out.println("erro: 500 " + message + " Celular " + this.numeroCelular);
                this.atEncontrado = false;
                if (this.numeroCelular == null || (sms = this.getSmsEnviada(this.numeroCelular)) == null) continue;
                ExportaSMS.smsNaoEnviada(sms, "R");
                continue;
            }
            if (message.startsWith("at+csmp=")) {
                this.atEncontrado = false;
                this.okRecebido();
                continue;
            }
            if (message.startsWith("at+csq=")) {
                this.atEncontrado = false;
                this.parseCsq(message);
                this.okRecebido();
                continue;
            }
            if (message.startsWith("at+cnmi=")) {
                this.atEncontrado = false;
                this.okRecebido();
                continue;
            }
            if (message.startsWith("NO CARRIER")) {
                this.atEncontrado = false;
                this.parseError(message, this.numeroCelular);
                continue;
            }
            if (message.startsWith("at+cmgf=")) {
                this.atEncontrado = false;
                this.okRecebido();
                continue;
            }
            if (message.startsWith(">") && this.enviandoSMS) {
                try {
                    this.enviarTx();
                    this.enviandoSMS = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (message.indexOf("error") >= 0) {
                this.atEncontrado = false;
                if (this.numeroCelular == null || (sms = this.getSmsEnviada(this.numeroCelular)) == null) continue;
                ExportaSMS.smsNaoEnviada(sms, "R");
                continue;
            }
            if (message.indexOf("+cmgs:") >= 0) {
                this.atEncontrado = false;
                this.parseCmgsID(message, this.numeroCelular);
                continue;
            }
            if (message.indexOf("+cmgs=") >= 0) {
                this.atEncontrado = false;
                continue;
            }
            if (message.indexOf("+cds") >= 0) {
                this.atEncontrado = false;
                this.parseCds(message);
                continue;
            }
            if (message.indexOf("+z") >= 0) {
                this.atEncontrado = false;
                continue;
            }
            if (message.indexOf("+cpas:") >= 0) {
                this.parseCpas(message);
                continue;
            }
            if (message.indexOf("+cmgr:") < 0) continue;
            this.parseCmgr(message);
        }
    }

    private void parseCsq(String mensagem) {
        String msg = mensagem.substring(mensagem.indexOf(":") + 1, mensagem.length());
        if (msg.indexOf(",") <= 0) {
            this.valorSinal = 0;
        } else {
            String[] valores = msg.split(",");
            if (valores.length > 0 && Funcoes.isNumeric(valores[0])) {
                this.valorSinal = Integer.parseInt(valores[0]);
            }
        }
        this.exportacaoMonitor.setValorSinal(this.valorSinal);
    }

    private SmsBean getSmsEnviada(String numeroCelular) {
        System.out.println("Qtde sms env. " + this.smsEnviadas.size());
        int pos = -1;
        for (int i = 0; i < this.smsEnviadas.size(); ++i) {
            if (!this.smsEnviadas.get(i).getNumero().equals(numeroCelular)) continue;
            pos = i;
            break;
        }
        if (pos >= 0) {
            System.out.println("Removido da posi\u00e7\u00e3o " + pos);
            return this.smsEnviadas.remove(pos);
        }
        return null;
    }

    private void parseCpas(String message) {
        String status = (message = Utils.removeChars(message)).substring(message.indexOf(":") + 1, message.length());
        if (status.trim().equals("0")) {
            if (this.ultimaSmsEnviada != null) {
                try {
                    StringBuilder cmd = new StringBuilder();
                    cmd.append("AT+CMGR=0").append(PortaSerial.CR);
                    this.cmgrRecebido = false;
                    if (!this.enviando && !this.enviandoConfiguracao) {
                        this.portaSerial.write(cmd.toString());
                    } else {
                        this.tx.add(cmd.toString());
                        this.enviarTx();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.enviarProximaSms();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseCmgr(String message) {
        this.cmgrRecebido = true;
        String[] camposStatus = this.parseMessageCmgr(message = message.substring(message.indexOf(":") + 1, message.length()));
        if (camposStatus.length >= 8) {
            StatusReportBean sr = new StatusReportBean();
            sr.setSmsId(Integer.parseInt(camposStatus[2]));
            if (camposStatus[3].startsWith("+")) {
                sr.setCelular(camposStatus[3].substring(3));
            } else {
                sr.setCelular(camposStatus[3]);
            }
            this.fireStatusReportRecebido(sr);
        }
        this.verificaStatus();
    }

    private String[] parseMessageCmgr(String message) {
        boolean texto = false;
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '\"' && !texto) {
                texto = true;
                continue;
            }
            if (c == ',' && texto) {
                text.append(" ");
                continue;
            }
            if (c == '\"' && texto) {
                texto = false;
                continue;
            }
            text.append(message.charAt(i));
        }
        return text.toString().split(",");
    }

    private void enviarProximaSms() throws Exception {
        int tempo;
        int n = tempo = this.delayEnvioSms / 1000L > 0L ? (int)(this.delayEnvioSms / 1000L) : 20;
        if (this.smsEnviar.size() > 0) {
            Laboratorio.setIconeEnvioSMS(ExportaSMS.ICONE_ENVIANDO_SMS_ON);
            this.enviando = true;
            this.ultimaSmsEnviada = this.smsEnviar.remove(0);
            for (SmsBean smsParaEnviar : this.smsEnviar) {
                System.out.println("________________");
                System.out.println("Mensagem:" + smsParaEnviar.getMensagem());
                System.out.println("Numero:" + smsParaEnviar.getNumero());
                System.out.println("________________");
            }
            if (this.exportacaoMonitor != null) {
                this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
                this.atualizaTempoEntreIteracoes();
                this.exportacaoMonitor.setOperacaoAtual("Enviando SMS para: " + this.ultimaSmsEnviada.getNumero() + ".");
            }
            this.smsEnviadas.add(this.ultimaSmsEnviada.clone());
            SmsBean smsEnviadaUm = null;
            SmsBean smsEnviadaDois = null;
            if (this.ultimaSmsEnviada.getMensagem().length() > 140) {
                String msgUm = "";
                String msgDois = "";
                smsEnviadaUm = this.ultimaSmsEnviada.clone();
                smsEnviadaDois = this.ultimaSmsEnviada.clone();
                String corte = smsEnviadaUm.getMensagem().substring(140, 140);
                if (corte.equals(" ")) {
                    msgUm = smsEnviadaUm.getMensagem().substring(0, 140);
                    msgDois = smsEnviadaUm.getMensagem().substring(msgUm.length() + 1, smsEnviadaUm.getMensagem().length());
                } else {
                    String corteAux = smsEnviadaUm.getMensagem().substring(0, 140);
                    int pos = 0;
                    for (int i = 0; i < corteAux.length(); ++i) {
                        char c = corteAux.toCharArray()[i];
                        if (c != ' ') continue;
                        pos = i;
                    }
                    msgUm = smsEnviadaUm.getMensagem().substring(0, pos);
                    msgDois = smsEnviadaUm.getMensagem().substring(pos, smsEnviadaUm.getMensagem().length());
                }
                smsEnviadaUm.setMensagem(msgUm);
                smsEnviadaDois.setMensagem(msgDois);
            }
            if (smsEnviadaUm == null) {
                this.tx.addAll(this.gerarSmsEnvio(this.ultimaSmsEnviada));
                this.enviarSMS();
            } else {
                this.tx.addAll(this.gerarSmsEnvio(smsEnviadaUm));
                this.enviarSMS();
                Thread.sleep(2000L);
                this.tx.addAll(this.gerarSmsEnvio(smsEnviadaDois));
                this.enviarSMS();
            }
            Laboratorio.setIconeEnvioSMS(ExportaSMS.ICONE_ENVIANDO_SMS_OFF);
            this.exportacaoMonitor.setTempoProximaIteracao(tempo * 1000);
        }
        for (int i = 0; i < tempo; ++i) {
            Thread.sleep(1000L);
            if (this.cmgsRecebido) break;
        }
        this.enviando = false;
    }

    private void enviarSMS() throws InterruptedException {
        while (this.tx.size() > 0) {
            try {
                this.enviarTx();
                this.cmgsRecebido = false;
                Thread.sleep(1000L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fireSmsEnviadaOperadora(this.ultimaSmsEnviada);
    }

    private void enviarConfigTx() throws IOException {
        if (this.configTx.size() > 0) {
            this.enviandoConfiguracao = true;
            this.ultimaMensagemEnviada = this.configTx.remove(0);
            if (this.portaSerial != null) {
                this.portaSerial.write(this.ultimaMensagemEnviada);
            }
        } else {
            this.enviandoConfiguracao = false;
            this.verificaStatus();
        }
    }

    private void enviarTx() throws IOException {
        System.out.println("enviando tx");
        if (this.tx.size() > 0) {
            this.ultimaMensagemEnviada = this.tx.remove(0);
            if (this.portaSerial != null) {
                this.portaSerial.write(this.ultimaMensagemEnviada);
            }
        }
        if (this.configTx.isEmpty() && this.enviandoConfiguracao) {
            this.enviandoConfiguracao = false;
        }
    }

    private void okRecebido() {
        try {
            if (this.enviandoConfiguracao && !this.configTx.isEmpty()) {
                this.enviarConfigTx();
            } else if (!this.tx.isEmpty()) {
                this.enviarTx();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> gerarSmsEnvio(SmsBean sms) {
        ArrayList<String> tx = new ArrayList<String>();
        StringBuilder cmd = new StringBuilder();
        cmd.setLength(0);
        cmd.append("AT+CREG").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CSQ").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT").append(PortaSerial.CR);
        tx.add(cmd.toString());
        cmd.setLength(0);
        cmd.append("AT+CMGS=\"").append(sms.getNumero()).append("\"").append(PortaSerial.CR);
        tx.add(cmd.toString());
        this.enviandoSMS = true;
        cmd.setLength(0);
        cmd.append(sms.getMensagem()).append('\u001a');
        tx.add(cmd.toString());
        System.out.println(tx);
        return tx;
    }

    private void parseError(String mensagem, String numeroCelular) {
        SmsBean sms = this.getSmsEnviada(numeroCelular);
        if (sms != null) {
            this.fireSmsNaoEnviada(sms);
        }
        this.enviando = false;
        this.erroLocalizado = true;
    }

    public boolean isErroLocalizado() {
        return this.erroLocalizado;
    }

    public boolean isEnviandoConfiguracao() {
        return this.enviandoConfiguracao;
    }

    private void parseCmgsID(String mensagem, String numeroCelular) {
        SmsBean sms;
        String id;
        mensagem = Utils.removeChars(mensagem);
        this.lastId = id = mensagem.substring(mensagem.indexOf(":") + 1, mensagem.length());
        if (!Funcoes.textoVazio(numeroCelular) && (sms = this.getSmsEnviada(numeroCelular)) != null) {
            sms.setId(Integer.parseInt(id));
            this.fireSmsEnviada(sms);
            this.exportacaoMonitor.setOperacaoAtual("Confirma\u00e7\u00e3o de recebimento de: " + numeroCelular + ".");
        }
        this.enviando = false;
    }

    private void parseCds(String mensagem) {
        String[] m;
        if ((mensagem = Utils.removeChars(mensagem)).contains(",") && (m = mensagem.split(",")).length >= 6) {
            String data = m[4].replaceAll("\"", "") + " " + m[5].replaceAll("\"", "");
            StatusReportBean sr = new StatusReportBean();
            sr.setSmsId(Integer.parseInt(m[1]));
            sr.setSmsNumero(m[2].replaceAll("\"", ""));
            sr.setDataStatus(Utils.stringToDate(data, "yy/MM/dd HH:mm:ss"));
            this.fireStatusReportRecebido(sr);
        }
    }

    public void pararEnvio() {
        if (this.smsEnviar.size() > 0) {
            while (this.smsEnviar.size() > 0) {
                this.fireSmsNaoEnviada(this.smsEnviar.remove(0));
            }
        }
        this.parar = true;
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setQuantidadeParaEnviar(this.smsEnviar.size());
        }
    }

    public void iniciarEnvio() {
        this.parar = false;
        this.run();
    }

    public void setIntervaloTransmissao(long tempo) {
        this.tempoIntervalo = tempo;
    }

    public int getQuantidadeSmsEnviar() {
        return this.smsEnviar.size();
    }

    public boolean isEnviando() {
        return this.smsEnviar.size() > 0 && !this.enviando;
    }

    @Override
    public void run() {
        while (!this.parar) {
            System.out.println("Loop de envio " + this.smsEnviar.size() + " " + this.enviando);
            if (this.smsEnviar.size() > 0 && !this.enviando) {
                try {
                    this.verificaStatus();
                    this.enviarProximaSms();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!this.enviando) {
                StringBuilder cmd = new StringBuilder();
                try {
                    this.enviarTx();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(this.tempoIntervalo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void verificaStatus() {
        StringBuilder cmd = new StringBuilder();
        cmd.append("AT+CPAS").append(PortaSerial.CR);
        this.tx.add(cmd.toString());
        try {
            this.enviarTx();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getGsmModemErrors() {
        HashMap<String, String> gsmModemErrors = new HashMap<String, String>();
        gsmModemErrors.put("0", "Phone failure                                ");
        gsmModemErrors.put("1", "No connection to phone                       ");
        gsmModemErrors.put("2", "Phone adapter link reserved                  ");
        gsmModemErrors.put("3", "Operation not allowed                        ");
        gsmModemErrors.put("4", "Operation not supported                      ");
        gsmModemErrors.put("5", "PH_SIM PIN required                          ");
        gsmModemErrors.put("6", "PH_FSIM PIN required                         ");
        gsmModemErrors.put("7", "PH_FSIM PUK required                         ");
        gsmModemErrors.put("10", "SIM not inserted                             ");
        gsmModemErrors.put("11", "SIM PIN required                             ");
        gsmModemErrors.put("12", "SIM PUK required                             ");
        gsmModemErrors.put("13", "SIM failure                                  ");
        gsmModemErrors.put("14", "SIM busy                                     ");
        gsmModemErrors.put("15", "SIM wrong                                    ");
        gsmModemErrors.put("16", "Incorrect password                           ");
        gsmModemErrors.put("17", "SIM PIN2 required                            ");
        gsmModemErrors.put("18", "SIM PUK2 required                            ");
        gsmModemErrors.put("20", "Memory full                                  ");
        gsmModemErrors.put("21", "Invalid index                                ");
        gsmModemErrors.put("22", "Not found                                    ");
        gsmModemErrors.put("23", "Memory failure                               ");
        gsmModemErrors.put("24", "Text string too long                         ");
        gsmModemErrors.put("25", "Invalid characters in text string            ");
        gsmModemErrors.put("26", "Dial string too long                         ");
        gsmModemErrors.put("27", "Invalid characters in dial string            ");
        gsmModemErrors.put("30", "No network service                           ");
        gsmModemErrors.put("31", "Network timeout                              ");
        gsmModemErrors.put("32", "Network not allowed, emergency calls only    ");
        gsmModemErrors.put("40", "Network personalization PIN required         ");
        gsmModemErrors.put("41", "Network personalization PUK required         ");
        gsmModemErrors.put("42", "Network subset personalization PIN required  ");
        gsmModemErrors.put("43", "Network subset personalization PUK required  ");
        gsmModemErrors.put("44", "Service provider personalization PIN required");
        gsmModemErrors.put("45", "Service provider personalization PUK required");
        gsmModemErrors.put("46", "Corporate personalization PIN required       ");
        gsmModemErrors.put("47", "Corporate personalization PUK required       ");
        gsmModemErrors.put("48", "PH-SIM PUK required                          ");
        gsmModemErrors.put("100", "Unknown error                                ");
        gsmModemErrors.put("103", "Illegal MS                                   ");
        gsmModemErrors.put("106", "Illegal ME                                   ");
        gsmModemErrors.put("107", "GPRS services not allowed                    ");
        gsmModemErrors.put("111", "PLMN not allowed                             ");
        gsmModemErrors.put("112", "Location area not allowed                    ");
        gsmModemErrors.put("113", "Roaming not allowed in this location area    ");
        gsmModemErrors.put("126", "Operation temporary not allowed              ");
        gsmModemErrors.put("132", "Service operation not supported              ");
        gsmModemErrors.put("133", "Requested service option not subscribed      ");
        gsmModemErrors.put("134", "Service option temporary out of order        ");
        gsmModemErrors.put("148", "Unspecified GPRS error                       ");
        gsmModemErrors.put("149", "PDP authentication failure                   ");
        gsmModemErrors.put("150", "Invalid mobile class                         ");
        gsmModemErrors.put("256", "Operation temporarily not allowed            ");
        gsmModemErrors.put("257", "Call barred                                  ");
        gsmModemErrors.put("258", "Phone is busy                                ");
        gsmModemErrors.put("259", "User abort                                   ");
        gsmModemErrors.put("260", "Invalid dial string                          ");
        gsmModemErrors.put("261", "SS not executed                              ");
        gsmModemErrors.put("262", "SIM Blocked                                  ");
        gsmModemErrors.put("263", "Invalid block                                ");
        gsmModemErrors.put("772", "SIM powered down                             ");
        return gsmModemErrors;
    }

    private Map<String, String> getNetworkModemErrors() {
        HashMap<String, String> gsmNetworkErrors = new HashMap<String, String>();
        gsmNetworkErrors.put("1", "Unassigned number                                 ");
        gsmNetworkErrors.put("8", "Operator determined barring                       ");
        gsmNetworkErrors.put("10", "Call bared                                        ");
        gsmNetworkErrors.put("21", "Short message transfer rejected                   ");
        gsmNetworkErrors.put("27", "Destination out of service                        ");
        gsmNetworkErrors.put("28", "Unindentified subscriber                          ");
        gsmNetworkErrors.put("29", "Facility rejected                                 ");
        gsmNetworkErrors.put("30", "Unknown subscriber                                ");
        gsmNetworkErrors.put("38", "Network out of order                              ");
        gsmNetworkErrors.put("41", "Temporary failure                                 ");
        gsmNetworkErrors.put("42", "Congestion                                        ");
        gsmNetworkErrors.put("47", "Recources unavailable                             ");
        gsmNetworkErrors.put("50", "Requested facility not subscribed                 ");
        gsmNetworkErrors.put("69", "Requested facility not implemented                ");
        gsmNetworkErrors.put("81", "Invalid short message transfer reference value    ");
        gsmNetworkErrors.put("95", "Invalid message unspecified                       ");
        gsmNetworkErrors.put("96", "Invalid mandatory information                     ");
        gsmNetworkErrors.put("97", "Message type non existent or not implemented      ");
        gsmNetworkErrors.put("98", "Message not compatible with short message protocol");
        gsmNetworkErrors.put("99", "Information element non-existent or not implemente");
        gsmNetworkErrors.put("111", "Protocol error, unspecified                       ");
        gsmNetworkErrors.put("127", "Internetworking , unspecified                     ");
        gsmNetworkErrors.put("128", "Telematic internetworking not supported           ");
        gsmNetworkErrors.put("129", "Short message type 0 not supported                ");
        gsmNetworkErrors.put("130", "Cannot replace short message                      ");
        gsmNetworkErrors.put("143", "Unspecified TP-PID error                          ");
        gsmNetworkErrors.put("144", "Data code scheme not supported                    ");
        gsmNetworkErrors.put("145", "Message class not supported                       ");
        gsmNetworkErrors.put("159", "Unspecified TP-DCS error                          ");
        gsmNetworkErrors.put("160", "Command cannot be actioned                        ");
        gsmNetworkErrors.put("161", "Command unsupported                               ");
        gsmNetworkErrors.put("175", "Unspecified TP-Command error                      ");
        gsmNetworkErrors.put("176", "TPDU not supported                                ");
        gsmNetworkErrors.put("192", "SC busy                                           ");
        gsmNetworkErrors.put("193", "No SC subscription                                ");
        gsmNetworkErrors.put("194", "SC System failure                                 ");
        gsmNetworkErrors.put("195", "Invalid SME address                               ");
        gsmNetworkErrors.put("196", "Destination SME barred                            ");
        gsmNetworkErrors.put("197", "SM Rejected-Duplicate SM                          ");
        gsmNetworkErrors.put("198", "TP-VPF not supported                              ");
        gsmNetworkErrors.put("199", "TP-VP not supported                               ");
        gsmNetworkErrors.put("208", "D0 SIM SMS Storage full                           ");
        gsmNetworkErrors.put("209", "No SMS Storage capability in SIM                  ");
        gsmNetworkErrors.put("210", "Error in MS                                       ");
        gsmNetworkErrors.put("211", "Memory capacity exceeded                          ");
        gsmNetworkErrors.put("212", "Sim application toolkit busy                      ");
        gsmNetworkErrors.put("213", "SIM data download error                           ");
        gsmNetworkErrors.put("255", "Unspecified error cause                           ");
        gsmNetworkErrors.put("300", "ME Failure                                        ");
        gsmNetworkErrors.put("301", "SMS service of ME reserved                        ");
        gsmNetworkErrors.put("302", "Operation not allowed                             ");
        gsmNetworkErrors.put("303", "Operation not supported                           ");
        gsmNetworkErrors.put("304", "Invalid PDU mode parameter                        ");
        gsmNetworkErrors.put("305", "Invalid Text mode parameter                       ");
        gsmNetworkErrors.put("310", "SIM not inserted                                  ");
        gsmNetworkErrors.put("311", "SIM PIN required                                  ");
        gsmNetworkErrors.put("312", "PH-SIM PIN required                               ");
        gsmNetworkErrors.put("313", "SIM failure                                       ");
        gsmNetworkErrors.put("314", "SIM busy                                          ");
        gsmNetworkErrors.put("315", "SIM wrong                                         ");
        gsmNetworkErrors.put("316", "SIM PUK required                                  ");
        gsmNetworkErrors.put("317", "SIM PIN2 required                                 ");
        gsmNetworkErrors.put("318", "SIM PUK2 required                                 ");
        gsmNetworkErrors.put("320", "Memory failure                                    ");
        gsmNetworkErrors.put("321", "Invalid memory index                              ");
        gsmNetworkErrors.put("322", "Memory full                                       ");
        gsmNetworkErrors.put("330", "SMSC address unknown                              ");
        gsmNetworkErrors.put("331", "No network service                                ");
        gsmNetworkErrors.put("332", "Network timeout                                   ");
        gsmNetworkErrors.put("340", "No +CNMA expected                                 ");
        gsmNetworkErrors.put("500", "Unknown error                                     ");
        gsmNetworkErrors.put("512", "User abort                                        ");
        gsmNetworkErrors.put("513", "Unable to store                                   ");
        gsmNetworkErrors.put("514", "Invalid Status                                    ");
        gsmNetworkErrors.put("515", "Device busy or Invalid Character in string        ");
        gsmNetworkErrors.put("516", "Invalid length                                    ");
        gsmNetworkErrors.put("517", "Invalid character in PDU                          ");
        gsmNetworkErrors.put("518", "Invalid parameter                                 ");
        gsmNetworkErrors.put("519", "Invalid length or character                       ");
        gsmNetworkErrors.put("520", "Invalid character in text                         ");
        gsmNetworkErrors.put("521", "Timer expired                                     ");
        gsmNetworkErrors.put("522", "Operation temporary not allowed                   ");
        gsmNetworkErrors.put("532", "SIM not ready                                     ");
        gsmNetworkErrors.put("534", "Cell Broadcast error unknown                      ");
        gsmNetworkErrors.put("535", "Protocol stack busy                               ");
        gsmNetworkErrors.put("538", "Invalid parameter                                 ");
        return gsmNetworkErrors;
    }

    public int getValorSinal() {
        return this.valorSinal;
    }

    private void atualizaTempoEntreIteracoes() {
        if (this.tempoIteracaoAnterior != null) {
            Calendar calAnterior = Calendar.getInstance();
            calAnterior.setTime(this.tempoIteracaoAnterior);
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new Date());
            long qtde = calAtual.getTimeInMillis() - calAnterior.getTimeInMillis();
            this.exportacaoMonitor.setTempoEntreIteracoes(qtde);
            this.tempoIteracaoAnterior = calAtual.getTime();
        } else {
            this.tempoIteracaoAnterior = new Date();
        }
    }

    public ArrayList<SmsBean> getSmsEnviar() {
        return this.smsEnviar;
    }
}

