/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.menu;

import jalis.util.logger.ErrorLogger;
import jalis.util.menu.ItemMenu;
import jalis.util.menu.ThreadMenuEvento;
import jalis.util.menu.ThreadMenuListener;
import javax.swing.event.EventListenerList;

public class ThreadMenu
extends Thread {
    public static final int VELOCIDADE_DESLOCAMENTO = 20;
    private ItemMenu[] itens;
    private int[] destino;
    private EventListenerList listenerList = new EventListenerList();

    public ThreadMenu(ItemMenu[] itens, int[] destino) {
        super("Menu - Thread");
        this.setPriority(1);
        this.itens = itens;
        this.destino = destino;
    }

    public void addThreadMenuListener(ThreadMenuListener l) {
        this.listenerList.add(ThreadMenuListener.class, l);
    }

    public void removeThreadMenuListener(ThreadMenuListener l) {
        this.listenerList.remove(ThreadMenuListener.class, l);
    }

    @Override
    public void run() {
        if (this.itens != null && this.destino != null && this.itens.length == this.destino.length) {
            try {
                int veloc = 20;
                for (int i = 0; i < this.itens.length && !this.isInterrupted(); ++i) {
                    int y;
                    boolean maior;
                    if (i > 0) {
                        this.itens[i].setLocation(this.itens[i].getX(), this.itens[i - 1].getY());
                    }
                    boolean bl = maior = (y = this.itens[i].getY()) > this.destino[i];
                    while (!this.isInterrupted() && (maior && y > this.destino[i] || !maior && y < this.destino[i])) {
                        y = maior ? y - veloc : y + veloc;
                        this.itens[i].setLocation(this.itens[i].getX(), y);
                        ThreadMenu.sleep(1L);
                    }
                    this.itens[i].setLocation(this.itens[i].getX(), this.destino[i]);
                }
                this.fireTerminouExecucao();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ThreadMenu: 65");
            }
        }
    }

    private void fireTerminouExecucao() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = 0; i < ouvintes.length; ++i) {
            if (ouvintes[i] != ThreadMenuListener.class) continue;
            ((ThreadMenuListener)ouvintes[i + 1]).terminouExecucao(new ThreadMenuEvento(this, this.itens));
        }
    }
}

