/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.menu;

import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.menu.Habilita;
import jalis.util.menu.ItemMenu;
import jalis.util.menu.MenuEvento;
import jalis.util.menu.MenuListener;
import jalis.util.menu.ScrollablePanel;
import jalis.util.menu.ThreadDesabilita;
import jalis.util.menu.ThreadMenu;
import jalis.util.menu.ThreadMenuEvento;
import jalis.util.menu.ThreadMenuListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Menu
extends JPanel
implements MenuListener {
    private static final int DISTANCIA = 3;
    private static final int ALTURA_BOTAO = 25;
    private JPanel panelBotoes = new JPanel(null);
    private ScrollablePanel panelItens = new ScrollablePanel(null);
    private Stack<ItemMenu> pilha = new Stack();
    private ItemMenu raiz = new ItemMenu();
    private ThreadDesabilita threadDesabilita = null;
    private ComponentListener ouvinteItem = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent e) {
            Menu.this.reposicionarItens();
            Menu.this.redimensionar();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            Menu.this.reposicionarItens();
            Menu.this.redimensionar();
        }
    };
    private ThreadMenuListener ouvinteSubir = new ThreadMenuListener(){

        @Override
        public void terminouExecucao(ThreadMenuEvento e) {
            final ItemMenu[] itens = e.getItens();
            Menu.this.removeComponente(Menu.this.panelItens, itens[0]);
            if (Menu.this.pilha.empty()) {
                Menu.this.addComponente(Menu.this.panelBotoes, Menu.this.raiz.getBotao(25), Menu.this.getProxYBotao());
                Menu.this.pilha.push(Menu.this.raiz);
            }
            Menu.this.addComponente(Menu.this.panelBotoes, itens[0].getBotao(25), Menu.this.getProxYBotao());
            Menu.this.pilha.push(itens[0]);
            Menu.this.redimensionarBotoes();
            Menu.this.revalidate();
            Menu.this.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Menu.this.carregarSubitens(itens[0]);
                }
            });
        }
    };

    public Menu(String imagemPrincipal) {
        this.inicia(new ImageIcon(imagemPrincipal));
    }

    public Menu(ImageIcon imagemPrincipal) {
        this.inicia(imagemPrincipal);
    }

    private void inicia(ImageIcon imagemPrincipal) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (Component c : ArraysUtil.concatenar(Menu.this.panelBotoes.getComponents(), Menu.this.panelItens.getComponents())) {
                    c.setSize(Menu.this.getLarguraParaItem(), c.getHeight());
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.panelItens);
        scroll.setBorder(null);
        scroll.getViewport().setBackground(Color.white);
        scroll.setHorizontalScrollBarPolicy(31);
        this.add((Component)scroll, "Center");
        this.add((Component)this.panelBotoes, "North");
        this.panelBotoes.setBackground(Color.white);
        this.panelBotoes.setBorder(null);
        this.panelItens.setBackground(Color.white);
        this.panelItens.setBorder(null);
        this.raiz.setTexto("Principal");
        this.raiz.setImagem(imagemPrincipal);
        this.raiz.addMenuListener(this);
        this.setName("Menu");
    }

    public ItemMenu[] getItens() {
        return this.raiz.getItens();
    }

    public ItemMenu getRaiz() {
        return this.raiz;
    }

    @Override
    public void setFont(Font fonte) {
        super.setFont(fonte);
        if (this.raiz != null) {
            this.raiz.setFont(fonte);
        }
    }

    public void addItem(ItemMenu item) {
        if (item != null && !this.raiz.contem(item)) {
            if (this.raiz()) {
                this.addComponente(this.panelItens, item, 0);
                item.addMenuListener(this);
            }
            item.setName(item.getTexto());
            item.setFont(this.getFont());
            item.setForeground(this.getForeground());
            this.raiz.addItem(item);
            this.reposicionarItens();
            this.redimensionar();
        }
    }

    public void desabilitarIrmaos(ItemMenu item) {
        ArrayList<Habilita> itens = new ArrayList<Habilita>();
        for (Component c : ArraysUtil.concatenar(this.panelBotoes.getComponents(), this.panelItens.getComponents())) {
            if (c == item || !(c instanceof Habilita)) continue;
            itens.add((Habilita)((Object)c));
        }
        this.threadDesabilita = new ThreadDesabilita(itens.toArray(new Habilita[itens.size()]));
        this.threadDesabilita.start();
    }

    public void desabilitarTodosItens() {
        ArrayList<Habilita> itens = new ArrayList<Habilita>();
        try {
            if (this.threadDesabilita != null) {
                this.threadDesabilita.interrupt();
                this.threadDesabilita = null;
                Thread.sleep(100L);
            }
            for (Component c : ArraysUtil.concatenar(this.panelBotoes.getComponents(), this.panelItens.getComponents())) {
                if (!(c instanceof Habilita)) continue;
                ((Habilita)((Object)c)).setHabilitado(false);
                itens.add((Habilita)((Object)c));
            }
            this.threadDesabilita = new ThreadDesabilita(itens.toArray(new Habilita[itens.size()]));
            this.threadDesabilita.start();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Menu: 219");
        }
    }

    public void habilitarItens() {
        try {
            if (this.threadDesabilita != null) {
                this.threadDesabilita.interrupt();
                this.threadDesabilita = null;
                Thread.sleep(100L);
            }
            for (Component c : ArraysUtil.concatenar(this.panelBotoes.getComponents(), this.panelItens.getComponents())) {
                if (!(c instanceof Habilita)) continue;
                ((Habilita)((Object)c)).setHabilitado(true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Menu: 211");
        }
    }

    public void exibirRaiz() {
        if (this.pilha.size() > 0) {
            this.desempilhar(this.raiz);
        }
    }

    public void retornarAposLogout() {
        this.carregarSubitens(this.raiz);
    }

    public void removeItem(ItemMenu item) {
        if (this.raiz.contem(item)) {
            this.raiz.remove(item);
            item.removeMenuListener(this);
            item.removeComponentListener(this.ouvinteItem);
            this.panelItens.remove(item);
        }
    }

    @Override
    public void acionouItem(MenuEvento e) {
        ItemMenu item = (ItemMenu)e.getSource();
        if (e.origemItem()) {
            this.empilhar(item);
        } else if (e.origemBotao()) {
            this.desempilhar(item);
        }
        this.repaint();
    }

    @Override
    public Component add(Component c) {
        return c;
    }

    private void empilhar(ItemMenu item) {
        ItemMenu pai = this.getPai(this.raiz, item);
        if (pai != null) {
            for (ItemMenu irmao : pai.getItens()) {
                if (irmao == item) continue;
                this.removeComponente(this.panelItens, irmao);
                irmao.removeMenuListener(this);
            }
            ThreadMenu thread = new ThreadMenu(new ItemMenu[]{item}, new int[]{28});
            thread.addThreadMenuListener(this.ouvinteSubir);
            thread.start();
        }
    }

    private void desempilhar(ItemMenu item) {
        if (this.pilha.peek() != item) {
            for (ItemMenu subitem : this.pilha.peek().getItens()) {
                this.removeComponente(this.panelItens, subitem);
                subitem.removeMenuListener(this);
            }
            while (!this.pilha.empty() && this.pilha.peek() != item) {
                ItemMenu tmp = this.pilha.pop();
                this.removeComponente(this.panelBotoes, tmp.getBotao(0));
                tmp.removeMenuListener(this);
            }
            if (this.pilha.size() == 1) {
                this.removeComponente(this.panelBotoes, this.pilha.pop().getBotao(1));
            }
            this.redimensionarBotoes();
            this.revalidate();
            this.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Menu.this.carregarSubitens(Menu.this.pilha.empty() ? Menu.this.raiz : (ItemMenu)Menu.this.pilha.peek());
                }
            });
        }
    }

    private void carregarSubitens(ItemMenu item) {
        ItemMenu[] subitens = this.getItensVisiveis(item);
        this.reposicionarScroll();
        for (ItemMenu subitem : subitens) {
            subitem.setFont(this.getFont());
            subitem.setForeground(this.getForeground());
            subitem.addMenuListener(this);
            this.addComponente(this.panelItens, subitem, 0);
        }
        ThreadMenu thread = new ThreadMenu(subitens, this.getProxYItens(subitens));
        thread.addThreadMenuListener(new ThreadMenuListener(){

            @Override
            public void terminouExecucao(ThreadMenuEvento e) {
                Menu.this.redimensionar();
            }
        });
        thread.start();
    }

    private void addComponente(JPanel local, Component item, int y) {
        item.setSize(new Dimension(this.getLarguraParaItem(), item.getHeight()));
        item.addComponentListener(this.ouvinteItem);
        item.setLocation(3, y);
        local.add(item);
    }

    private void removeComponente(JPanel local, Component item) {
        item.removeComponentListener(this.ouvinteItem);
        local.remove(item);
    }

    private ItemMenu[] getItensVisiveis(ItemMenu item) {
        ArrayList<ItemMenu> tmp = new ArrayList<ItemMenu>();
        for (ItemMenu itemMenu : item.getItens()) {
            if (!itemMenu.isVisible()) continue;
            tmp.add(itemMenu);
        }
        return tmp.toArray(new ItemMenu[tmp.size()]);
    }

    private ItemMenu getPai(ItemMenu raiz, ItemMenu item) {
        if (raiz.vazio()) {
            return null;
        }
        if (ArraysUtil.contem(raiz.getItens(), item)) {
            return raiz;
        }
        ItemMenu pai = null;
        ItemMenu[] aRaiz = raiz.getItens();
        for (int i = 0; i < aRaiz.length && pai == null; ++i) {
            pai = this.getPai(aRaiz[i], item);
        }
        return pai;
    }

    private int getProxYBotao() {
        return this.pilha.size() * 28 + 3;
    }

    private int[] getProxYItens(ItemMenu[] itens) {
        int[] y = new int[]{};
        if (itens != null && itens.length > 0) {
            y = new int[itens.length];
            y[0] = 3;
            for (int i = 1; i < itens.length; ++i) {
                y[i] = y[i - 1] + itens[i - 1].getHeight() + 3;
            }
        }
        return y;
    }

    private boolean raiz() {
        return this.pilha.empty();
    }

    private int getLarguraParaItem() {
        return this.getWidth() - 6 - 15;
    }

    public void reposicionarScroll() {
        this.panelItens.scrollRectToVisible(new Rectangle(0, 0, 50, 10));
    }

    public void reposicionarItens() {
        int proxY = 3;
        for (Component c : this.panelBotoes.getComponents()) {
            c.setLocation(3, proxY);
            proxY += c.getHeight() + 3;
        }
        proxY = 3;
        for (Component c : this.panelItens.getComponents()) {
            if (!c.isVisible()) continue;
            c.setLocation(3, proxY);
            proxY += c.getHeight() + 3;
        }
    }

    public void redimensionar() {
        this.redimensionarBotoes();
        this.redimensionarItens();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Menu.this.panelBotoes.revalidate();
                Menu.this.panelItens.revalidate();
                Menu.this.revalidate();
                Menu.this.repaint();
            }
        });
    }

    private void redimensionarBotoes() {
        Component[] comps = this.panelBotoes.getComponents();
        int altura = comps.length * 3;
        for (Component c : comps) {
            altura += c.getHeight();
        }
        this.panelBotoes.setPreferredSize(new Dimension(this.getWidth(), altura));
    }

    private void redimensionarItens() {
        Component[] comps = this.panelItens.getComponents();
        int altura = (comps.length + 1) * 3;
        for (Component c : comps) {
            if (!c.isVisible()) continue;
            altura += c.getHeight();
        }
        this.panelItens.setSize(new Dimension(this.getWidth(), altura));
        this.panelItens.setPreferredSize(new Dimension(this.getWidth(), altura));
    }

    @Override
    public void adicionarTool(MenuEvento e) {
    }

    public void validarItensVisiveis(String tipoFilial) {
        if (Funcoes.textoVazio(tipoFilial)) {
            return;
        }
        this.validarItensVisiveis(tipoFilial, this.raiz);
    }

    private void validarItensVisiveis(String tipoFilial, ItemMenu raiz) {
        String titulo = "";
        ImageIcon imagem = null;
        ImageIcon imagemOn = null;
        if (tipoFilial.equalsIgnoreCase("C")) {
            titulo = Funcoes.textoVazio(raiz.getTextoClinicas()) ? raiz.getTexto() : raiz.getTextoClinicas();
            imagem = raiz.getImagemClinicas();
            imagemOn = raiz.getImagemOnClinicas();
            raiz.setVisible(raiz.isVisible() && !raiz.getOcultarSeFilialClinicas());
        } else if (tipoFilial.equalsIgnoreCase("A")) {
            titulo = Funcoes.textoVazio(raiz.getTextoAlimentos()) ? (Funcoes.textoVazio(raiz.getTextoClinicas()) ? raiz.getTexto() : raiz.getTextoClinicas()) : raiz.getTextoAlimentos();
            imagem = raiz.getImagemAlimentos() == null ? raiz.getImagemClinicas() : raiz.getImagemAlimentos();
            imagemOn = raiz.getImagemOnAlimentos() == null ? raiz.getImagemOnClinicas() : raiz.getImagemOnAlimentos();
            raiz.setVisible(raiz.isVisible() && !raiz.getOcultarSeFilialAlimentos());
        } else if (tipoFilial.equalsIgnoreCase("V")) {
            titulo = Funcoes.textoVazio(raiz.getTextoVeterinaria()) ? (Funcoes.textoVazio(raiz.getTextoClinicas()) ? raiz.getTexto() : raiz.getTextoClinicas()) : raiz.getTextoVeterinaria();
            imagem = raiz.getImagemVeterinaria() == null ? raiz.getImagemClinicas() : raiz.getImagemVeterinaria();
            imagemOn = raiz.getImagemOnVeterinaria() == null ? raiz.getImagemOnClinicas() : raiz.getImagemOnVeterinaria();
            raiz.setVisible(raiz.isVisible() && !raiz.getOcultarSeFilialVeterinaria());
        }
        raiz.setTexto(titulo);
        if (imagem != null) {
            raiz.setImagem(imagem);
        }
        if (imagemOn != null) {
            raiz.setImagemOn(imagemOn);
        }
        for (ItemMenu item : raiz.getItens()) {
            this.validarItensVisiveis(tipoFilial, item);
        }
    }
}

