/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.menu;

import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.menu.Botao;
import jalis.util.menu.Habilita;
import jalis.util.menu.Menu;
import jalis.util.menu.MenuEvento;
import jalis.util.menu.MenuListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ItemMenu
extends JPanel
implements Habilita,
MouseListener,
MouseMotionListener {
    public static final Cursor CUR_LINK = new Cursor(12);
    public static final Cursor CUR_SETA = new Cursor(0);
    private static final int DISTANCIA = 15;
    private ArrayList<ItemMenu> itens = new ArrayList();
    private Botao botao = null;
    private JLabel label = new JLabel();
    private ImageIcon imagem = null;
    private ImageIcon imagemOn = null;
    private long codigoAcesso = 0L;
    private boolean mouseOn = false;
    private float alpha = 1.0f;
    private boolean habilitado = true;
    private Object constraint = null;
    private boolean ocultarSeFilialClinicas = false;
    private boolean ocultarSeFilialAlimentos = false;
    private boolean ocultarSeFilialVeterinaria = false;
    private String textoClinicas = "";
    private ImageIcon imagemClinicas = null;
    private ImageIcon imagemOnClinicas = null;
    private String textoAlimentos = "";
    private ImageIcon imagemAlimentos = null;
    private ImageIcon imagemOnAlimentos = null;
    private String textoVeterinaria = "";
    private ImageIcon imagemVeterinaria = null;
    private ImageIcon imagemOnVeterinaria = null;

    public ItemMenu() {
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.label.setHorizontalAlignment(0);
        this.redimensionar();
        this.setVisible(false);
    }

    public ItemMenu(String tituloClinicas, ImageIcon imagemClinicas, ImageIcon imagemOnClinicas, long codigoAcesso, String tituloAlimentos, ImageIcon imagemAlimentos, ImageIcon imagemOnAlimentos) {
        this(tituloClinicas, imagemClinicas, imagemOnClinicas, codigoAcesso);
        this.textoAlimentos = tituloAlimentos;
        this.imagemAlimentos = imagemAlimentos;
        this.imagemOnAlimentos = imagemOnAlimentos;
    }

    public ItemMenu(String tituloClinicas, ImageIcon imagemClinicas, ImageIcon imagemOnClinicas, long codigoAcesso, String tituloAlimentos, ImageIcon imagemAlimentos, ImageIcon imagemOnAlimentos, String tituloVeterinaria, ImageIcon imagemVeterinaria, ImageIcon imagemOnVeterinaria) {
        this(tituloClinicas, imagemClinicas, imagemOnClinicas, codigoAcesso, tituloAlimentos, imagemAlimentos, imagemOnAlimentos);
        this.textoVeterinaria = tituloVeterinaria;
        this.imagemVeterinaria = imagemVeterinaria;
        this.imagemOnVeterinaria = imagemOnVeterinaria;
    }

    public ItemMenu(String tituloClinicas, ImageIcon imagemClinicas, ImageIcon imagemOnClinicas, long codigoAcesso) {
        this();
        this.setTexto(tituloClinicas);
        this.setImagem(imagemClinicas);
        this.setImagemOn(imagemOnClinicas);
        this.setCodigoAcesso(codigoAcesso);
        this.setName(String.valueOf(codigoAcesso));
        this.textoClinicas = tituloClinicas;
        this.imagemClinicas = imagemClinicas;
        this.imagemOnClinicas = imagemOnClinicas;
    }

    public ItemMenu(String texto, ImageIcon imagem, ImageIcon imageOn, long codigoAcesso, Object constraint) {
        this(texto, imagem, imageOn, codigoAcesso);
        this.setConstraint(constraint);
    }

    public void addMenuListener(MenuListener l) {
        this.listenerList.add(MenuListener.class, l);
    }

    public void removeMenuListener(MenuListener l) {
        this.listenerList.remove(MenuListener.class, l);
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    @Override
    public void setHabilitado(boolean habilitado) {
        this.habilitado = habilitado;
        this.setAlpha(1.0f);
    }

    public void addItem(ItemMenu item) {
        if (item != null && !this.itens.contains(item)) {
            this.itens.add(item);
            if (item.getTexto() != null && !item.getTexto().isEmpty()) {
                item.setName(StringUtil.removerTags(item.getTexto()).replaceAll(" ", "").trim());
            }
        }
    }

    public void removeItem(ItemMenu item) {
        if (this.contem(item)) {
            this.itens.remove(item);
        }
    }

    public long getCodigoAcesso() {
        return this.codigoAcesso;
    }

    public void setCodigoAcesso(long codigo) {
        this.codigoAcesso = codigo;
    }

    public boolean contem(ItemMenu item) {
        return this.itens.contains(item);
    }

    public boolean vazio() {
        return this.itens.size() == 0;
    }

    public int quantidade() {
        return this.itens.size();
    }

    public ItemMenu[] getItens() {
        return this.itens.toArray(new ItemMenu[this.itens.size()]);
    }

    public ItemMenu getItem(int posicao) {
        if (posicao > -1 && posicao < this.itens.size()) {
            return this.itens.get(posicao);
        }
        return null;
    }

    public JPanel getBotao(int altura) {
        if (this.botao == null) {
            this.botao = new Botao();
            this.botao.setCursor(CUR_LINK);
            this.botao.setBackground(this.getBackground());
            this.botao.setText(StringUtil.removerTags(this.getTexto()));
            this.botao.setFont(this.getFont());
            this.botao.setSize(new Dimension(10, altura));
            this.botao.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ItemMenu.this.habilitado) {
                        ItemMenu.this.fireAcionouItem(0);
                    }
                }
            });
            if (this.imagem != null) {
                this.botao.setIcon(new ImageIcon(this.imagem.getImage().getScaledInstance(altura - 2, altura - 2, 4)));
            }
        }
        return this.botao;
    }

    public void setTexto(String texto) {
        if (this.label != null) {
            this.label.setText(texto);
            this.label.setSize(this.label.getPreferredSize());
        }
    }

    public String getTexto() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    public void setImagem(ImageIcon imagem) {
        this.imagem = imagem;
        if (this.imagem == null) {
            this.imagem = this.criarImagemVazia();
        }
        this.redimensionar();
    }

    @Deprecated
    public void setImagemOn(ImageIcon imagem) {
    }

    private ImageIcon criarImagemVazia() {
        BufferedImage img = new BufferedImage(60, 60, 2);
        Graphics2D g = img.createGraphics();
        g.setBackground(Color.WHITE);
        g.setColor(Color.BLACK);
        g.drawRect(3, 3, 20, 25);
        g.setColor(Color.RED);
        g.drawOval(5, 5, 6, 6);
        g.fillOval(5, 5, 6, 6);
        return new ImageIcon(img);
    }

    public ImageIcon getImagem() {
        return this.imagem;
    }

    public void setExibirTexto(boolean exibir) {
        if (this.label != null) {
            this.label.setVisible(exibir);
        }
    }

    public boolean getExibirTexto() {
        if (this.label != null) {
            return this.label.isVisible();
        }
        return false;
    }

    public void setConstraint(Object o) {
        this.constraint = o;
    }

    public <T> T getConstraint(Class<T> c) {
        return c.isInstance(this.constraint) ? (T)c.cast(this.constraint) : null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.getCursor() == CUR_LINK && this.habilitado) {
            if (e.getButton() == 3 && !this.contemItens()) {
                this.fireAdicionouTool(1);
            } else {
                this.fireAcionouItem(1);
            }
        }
        this.mouseOn = false;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseOn = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean bl = this.mouseOn = this.habilitado && this.contemPonto(e.getPoint());
        if (this.mouseOn) {
            this.setCursor(CUR_LINK);
        } else {
            this.setCursor(CUR_SETA);
        }
        this.repaint();
    }

    @Override
    public void setFont(Font fonte) {
        super.setFont(fonte);
        if (this.label != null) {
            this.label.setFont(fonte);
        }
        this.redimensionar();
    }

    @Override
    public void setForeground(Color cor) {
        super.setForeground(cor);
        if (this.label != null) {
            this.label.setForeground(cor);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        int h = this.getHeight();
        int w = this.getWidth();
        ImageIcon tmp = this.imagem;
        if (tmp != null) {
            int x = (w - tmp.getIconWidth()) / 2;
            tmp.paintIcon(this, g2d, x, 2);
        }
        if (this.mouseOn && this.habilitado) {
            Stroke sOld = g2d.getStroke();
            g2d.setStroke(new BasicStroke(5.0f));
            g2d.setColor(ScreenUtil.clarearCor(Color.GRAY, 96));
            RoundRectangle2D.Double border = new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 3.0, 3.0);
            Area area = new Area(border);
            g2d.draw(area);
            g2d.setStroke(sOld);
        }
        if (this.getExibirTexto()) {
            Dimension size = this.label.getSize();
            g2d.translate((w - size.width) / 2, h - (size.height + 8));
            this.label.paint(g2d);
        }
    }

    protected void fireAcionouItem(int origem) {
        for (MenuListener ouvinte : (MenuListener[])this.listenerList.getListeners(MenuListener.class)) {
            if (this.contemItens() ^ ouvinte instanceof Menu) continue;
            ouvinte.acionouItem(new MenuEvento(this, origem));
        }
    }

    protected void fireAdicionouTool(int origem) {
        for (MenuListener ouvinte : (MenuListener[])this.listenerList.getListeners(MenuListener.class)) {
            if (this.contemItens() ^ ouvinte instanceof Menu) continue;
            ouvinte.adicionarTool(new MenuEvento(this, origem));
        }
    }

    private boolean contemItens() {
        return this.itens.size() > 0;
    }

    private void redimensionar() {
        int altura = 3;
        if (this.getExibirTexto()) {
            altura += this.label.getSize().height;
        }
        if (this.imagem != null) {
            altura = this.imagemOn != null && this.imagemOn.getIconHeight() > this.imagem.getIconHeight() ? (altura += this.imagemOn.getIconHeight()) : (altura += this.imagem.getIconHeight());
        }
        this.setSize(new Dimension(this.getWidth(), altura));
    }

    private boolean contemPonto(Point p) {
        Rectangle[] rec = this.getRetangulos();
        return rec[0].contains(p) || rec[1].contains(p);
    }

    private Rectangle[] getRetangulos() {
        ArrayList<Rectangle> tmp = new ArrayList<Rectangle>();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.imagem == null) {
            tmp.add(new Rectangle());
        } else {
            tmp.add(new Rectangle((width - this.imagem.getIconWidth()) / 2, 15, this.imagem.getIconWidth(), this.imagem.getIconHeight()));
        }
        if (this.getExibirTexto()) {
            Dimension size = this.label.getSize();
            tmp.add(new Rectangle(new Point((width - size.width) / 2, height - size.height), size));
        } else {
            tmp.add(new Rectangle());
        }
        return tmp.toArray(new Rectangle[tmp.size()]);
    }

    public boolean getOcultarSeFilialAlimentos() {
        return this.ocultarSeFilialAlimentos;
    }

    public boolean getOcultarSeFilialClinicas() {
        return this.ocultarSeFilialClinicas;
    }

    public boolean getOcultarSeFilialVeterinaria() {
        return this.ocultarSeFilialVeterinaria;
    }

    public void setOcultarSeFilialClinicas(boolean ocultar) {
        this.ocultarSeFilialClinicas = ocultar;
    }

    public void setOcultarSeFilialAlimentos(boolean ocultar) {
        this.ocultarSeFilialAlimentos = ocultar;
    }

    public void setOcultarSeFilialVeterinaria(boolean ocultar) {
        this.ocultarSeFilialVeterinaria = ocultar;
    }

    public String getTextoClinicas() {
        return this.textoClinicas;
    }

    public String getTextoAlimentos() {
        return this.textoAlimentos;
    }

    public String getTextoVeterinaria() {
        return this.textoVeterinaria;
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    @Override
    public void removeMouseListener(MouseListener l) {
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public ImageIcon getImagemAlimentos() {
        return this.imagemAlimentos;
    }

    public ImageIcon getImagemClinicas() {
        return this.imagemClinicas;
    }

    public ImageIcon getImagemVeterinaria() {
        return this.imagemVeterinaria;
    }

    public ImageIcon getImagemOnAlimentos() {
        return this.imagemOnAlimentos;
    }

    public ImageIcon getImagemOnClinicas() {
        return this.imagemOnClinicas;
    }

    public ImageIcon getImagemOnVeterinaria() {
        return this.imagemOnVeterinaria;
    }
}

