/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.menu;

import jalis.util.menu.Habilita;
import jalis.util.menu.ItemMenu;
import java.awt.AlphaComposite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPanel;

class Botao
extends JPanel
implements Habilita {
    private String texto = "";
    private Icon icone;
    private float alpha = 1.0f;
    private boolean habilitado = true;
    private ActionEvent event = new ActionEvent(this, 0, "");

    public Botao() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Botao.this.habilitado) {
                    Botao.this.fireActionPerformed();
                }
            }
        });
    }

    public void setText(String texto) {
        this.texto = texto;
    }

    public void setIcon(Icon icone) {
        this.icone = icone;
    }

    @Override
    public void setHabilitado(boolean habilitado) {
        this.habilitado = habilitado;
        this.setAlpha(1.0f);
        this.setCursor(habilitado ? ItemMenu.CUR_LINK : ItemMenu.CUR_SETA);
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        int x = 10;
        if (this.icone != null) {
            x += this.icone.getIconWidth() + 2;
            this.icone.paintIcon(this, g2d, 5, (this.getHeight() - this.icone.getIconHeight()) / 2);
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics(this.getFont());
        g2d.drawString(this.texto, x, (this.getHeight() + fm.getHeight()) / 2 - fm.getDescent());
    }

    private void fireActionPerformed() {
        for (ActionListener ouvinte : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            ouvinte.actionPerformed(this.event);
        }
    }
}

