/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.logger;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class ErrorLogger
extends JDialog
implements ActionListener {
    private JButton buttonEnviar = new JButton("Enviar erro");
    private JButton buttonNaoEnviar = new JButton("N\u00e3o enviar");
    private JButton buttonOK = new JButton("OK");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelImagem = new JLabel(ImagemUtils.carregaImagemJalis("errorlogger.jpg"));
    private JLabel label1 = new JLabel("O sistema foi paralisado devido a uma situa\u00e7\u00e3o inesperada. ");
    private JLabel label2 = new JLabel("\u00c9 aconselh\u00e1vel que o sistema seja reiniciado.");
    private JLabel label3 = new JLabel("Um relat\u00f3rio com detalhes da situa\u00e7\u00e3o foi armazenado para poss\u00edvel");
    private JLabel label4 = new JLabel("an\u00e1lise de nossa equipe. ");
    private JLabel label5 = new JLabel("<html><font>Lode - We Love Code - (44) 3031-2552 - suporte@lode.com.br</font></html>");
    private JTextArea txtErro = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.txtErro);
    private JTextArea txtComentario = new JTextArea();
    private JScrollPane scrollComentario = new JScrollPane(this.txtComentario);
    private JPanel panelErro = new JPanel(new BorderLayout());
    private JPanel panelComentario = new JPanel(new BorderLayout());
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private GridBagConstraints cons = new GridBagConstraints();
    public static String EMAIL = "erro@thread.com.br";
    public static String SENHA = "murphy";
    public static String SMTP = "smtp.thread.com.br";
    public static String PORTA = "587";
    private static boolean mostrarMensagemErro = false;
    private StackTraceElement[] erro;
    private String mensagem = "";
    private String tela = "";
    private static Component pai = null;

    public ErrorLogger(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ErrorLogger(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("ErrorLogger");
        this.setLayout(new BorderLayout());
        this.setTitle("Situa\u00e7\u00e3o inesperada");
        this.setResizable(false);
        this.setSize(new Dimension(550, 330));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonOK);
        this.cons.gridx = 0;
        this.cons.gridy = 0;
        this.cons.fill = 3;
        this.cons.anchor = 11;
        this.cons.insets = new Insets(5, 3, 0, 5);
        this.cons.gridheight = 7;
        this.labelImagem.setVerticalAlignment(1);
        this.panelCentro.add((Component)this.labelImagem, this.cons);
        this.cons.gridx = 1;
        this.cons.fill = 2;
        this.cons.anchor = 17;
        this.cons.gridheight = 1;
        this.cons.weightx = 1.0;
        this.panelCentro.add((Component)this.label1, this.cons);
        this.cons.gridy = 1;
        this.panelCentro.add((Component)this.label2, this.cons);
        this.cons.gridy = 2;
        this.panelCentro.add((Component)this.label3, this.cons);
        this.cons.gridy = 3;
        this.panelCentro.add((Component)this.label4, this.cons);
        this.cons.gridx = 1;
        this.cons.gridy = 4;
        this.cons.fill = 1;
        this.cons.weighty = 1.0;
        this.cons.gridwidth = 2;
        this.panelErro.setBorder(new TitledBorder("Mensagem"));
        this.panelErro.add((Component)this.scroll, "Center");
        this.panelCentro.add((Component)this.panelErro, this.cons);
        this.scroll.setBorder(null);
        this.cons.gridy = 5;
        this.panelComentario.setBorder(new TitledBorder("Coment\u00e1rio"));
        this.panelComentario.add((Component)this.scrollComentario, "Center");
        this.panelCentro.add((Component)this.panelComentario, this.cons);
        this.cons.gridy = 6;
        this.cons.fill = 2;
        this.cons.weighty = 0.0;
        this.panelCentro.add((Component)this.label5, this.cons);
        this.txtErro.setEditable(false);
        this.txtErro.setBorder(null);
        this.txtErro.setPreferredSize(new Dimension(100, 60));
        this.buttonEnviar.addActionListener(this);
        this.buttonNaoEnviar.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.txtComentario.grabFocus();
        this.buttonNaoEnviar.setMnemonic('N');
        this.buttonEnviar.setMnemonic('E');
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonEnviar) {
            this.enviaEmail();
            this.buttonEnviar.setEnabled(false);
        }
        this.dispose();
    }

    public static void enviarEmail(String emailDestino, String mensagem, String assunto) {
        ErrorLogger.enviarEmail(emailDestino, mensagem, assunto, true);
    }

    public static void enviarEmail(final String emailDestino, final String mensagem, final String assunto, final boolean isErro) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Properties prop = new Properties();
                    prop.put("mail.tranport.protocol", "smtp");
                    prop.put("mail.host", SMTP);
                    prop.put("mail.smtp.port", PORTA);
                    prop.put("mail.smtp.auth", "true");
                    prop.put("mail.smtp.from", EMAIL);
                    Authenticator autenticador = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(EMAIL, SENHA);
                        }
                    };
                    Session session = Session.getDefaultInstance((Properties)prop, (Authenticator)autenticador);
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(EMAIL));
                    message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailDestino));
                    message.setSentDate(new Date());
                    if (isErro) {
                        message.setSubject(String.valueOf(ParametrosGerais.getCodigoCliente()) + " >> " + ConstantesGerais.NRVERSAO + " >> " + (assunto != null ? assunto : "NULL localizado"));
                    } else {
                        message.setSubject(assunto);
                    }
                    message.setText(mensagem);
                    Transport.send((Message)message);
                }
                catch (MessagingException messagingException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void enviaEmailErro(String mensagem, String assunto) {
        Statement st = Conexao.getStatementTratandoShutdown();
        try {
            ErrorLogger.enviaEmailErro(mensagem, assunto, st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }

    public static void enviaEmailErro(String mensagem, String assunto, Statement st) {
        String razao = Variaveis.descricaoFilialPadrao;
        String cnpj = "";
        String email = "";
        String fone = "";
        String fax = "";
        StringBuilder buf = new StringBuilder("select fil_razaosocial, fil_cnpj, fil_email, fil_fone, fil_fax ");
        buf.append("from filiais_postocoleta where fil_codigo = ");
        buf.append(Funcoes.textoVazio(Variaveis.filialPadrao) ? Integer.valueOf(1) : Variaveis.filialPadrao);
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                razao = rs.getString("fil_razaosocial") + "(" + (Funcoes.textoVazio(Variaveis.descricaoFilialPadrao) ? "" : Variaveis.descricaoFilialPadrao) + ")";
                cnpj = rs.getString("fil_cnpj");
                email = rs.getString("fil_email");
                fone = rs.getString("fil_fone");
                fax = rs.getString("fil_fax");
            }
            rs.close();
        }
        catch (SQLException ex1) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e) {
                ex1.printStackTrace();
            }
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Erro localizado pelo cliente: ");
        msg.append(razao);
        msg.append("\nCNPJ: ");
        msg.append(cnpj);
        msg.append("\nFone: ");
        msg.append(fone);
        msg.append("\nFax: ");
        msg.append(fax);
        msg.append("\ne-mail: ");
        msg.append(email);
        msg.append("\nUsu\u00e1rio: ");
        msg.append(Variaveis.login);
        msg.append("\nEsta\u00e7\u00e3o: ");
        msg.append(Variaveis.codigoEstacao);
        msg.append("\nData: ");
        msg.append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
        msg.append("\nVersao: ");
        msg.append(ConstantesGerais.NRVERSAO);
        msg.append("\nCodigo Thread: ");
        msg.append(ParametrosGerais.getCodigoCliente());
        msg.append("\n=====================================================");
        msg.append("\nSO:").append(System.getProperty("os.name"));
        msg.append("\nJava:").append(System.getProperty("java.version")).append(" (").append(System.getProperty("java.vm.version")).append(")");
        msg.append("\n=====================================================");
        long free = Runtime.getRuntime().freeMemory();
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        msg.append("\nMem. atual:" + (int)((total - free) / 1024L));
        msg.append("\nMem. m\u00e1xima:" + (int)(max / 1024L));
        msg.append("\n=====================================================");
        try {
            msg.append("\nNome do BD: " + st.getConnection().getMetaData().getDatabaseProductName());
            msg.append("\nVers\u00e3o do BD: " + st.getConnection().getMetaData().getDatabaseProductVersion());
            msg.append("\n=====================================================");
            msg.append("\nNome do driver do BD: " + st.getConnection().getMetaData().getDriverName());
            msg.append("\nVers\u00e3o do driver do BD: " + st.getConnection().getMetaData().getDriverVersion());
            msg.append("\n=====================================================\n");
            if (pai != null) {
                Class<?> type = pai.getClass();
                msg.append("\nVari\u00e1veis:");
                for (Field f : type.getDeclaredFields()) {
                    f.setAccessible(true);
                    Object valor = f.get(pai);
                    if (valor instanceof JComponent) continue;
                    msg.append("\nCampo: " + f.getName().toString() + " -> Valor: " + (valor == null ? "null" : "'" + valor.toString() + "'"));
                }
                msg.append("\n=====================================================\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        msg.append(mensagem);
        ErrorLogger.enviarEmail(EMAIL, msg.toString(), assunto);
    }

    private void enviaEmail() {
        if (this.mensagem != null && (ErrorLogger.mensagemDeImpressora(this.mensagem) || this.mensagem.toUpperCase().indexOf("o registro n\u00e3o pode ser exclu\u00eddo, por estar sendo utilizado na tabela".toUpperCase()) >= 0 || this.mensagem.toUpperCase().indexOf("o registro nao pode ser excluido, por estar sendo utilizado na tabela".toUpperCase()) >= 0 || this.mensagem.toUpperCase().indexOf("Operador esperado, verifique a \"Mensagem da Condi\u00e7\u00e3o\"".toUpperCase()) >= 0 || this.mensagem.toUpperCase().indexOf("current transaction is aborted, commands ignored until end of transaction block".toUpperCase()) >= 0)) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("\nTela: ");
        msg.append(this.tela);
        msg.append("\n=====================================================");
        msg.append("\nErro localizado: ");
        msg.append(this.mensagem == null ? "MENSAGEM NULL" : this.mensagem);
        msg.append("\n=====================================================");
        if (this.erro != null) {
            for (StackTraceElement e : this.erro) {
                msg.append("\n" + e.getClassName());
                msg.append("(");
                msg.append(e.getLineNumber());
                msg.append(")");
            }
        }
        msg.append("\n=====================================================");
        msg.append("\nComent\u00e1rio: ");
        msg.append(this.txtComentario.getText() == null ? "Coment\u00e1rio null" : this.txtComentario.getText());
        msg.append("\n=====================================================");
        msg.append("\n\u00daltimo comando executado: ");
        msg.append(Conexao.getUltimoErro());
        ErrorLogger.enviaEmailErro(msg.toString(), this.mensagem);
    }

    public void setErro(StackTraceElement[] erro) {
        this.erro = erro;
        String a = "";
        if (erro != null) {
            for (StackTraceElement e : erro) {
                a = a + e.getClassName();
                a = a + "(";
                a = a + e.getLineNumber();
                a = a + ")\n";
            }
        }
        this.txtComentario.setText(a);
        ScreenUtil.posicionaTextoTopo(this.txtComentario);
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem == null ? "MENSAGEM NULL" : mensagem;
        this.txtErro.setText(mensagem);
        this.txtErro.setWrapStyleWord(true);
        this.txtErro.setLineWrap(true);
        ScreenUtil.posicionaTextoTopo(this.txtErro);
    }

    public void setTela(String tela) {
        this.tela = tela;
    }

    public static void mostraMensagem(Component owner, String mensagem, StackTraceElement[] erro) {
        ErrorLogger.mostraMensagem(owner, mensagem, erro, "");
    }

    public static void mostraMensagem(Component owner, String mensagem, StackTraceElement[] erro, String tela) {
        if (!mostrarMensagemErro) {
            System.out.println(mensagem);
            return;
        }
        pai = owner;
        ErrorLogger.gravarLog(mensagem, erro, tela);
        ErrorLogger error = null;
        if (owner instanceof JPanel) {
            if (((JPanel)owner).getTopLevelAncestor() instanceof Dialog) {
                error = new ErrorLogger((Dialog)((JPanel)owner).getTopLevelAncestor());
            } else if (((JPanel)owner).getTopLevelAncestor() instanceof Frame) {
                error = new ErrorLogger((Frame)((JPanel)owner).getTopLevelAncestor());
            }
        } else {
            error = owner instanceof JFrame ? new ErrorLogger((Frame)owner) : (owner instanceof JDialog ? new ErrorLogger((Dialog)owner) : new ErrorLogger(Laboratorio.getInstancia()));
        }
        if (error != null) {
            error.setTela(tela);
            if (ErrorLogger.mensagemDeImpressora(mensagem)) {
                Funcoes.mensagem(owner, "N\u00e3o foi poss\u00edvel enviar o documento para a impressora.\nPoss\u00edveis solu\u00e7\u00f5es:\n-Verifique a conex\u00e3o da impressora com o computador,\n-Verifique o situa\u00e7\u00e3o da impressora no sistema operacional,\n-Verifique o mapeamento da impressora em caso de impressora de rede,\n-Verifique o nome da impressora selecionada (Configura\u00e7\u00e3o de Esta\u00e7\u00e3o).\n-Verifique se a impressora selecionada n\u00e3o foi exclu\u00edda (Configura\u00e7\u00e3o da impressora).\n-Verifique se h\u00e1 papel na bandeja de impress\u00e3o.\nAp\u00f3s verificar as situa\u00e7\u00f5es tente novamente.\nCaso a situa\u00e7\u00e3o persista entre em contato com o t\u00e9cnico de inform\u00e1tica informando a mensagem:\n" + mensagem, 1);
            } else if (mensagem != null && mensagem.toUpperCase().indexOf("connection reset".toUpperCase()) >= 0) {
                Funcoes.mensagem(owner, "N\u00e3o foi poss\u00edvel conectar ao servidor de integra\u00e7\u00e3o de dados.", 1);
            } else if (mensagem != null && mensagem.toUpperCase().indexOf("socket closed".toUpperCase()) >= 0) {
                Funcoes.mensagem(owner, "N\u00e3o foi poss\u00edvel conectar ao socket de comunica\u00e7\u00e3o.", 1);
            } else if (!Funcoes.textoVazio(mensagem) && (ErrorLogger.mensagemDeErroExclusao(mensagem) || ErrorLogger.mensagemDeErroInclusao(mensagem))) {
                String tabela = "tabela";
                int pos = mensagem.indexOf(tabela) + tabela.length();
                String result = mensagem.substring(pos, mensagem.length());
                String msg = "O registro n\u00e3o pode ser exclu\u00eddo por estar sendo utilizado na tabela";
                if (mensagem.contains("o registro nao pode ser inserido")) {
                    msg = "O registro n\u00e3o pode ser inserido, pois um valor informado n\u00e3o existe na tabela";
                }
                Funcoes.mensagem(owner, msg + result, 1);
            } else {
                if (mensagem != null && mensagem.toLowerCase().indexOf("software caused connection") > -1) {
                    error.setMensagem("Perda de conex\u00e3o ao processar informa\u00e7\u00e3o.");
                } else {
                    error.setMensagem(mensagem);
                }
                error.setErro(erro);
                error.setVisible(true);
            }
        }
    }

    private static boolean mensagemDeImpressora(String mensagem) {
        return mensagem != null && (mensagem.toUpperCase().indexOf("PRINTER IS NOT ACCEPTING JOB") >= 0 || mensagem.toUpperCase().indexOf("O trabalho de impress\u00e3o falhou ao iniciar.".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("Erro ao criar servi\u00e7o de impress\u00e3o.".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("O documento e atributos n\u00e3o s\u00e3o v\u00e1lidos para o trabalho de impress\u00e3o.".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("Print job failed to start".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("PrinterException".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("invalid flavor".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("PrintService is no longer available".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("O servidor RPC".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("invalid name of print".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("nome da impressora".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("A impressora".toUpperCase()) >= 0 && mensagem.toUpperCase().indexOf("n\u00e3o foi encontrada".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("A impressora".toUpperCase()) >= 0 && mensagem.toUpperCase().indexOf("n\u00e3o foi localizada".toUpperCase()) >= 0);
    }

    private static boolean mensagemDeErroExclusao(String mensagem) {
        return mensagem != null && (mensagem.toUpperCase().indexOf("Gravando auto-c\u00f3pia da filial".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("o registro n\u00e3o pode ser exclu\u00eddo, por estar sendo utilizado na tabela".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("o registro nao pode ser excluido, por estar sendo utilizado na tabela".toUpperCase()) >= 0);
    }

    private static boolean mensagemDeErroInclusao(String mensagem) {
        return mensagem != null && (mensagem.toUpperCase().indexOf("Gravando auto-c\u00f3pia da filial".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("o registro n\u00e3o pode ser inserido, pois um valor informado".toUpperCase()) >= 0);
    }

    public static void setMostrarMensagemErro(boolean mostrarMensagemErro) {
        ErrorLogger.mostrarMensagemErro = mostrarMensagemErro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean gravarLog(String mensagem, StackTraceElement[] stack, String tela) {
        String separator = System.getProperty("file.separator");
        String diretorio = System.getProperty("user.home") + System.getProperty("file.separator") + "logs";
        String arquivo = diretorio + separator + "jalis_" + Funcoes.formataData("yyyyMMddkkmmss", Funcoes.getDataHoraServidor()) + ".log";
        File f = new File(diretorio);
        try {
            if (!f.exists()) {
                f.mkdir();
            }
            StringUtil.escreverArquivoTexto(arquivo, ErrorLogger.criarMensagemLog(mensagem, stack, tela));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            f = null;
        }
        return true;
    }

    private static String criarMensagemLog(String mensagem, StackTraceElement[] stack, String tela) {
        if (mensagem != null && (ErrorLogger.mensagemDeImpressora(mensagem) || mensagem.toUpperCase().indexOf("o registro n\u00e3o pode ser exclu\u00eddo, por estar sendo utilizado na tabela".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("o registro nao pode ser excluido, por estar sendo utilizado na tabela".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("Operador esperado, verifique a \"Mensagem da Condi\u00e7\u00e3o\"".toUpperCase()) >= 0 || mensagem.toUpperCase().indexOf("current transaction is aborted, commands ignored until end of transaction block".toUpperCase()) >= 0)) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        msg.append(Funcoes.formataData("dd/MM/yyyy kk:mm:ss", Funcoes.getDataHoraAtual()));
        msg.append("\n=====================================================");
        msg.append("\nUsu\u00e1rio: ").append(Variaveis.login);
        if (!Funcoes.textoVazio(tela)) {
            msg.append("\n=====================================================");
            msg.append("\nTela: ").append(tela);
        }
        msg.append("\n=====================================================");
        msg.append("\nMensagem apresentada: ");
        msg.append(mensagem == null ? "MENSAGEM NULL" : mensagem);
        msg.append("\n=====================================================");
        if (stack != null) {
            for (StackTraceElement e : stack) {
                msg.append("\n" + e.getClassName());
                msg.append("(");
                msg.append(e.getLineNumber());
                msg.append(")");
            }
        }
        msg.append("\n=====================================================");
        msg.append("\n\u00daltimo comando executado: ");
        msg.append(Conexao.getUltimoErro());
        return msg.toString();
    }
}

