/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.logger;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class ErroParada
extends JDialog
implements ActionListener {
    private JButton buttonSalvar = new JButton("Salvar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelImagem = new JLabel(ImagemUtils.carregaImagemJalis("errorlogger.jpg"));
    private JLabel label1 = new JLabel("O sistema foi finalizado incorretamente. ");
    private JLabel label2 = new JLabel("Um log ser\u00e1 gerado para esse evento.");
    private JLabel label3 = new JLabel("Informe o motivo da parada inesperada do sistema");
    private JLabel label4 = new JLabel("para posterior an\u00e1lise e corre\u00e7\u00e3o do mesmo. ");
    private JTextArea txtMotivo = new JTextArea();
    private JScrollPane scrollComentario = new JScrollPane(this.txtMotivo);
    private JPanel panelComentario = new JPanel(new BorderLayout());
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private GridBagConstraints cons = new GridBagConstraints();

    public ErroParada(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ErroParada(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("ErrorLogger");
        this.setLayout(new BorderLayout());
        this.setTitle("Erro");
        this.setResizable(false);
        this.setSize(new Dimension(550, 400));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.cons.gridx = 0;
        this.cons.gridy = 0;
        this.cons.fill = 3;
        this.cons.anchor = 11;
        this.cons.insets = new Insets(5, 3, 0, 5);
        this.cons.gridheight = 7;
        this.labelImagem.setVerticalAlignment(1);
        this.panelCentro.add((Component)this.labelImagem, this.cons);
        this.cons.gridx = 1;
        this.cons.fill = 2;
        this.cons.anchor = 17;
        this.cons.gridheight = 1;
        this.cons.weightx = 1.0;
        this.panelCentro.add((Component)this.label1, this.cons);
        this.cons.gridy = 1;
        this.panelCentro.add((Component)this.label2, this.cons);
        this.cons.gridy = 2;
        this.panelCentro.add((Component)this.label3, this.cons);
        this.cons.gridy = 3;
        this.panelCentro.add((Component)this.label4, this.cons);
        this.cons.gridx = 1;
        this.cons.gridy = 4;
        this.cons.fill = 1;
        this.cons.weighty = 1.0;
        this.cons.gridwidth = 2;
        this.panelComentario.setBorder(new TitledBorder("Motivo"));
        this.panelComentario.add((Component)this.scrollComentario, "Center");
        this.panelCentro.add((Component)this.panelComentario, this.cons);
        this.buttonSalvar.addActionListener(this);
        this.buttonSalvar.setMnemonic('S');
        this.txtMotivo.grabFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSalvar) {
            this.salvar();
        }
    }

    private void salvar() {
        if (Funcoes.textoVazio(this.txtMotivo.getText())) {
            Funcoes.mensagem(this, "Motivo da parada do sistema n\u00e3o informado", 1);
            this.txtMotivo.grabFocus();
            return;
        }
        this.setCursor(new Cursor(3));
        StringBuilder buf = new StringBuilder("insert into erroparada(err_data, err_usuario, err_motivo) values (current_timestamp,'");
        buf.append(Variaveis.login);
        buf.append("', '");
        buf.append(StringUtil.textoDB(this.txtMotivo.getText()));
        buf.append("')");
        Statement st = Conexao.getStatement();
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString(), true);
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ErroParada");
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setCursor(new Cursor(0));
        this.dispose();
    }

    public static void mostraMensagem(Component owner) {
        ErroParada error = null;
        error = owner instanceof JFrame ? new ErroParada((Frame)owner) : (owner instanceof JDialog ? new ErroParada((Dialog)owner) : new ErroParada(Laboratorio.getInstancia()));
        error.setVisible(error != null);
    }
}

