/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.termica;

import jalis.comum.Conexao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Interpretador;
import jalis.util.logger.ErrorLogger;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.swing.table.TableModel;

public class ImpressaoTermica {
    private Interpretador inter = new Interpretador();
    private TableModel tabela;
    private PrintService service;

    public ImpressaoTermica() {
    }

    public ImpressaoTermica(String nomeImpressora, boolean isColetaWeb) {
        this.service = Funcoes.localizarImpressora(nomeImpressora);
        if (!isColetaWeb && this.service == null) {
            ErrorLogger.mostraMensagem(null, "ImpressaoTermica: a impressora " + nomeImpressora + " n\u00e3o foi localizada", null);
        }
    }

    public String gerarEtiquetas(String doc) {
        StringBuilder bui = new StringBuilder();
        if (!this.tabelaIsNull()) {
            String etiqueta = "";
            String sumario = "";
            String cabecalho = "";
            String tmp = StringUtil.getValor(doc, "documento");
            etiqueta = doc;
            if (!this.possuiDocumento(tmp)) {
                etiqueta = StringUtil.getValor(tmp, "etiqueta");
                sumario = StringUtil.getValor(tmp, "sumario");
                cabecalho = StringUtil.getValor(tmp, "cabecalho");
            }
            for (int i = 0; i < this.tabela.getRowCount(); ++i) {
                this.inter.setCampos(this.getCampos(i));
                if (this.possuiCabelho(i, cabecalho)) {
                    bui.append(this.tratarDocumento(cabecalho)).append("\n");
                }
                bui.append(this.tratarDocumento(etiqueta));
                bui.append('\n');
                if (!this.possuiSumario(i, sumario)) continue;
                bui.append(this.tratarDocumento(sumario)).append("\n");
            }
        }
        return bui.toString();
    }

    private boolean possuiSumario(int i, String sumario) {
        return i == this.tabela.getRowCount() - 1 && sumario.trim().length() > 0;
    }

    private boolean possuiDocumento(String tmp) {
        return tmp.length() == 0;
    }

    private boolean tabelaIsNull() {
        return this.tabela == null;
    }

    private boolean possuiCabelho(int i, String cabecalho) {
        return i == 0 && !Funcoes.textoVazio(cabecalho) && cabecalho.trim().length() > 0;
    }

    public void imprimirDireto(String doc) {
        this.imprimirDireto(doc, true, Conexao.getStatement(), false, () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    public byte[] imprimirDireto(String doc, boolean executarLogCopia, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        return ImpressaoTermica.imprimirDireto(this.service, doc, executarLogCopia, st, isColetaWeb, arquivar, anular);
    }

    public static byte[] imprimirDireto(PrintService service, String doc, boolean executarLogCopia) {
        return ImpressaoTermica.imprimirDireto(service, doc, executarLogCopia, Conexao.getStatement(), false, () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    public static byte[] imprimirDireto(PrintService service, String doc, boolean executarLogCopia, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        byte[] bytes = new byte[]{};
        if ((service != null || isColetaWeb) && doc != null) {
            try {
                bytes = StringUtil.removerAcentos(doc).getBytes();
                SimpleDoc docTmp = new SimpleDoc(bytes, DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                if (executarLogCopia) {
                    st.execute("insert into logcopia(log_data, log_filial, log_operacao) values (current_timestamp, 1, '" + StringUtil.textoDB(doc) + "')");
                    arquivar.call();
                }
                if (!isColetaWeb) {
                    service.createPrintJob().print(docTmp, null);
                }
            }
            catch (Exception e) {
                try {
                    anular.call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoTermica: 81");
            }
        }
        return bytes;
    }

    public void imprimir(String doc) {
        this.imprimir(doc, Conexao.getStatement(), false, () -> {
            try {
                Conexao.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                Conexao.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    public byte[] imprimir(String doc, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        return this.imprimirDireto(this.gerarEtiquetas(doc), true, st, isColetaWeb, arquivar, anular);
    }

    public void setDados(TableModel tabela) {
        this.tabela = tabela;
    }

    private String tratarDocumento(String doc) {
        if (doc != null && doc.length() > 0) {
            try {
                StringBuffer buf = new StringBuffer();
                int fromIndex = 0;
                int posAbre = doc.indexOf("[", fromIndex);
                int posFecha = doc.indexOf("]", fromIndex);
                while (posAbre > -1 && posAbre < posFecha) {
                    buf.append(doc.substring(fromIndex, posAbre));
                    buf.append(StringUtil.notNull(this.inter.resolver(doc.substring(posAbre + "[".length(), posFecha))));
                    fromIndex = posFecha + "]".length();
                    posAbre = doc.indexOf("[", fromIndex);
                    posFecha = doc.indexOf("]", fromIndex);
                }
                return buf.append(doc.substring(fromIndex, doc.length())).toString();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), " ImpressaoTermica: 128");
            }
        }
        return "";
    }

    private Object[] getCampos(int linha) {
        ArrayList<Object> campos = new ArrayList<Object>();
        if (linha >= 0 && linha < this.tabela.getRowCount()) {
            for (int i = 0; i < this.tabela.getColumnCount(); ++i) {
                campos.add(this.tabela.getColumnName(i));
                campos.add(this.tabela.getValueAt(linha, i));
            }
        }
        return campos.toArray();
    }
}

