/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.termica;

import jalis.util.expressao.AbstractEstiloDocumento;
import jalis.util.expressao.parser.Lexico;
import jalis.util.expressao.parser.Token;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class EstiloDocumentoTermica
extends AbstractEstiloDocumento {
    private SimpleAttributeSet tag = new SimpleAttributeSet();

    public EstiloDocumentoTermica(JTextComponent text) {
        super(text);
        StyleConstants.setBold(this.tag, true);
        StyleConstants.setForeground(this.tag, Color.blue);
    }

    public boolean escopoExpressao() {
        if (this.textComponent != null) {
            try {
                String tmp = this.getText(0, this.getLength());
                String abre = "[";
                String fecha = "]";
                int caretPos = this.textComponent.getCaretPosition();
                int fromIndex = 0;
                int posAbre = tmp.indexOf(abre);
                int posFecha = tmp.indexOf(fecha);
                while (posAbre > -1 && posAbre < posFecha) {
                    if (caretPos >= posAbre + abre.length() && caretPos <= posFecha) {
                        return true;
                    }
                    fromIndex = posFecha + fecha.length();
                    posAbre = tmp.indexOf(abre, fromIndex);
                    posFecha = tmp.indexOf(fecha, fromIndex);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EstiloDocumentoTermica: 50");
            }
        }
        return false;
    }

    public Object[] getExpressoes() {
        ArrayList<Object> exp = new ArrayList<Object>();
        try {
            String doc = this.getText(0, this.getLength());
            String tagAbre = "[";
            String tagFecha = "]";
            int fromIndex = 0;
            int abre = doc.indexOf(tagAbre, fromIndex);
            int fecha = doc.indexOf(tagFecha, fromIndex);
            while (abre > -1 && abre < fecha) {
                exp.add(new Integer(abre + tagAbre.length()));
                exp.add(doc.substring(abre + tagAbre.length(), fecha));
                fromIndex = fecha + tagFecha.length();
                abre = doc.indexOf(tagAbre, fromIndex);
                fecha = doc.indexOf(tagFecha, fromIndex);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EstiloDocumentoTermica: 80");
        }
        return exp.toArray();
    }

    @Override
    public void destacarTokens() throws BadLocationException {
        String doc = this.getText(0, this.getLength());
        this.setParagraphAttributes(0, doc.length(), this.simples, true);
        String tagAbre = "[";
        String tagFecha = "]";
        int fromIndex = 0;
        int abre = doc.indexOf(tagAbre, fromIndex);
        int fecha = doc.indexOf(tagFecha, fromIndex);
        while (abre > -1 && abre < fecha) {
            this.setCharacterAttributes(abre, tagAbre.length(), this.tag, true);
            this.setCharacterAttributes(fecha, tagFecha.length(), this.tag, true);
            this.destacarExpressao(doc.substring(abre + tagAbre.length(), fecha), abre + tagAbre.length());
            fromIndex = fecha + tagFecha.length();
            abre = doc.indexOf(tagAbre, fromIndex);
            fecha = doc.indexOf(tagFecha, fromIndex);
        }
    }

    private void destacarExpressao(String exp, int posIni) throws BadLocationException {
        Lexico lex = new Lexico(exp, 8);
        Token tok = lex.getProxToken();
        while (tok.id != 34 && !tok.erro) {
            this.setCharacterAttributes(posIni + tok.pos, tok.lexema.length(), this.estilo(tok), true);
            tok = lex.getProxToken();
        }
    }
}

