/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.termica;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.DialogoLista;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.expressao.DialogoFuncao;
import jalis.util.expressao.DialogoFuncaoFactory;
import jalis.util.expressao.parser.ExpressaoException;
import jalis.util.expressao.parser.Sintatico;
import jalis.util.impressao.termica.EstiloDocumentoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class EditorTermica
extends JDialog
implements ActionListener,
DisposeListener,
CaretListener {
    public static final String SUMARIO = "sumario";
    public static final String ETIQUETA = "etiqueta";
    public static final String CABECALHO = "cabecalho";
    public static final String DOCUMENTO = "documento";
    JTextPane textCabecalho = ComponenteFactory.novoJTextPane();
    JTextPane textEtiqueta = ComponenteFactory.novoJTextPane();
    JTextPane textSumario = ComponenteFactory.novoJTextPane();
    JPanel panelFuncoes = ComponenteFactory.novoJPanel(new FlowLayout(0, 3, 3), new Dimension(105, 10), null);
    EstiloDocumentoTermica docCabecalho = new EstiloDocumentoTermica(this.textCabecalho);
    EstiloDocumentoTermica docEtiqueta = new EstiloDocumentoTermica(this.textEtiqueta);
    EstiloDocumentoTermica docSumario = new EstiloDocumentoTermica(this.textSumario);
    JLabel labelErro = new JLabel();
    Dimension dim = new Dimension(100, 25);
    JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    JButton buttonExpressao = ComponenteFactory.novoJButton("Express\u00e3o", '\u0000', this, null, this.dim, true, 2);
    JButton buttonBanco = ComponenteFactory.novoJButton("Banco", '\u0000', this, null, this.dim, true, 2);
    JButton buttonSe = ComponenteFactory.novoJButton("Se", '\u0000', this, null, this.dim, true, 2);
    JButton buttonCopia = ComponenteFactory.novoJButton("C\u00f3pia", '\u0000', this, null, this.dim, true, 2);
    JButton buttonVazio = ComponenteFactory.novoJButton("Vazio", '\u0000', this, null, this.dim, true, 2);
    JButton buttonZero = ComponenteFactory.novoJButton("Zero", '\u0000', this, null, this.dim, true, 2);
    JButton buttonExtenso = ComponenteFactory.novoJButton("Extenso", '\u0000', this, null, this.dim, true, 2);
    JButton buttonTamanho = ComponenteFactory.novoJButton("Tamanho", '\u0000', this, null, this.dim, true, 2);
    JButton buttonNumero = ComponenteFactory.novoJButton("N\u00famero", '\u0000', this, null, this.dim, true, 2);
    JButton buttonData = ComponenteFactory.novoJButton("Data", '\u0000', this, null, this.dim, true, 2);
    JButton buttonCaracter = ComponenteFactory.novoJButton("Caracter", '\u0000', this, null, this.dim, true, 2);
    JButton buttonContem = ComponenteFactory.novoJButton("Cont\u00e9m", '\u0000', this, null, this.dim, true, 2);
    private boolean ok = false;
    private String[] campos = new String[0];
    JTextPane textFocalizado = null;

    public static EditorTermica novaInstancia(Object pai, String titulo, boolean modal, boolean isCabecalho) {
        if (pai instanceof Frame) {
            return new EditorTermica((Frame)pai, titulo, modal, isCabecalho);
        }
        if (pai instanceof Dialog) {
            return new EditorTermica((Dialog)pai, titulo, modal, isCabecalho);
        }
        return null;
    }

    public EditorTermica(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar();
    }

    public EditorTermica(Frame pai, String titulo, boolean modal, boolean isCabecalho) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        if (isCabecalho) {
            this.iniciarCabecalho();
        } else {
            this.iniciar();
        }
    }

    public EditorTermica(Dialog pai, String titulo, boolean modal, boolean isCabecalho) {
        super(pai, titulo, modal);
        this.iniciar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOk;
            if (!this.ok || this.validarExpressoes()) {
                this.dispose();
            }
        } else if (o == this.buttonExpressao) {
            try {
                int pos = this.textFocalizado.getCaretPosition();
                if (this.textFocalizado == this.textEtiqueta) {
                    this.docEtiqueta.insertString(pos, "[]", null);
                } else if (this.textFocalizado == this.textSumario) {
                    this.docSumario.insertString(pos, "[]", null);
                } else {
                    this.docCabecalho.insertString(pos, "[]", null);
                }
                this.textFocalizado.setCaretPosition(pos + "[".length());
                this.textFocalizado.requestFocus();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EditorTermica: 105");
            }
        } else if (o == this.buttonBanco) {
            DialogoLista dl = DialogoLista.novaInstancia(this, "Campos do Banco");
            dl.setItens(this.campos);
            dl.setVisible(true);
            if (dl.ok()) {
                this.inserirTexto(dl.getItemSelecionado());
                this.textFocalizado.requestFocus();
            }
        } else {
            DialogoFuncao dialogo = this.getDialogo(o);
            if (dialogo != null) {
                dialogo.setCamposBanco(this.campos);
                dialogo.setVisible(true);
                if (dialogo.ok()) {
                    this.inserirTexto(dialogo.getExpressao());
                }
            }
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public void setCamposBanco(String[] campos) {
        if (campos != null) {
            StringUtil.ordenar(campos);
            this.campos = campos;
        }
    }

    public String getDocumento() {
        XMLStringBuilder xml = new XMLStringBuilder();
        if (!(Funcoes.textoVazio(this.textCabecalho.getText()) && Funcoes.textoVazio(this.textEtiqueta.getText()) && Funcoes.textoVazio(this.textSumario.getText()))) {
            xml.abrir(DOCUMENTO);
            xml.escrever(CABECALHO, this.textCabecalho.getText());
            xml.escrever(ETIQUETA, this.textEtiqueta.getText());
            xml.escrever(SUMARIO, this.textSumario.getText());
            try {
                xml.fechar(DOCUMENTO);
            }
            catch (XMLStringBuilderException e) {
                e.printStackTrace();
            }
        }
        return xml.getXML();
    }

    public void setDocumento(String documento) {
        String tmp;
        String string = tmp = documento == null ? "" : StringUtil.getValor(documento, DOCUMENTO);
        if (tmp.length() == 0) {
            this.textEtiqueta.setText(documento);
        } else {
            this.textCabecalho.setText(StringUtil.getValor(tmp, CABECALHO));
            this.textEtiqueta.setText(StringUtil.getValor(tmp, ETIQUETA));
            this.textSumario.setText(StringUtil.getValor(tmp, SUMARIO));
        }
    }

    private void iniciar() {
        this.setTitle("Impress\u00e3o t\u00e9rmica");
        this.setSize(new Dimension(600, 350));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        panelAux.add((Component)panel, "East");
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        panel.add((Component)this.panelFuncoes, "East");
        this.panelFuncoes.add(this.buttonExpressao);
        this.panelFuncoes.add(this.buttonBanco);
        this.panelFuncoes.add(this.buttonSe);
        this.panelFuncoes.add(this.buttonCopia);
        this.panelFuncoes.add(this.buttonVazio);
        this.panelFuncoes.add(this.buttonZero);
        this.panelFuncoes.add(this.buttonExtenso);
        this.panelFuncoes.add(this.buttonTamanho);
        this.panelFuncoes.add(this.buttonNumero);
        this.panelFuncoes.add(this.buttonData);
        this.panelFuncoes.add(this.buttonCaracter);
        this.panelFuncoes.add(this.buttonContem);
        JPanel jPanel = panel;
        panel = new JPanel(new GridBagLayout());
        jPanel.add((Component)panel, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Cabe\u00e7alho"));
        panel.add((Component)panelAux, cons);
        JScrollPane scroll = new JScrollPane(this.textCabecalho);
        panelAux.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(450, 100));
        cons.gridy = 1;
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Etiqueta"));
        panel.add((Component)panelAux, cons);
        scroll = new JScrollPane(this.textEtiqueta);
        panelAux.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(450, 200));
        panelAux.add((Component)this.labelErro, "South");
        cons.gridy = 2;
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Sum\u00e1rio"));
        panel.add((Component)panelAux, cons);
        scroll = new JScrollPane(this.textSumario);
        panelAux.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(450, 150));
        this.textEtiqueta.setFont(new Font("Monospaced", 0, 12));
        this.textEtiqueta.setStyledDocument(this.docEtiqueta);
        this.textEtiqueta.addCaretListener(this);
        this.textSumario.setFont(this.textEtiqueta.getFont());
        this.textSumario.addCaretListener(this);
        this.textSumario.setStyledDocument(this.docSumario);
        this.textCabecalho.setFont(this.textEtiqueta.getFont());
        this.textCabecalho.addCaretListener(this);
        this.textCabecalho.setStyledDocument(this.docCabecalho);
        this.labelErro.setPreferredSize(new Dimension(10, 20));
        this.labelErro.setForeground(Color.red);
        this.labelErro.setFont(new Font(this.labelErro.getFont().getName(), 0, 12));
        this.textEtiqueta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTermica.this.textFocalizado = EditorTermica.this.textEtiqueta;
            }
        });
        this.textSumario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTermica.this.textFocalizado = EditorTermica.this.textSumario;
            }
        });
        this.textCabecalho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTermica.this.textFocalizado = EditorTermica.this.textCabecalho;
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textEtiqueta);
    }

    private void iniciarCabecalho() {
        this.setTitle("Cabe\u00e7alho - Impress\u00e3o t\u00e9rmica");
        this.setSize(new Dimension(600, 350));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        panelAux.add((Component)panel, "East");
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        JPanel jPanel = panel;
        panel = new JPanel(new GridBagLayout());
        jPanel.add((Component)panel, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Cabe\u00e7alho"));
        panel.add((Component)panelAux, cons);
        JScrollPane scroll = new JScrollPane(this.textCabecalho);
        panelAux.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(450, 100));
        this.textCabecalho.setFont(new Font("Monospaced", 0, 12));
        this.textCabecalho.addCaretListener(this);
        this.textCabecalho.setStyledDocument(this.docCabecalho);
        this.labelErro.setPreferredSize(new Dimension(10, 20));
        this.labelErro.setForeground(Color.red);
        this.labelErro.setFont(new Font(this.labelErro.getFont().getName(), 0, 12));
        this.textCabecalho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTermica.this.textFocalizado = EditorTermica.this.textCabecalho;
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCabecalho);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        Object o = e.getSource();
        boolean escopo = false;
        if (o == this.textEtiqueta) {
            escopo = this.docEtiqueta.escopoExpressao();
            this.buttonExpressao.setVisible(!escopo);
            this.panelFuncoes.setVisible(true);
        } else if (o == this.textSumario) {
            escopo = this.docSumario.escopoExpressao();
            this.buttonExpressao.setVisible(!escopo);
            this.panelFuncoes.setVisible(true);
        } else if (o == this.textCabecalho) {
            escopo = this.docCabecalho.escopoExpressao();
            this.buttonExpressao.setVisible(!escopo);
            this.panelFuncoes.setVisible(true);
        }
        this.buttonBanco.setVisible(escopo);
        this.buttonSe.setVisible(escopo);
        this.buttonCopia.setVisible(escopo);
        this.buttonVazio.setVisible(escopo);
        this.buttonZero.setVisible(escopo);
        this.buttonExtenso.setVisible(escopo);
        this.buttonTamanho.setVisible(escopo);
        this.buttonNumero.setVisible(escopo);
        this.buttonData.setVisible(escopo);
        this.buttonCaracter.setVisible(escopo);
        this.buttonContem.setVisible(escopo);
    }

    private void inserirTexto(String texto) {
        if (texto != null && texto.length() > 0) {
            try {
                if (this.textFocalizado == this.textEtiqueta) {
                    this.docEtiqueta.insertString(this.textEtiqueta.getCaretPosition(), texto, null);
                } else if (this.textFocalizado == this.textSumario) {
                    this.docSumario.insertString(this.textSumario.getCaretPosition(), texto, null);
                } else if (this.textFocalizado == this.textCabecalho) {
                    this.docCabecalho.insertString(this.textCabecalho.getCaretPosition(), texto, null);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditorTermica: 267");
            }
        }
    }

    private DialogoFuncao getDialogo(Object botao) {
        if (botao == this.buttonSe) {
            return DialogoFuncaoFactory.criarDialogoFuncao(0, this);
        }
        if (botao == this.buttonCopia) {
            return DialogoFuncaoFactory.criarDialogoFuncao(1, this);
        }
        if (botao == this.buttonVazio) {
            return DialogoFuncaoFactory.criarDialogoFuncao(2, this);
        }
        if (botao == this.buttonZero) {
            return DialogoFuncaoFactory.criarDialogoFuncao(3, this);
        }
        if (botao == this.buttonExtenso) {
            return DialogoFuncaoFactory.criarDialogoFuncao(4, this);
        }
        if (botao == this.buttonTamanho) {
            return DialogoFuncaoFactory.criarDialogoFuncao(5, this);
        }
        if (botao == this.buttonNumero) {
            return DialogoFuncaoFactory.criarDialogoFuncao(6, this);
        }
        if (botao == this.buttonData) {
            return DialogoFuncaoFactory.criarDialogoFuncao(7, this);
        }
        if (botao == this.buttonCaracter) {
            return DialogoFuncaoFactory.criarDialogoFuncao(12, this);
        }
        if (botao == this.buttonContem) {
            return DialogoFuncaoFactory.criarDialogoFuncao(11, this);
        }
        return null;
    }

    private boolean validarExpressoes() {
        Object[] exp = this.docEtiqueta.getExpressoes();
        Sintatico sin = new Sintatico();
        for (int i = 0; i <= exp.length - 2; i += 2) {
            int off = (Integer)exp[i];
            try {
                sin.analisar((String)exp[i + 1]);
                continue;
            }
            catch (ExpressaoException e) {
                this.docEtiqueta.destacarErro(off + e.pos);
                this.labelErro.setText(" Erro: " + e.getMessage());
                return false;
            }
        }
        return true;
    }
}

