/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial.remover;

import jalis.util.impressao.matricial.remover.ImpressaoMatricial;
import jalis.util.impressao.matricial.remover.Pagina;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Visualizar
extends JFrame {
    private int paginaAtual = 1;
    private int qtdePaginas = 0;
    private boolean pulaPagina = true;
    private String porta = "/dev/lp0";
    private int linhas = 66;
    private int colunas = 80;
    private ArrayList linhasOriginais;
    private JPanel panelTopo = new JPanel(new FlowLayout());
    private JButton bFechar = new JButton("Fechar");
    private JButton bProximo = new JButton("Pr\u00f3ximo");
    private JButton bAnterior = new JButton("Anterior");
    private JButton bImprimir = new JButton("Imprimir");
    private JPanel centro = new JPanel(new BorderLayout());
    private JPanel p1 = new JPanel();
    private JPanel p2 = new JPanel();
    private JPanel p3 = new JPanel();
    private JPanel p4 = new JPanel();
    private Pagina pagina;
    private JScrollPane scroll = new JScrollPane(this.centro);

    public Visualizar(ArrayList linhas, ArrayList linhasOriginais) {
        this.linhasOriginais = linhasOriginais;
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.pagina = new Pagina(linhas);
        this.qtdePaginas = linhas.size();
        c.add((Component)this.scroll, "Center");
        this.p1.setPreferredSize(new Dimension(20, 20));
        this.p2.setPreferredSize(new Dimension(20, 20));
        this.p3.setPreferredSize(new Dimension(20, 20));
        this.p4.setPreferredSize(new Dimension(20, 20));
        this.centro.add((Component)this.p1, "North");
        this.centro.add((Component)this.p2, "South");
        this.centro.add((Component)this.p3, "West");
        this.centro.add((Component)this.p4, "East");
        this.centro.add((Component)this.pagina, "Center");
        this.pagina.setPreferredSize(new Dimension(300, 450));
        this.pagina.setMaximumSize(new Dimension(300, 450));
        this.pagina.setMinimumSize(new Dimension(300, 450));
        c.add((Component)this.panelTopo, "North");
        this.setSize(new Dimension(400, 400));
        this.panelTopo.add(this.bImprimir);
        this.panelTopo.add(this.bProximo);
        this.panelTopo.add(this.bAnterior);
        this.panelTopo.add(this.bFechar);
        this.bProximo.setEnabled(this.paginaAtual <= this.qtdePaginas);
        this.bAnterior.setEnabled(this.paginaAtual > 1);
        this.bFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Visualizar.this.setVisible(false);
            }
        });
        this.bProximo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Visualizar.this.paginaAtual + 1 <= Visualizar.this.qtdePaginas) {
                    Visualizar.this.paginaAtual++;
                }
                Visualizar.this.bProximo.setEnabled(Visualizar.this.paginaAtual < Visualizar.this.qtdePaginas);
                Visualizar.this.bAnterior.setEnabled(Visualizar.this.paginaAtual > 1);
                if (Visualizar.this.paginaAtual <= Visualizar.this.qtdePaginas) {
                    Visualizar.this.pagina.setPaginaAtual(Visualizar.this.paginaAtual);
                }
            }
        });
        this.bAnterior.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Visualizar.this.paginaAtual - 1 > 0) {
                    Visualizar.this.paginaAtual--;
                }
                Visualizar.this.bProximo.setEnabled(Visualizar.this.paginaAtual < Visualizar.this.qtdePaginas);
                Visualizar.this.bAnterior.setEnabled(Visualizar.this.paginaAtual > 1);
                if (Visualizar.this.paginaAtual > 0) {
                    Visualizar.this.pagina.setPaginaAtual(Visualizar.this.paginaAtual);
                }
            }
        });
        this.bImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList l = Visualizar.this.getLinhasOriginais();
                ImpressaoMatricial imp = new ImpressaoMatricial();
                imp.setVisualizar(true);
                imp.setQtdeLinhas(Visualizar.this.getQtdeLinhas());
                imp.setQtdeColunas(Visualizar.this.getQtdeColunas());
                imp.setEjetaUltimaPagina(Visualizar.this.pulaPagina);
                try {
                    imp.iniciaImpressao(Visualizar.this.porta);
                    for (int i = 0; i < l.size(); ++i) {
                        imp.imprime((String)l.get(i), true);
                    }
                    imp.finalizaImpressao();
                }
                catch (FileNotFoundException fex) {
                    ErrorLogger.mostraMensagem(null, fex.getMessage(), fex.getStackTrace());
                }
            }
        });
    }

    public ArrayList getLinhasOriginais() {
        return this.linhasOriginais;
    }

    public int getQtdeLinhas() {
        return this.linhas;
    }

    public int getQtdeColunas() {
        return this.colunas;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public void setSaltaUltima(boolean salta) {
        this.pulaPagina = salta;
    }

    public void setLinhas(int linhas) {
        this.linhas = linhas;
    }

    public void setColunas(int colunas) {
        this.colunas = colunas;
    }
}

