/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial.remover;

import jalis.util.impressao.matricial.remover.DadosVisualizar;
import jalis.util.impressao.matricial.remover.Visualizar;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class ImpressaoMatricial {
    private FileOutputStream os;
    private PrintStream ps;
    private String linhaTemp = "";
    private int qtdeLinhas = 66;
    private int qtdeColunas = 80;
    private String porta = "/dev/lp0";
    private boolean ejetar = true;
    private int qtdePaginas = 1;
    private int qtdeLinhasAtual = 0;
    private ArrayList linhas = new ArrayList();
    private boolean visualizar = false;
    private ArrayList paginaPreview = new ArrayList();

    public ImpressaoMatricial() {
    }

    public ImpressaoMatricial(int qtdeLinhas, int qtdeColunas, String porta) {
        this.qtdeLinhas = qtdeLinhas;
        this.qtdeColunas = qtdeColunas;
        this.porta = porta;
    }

    public void setQtdeLinhas(int qtde) {
        this.qtdeLinhas = qtde;
    }

    public void setQtdeColunas(int qtde) {
        this.qtdeColunas = qtde;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public void setVisualizar(boolean visualizar) {
        this.visualizar = visualizar;
    }

    public void iniciaImpressao() throws FileNotFoundException {
        this.linhas.clear();
        this.paginaPreview.clear();
        this.paginaPreview.add(new ArrayList());
        this.os = new FileOutputStream(this.porta);
        this.ps = new PrintStream(this.os);
    }

    public void iniciaImpressao(String porta) throws FileNotFoundException {
        this.porta = porta;
        this.iniciaImpressao();
    }

    public void finalizaImpressao() {
        if (this.visualizar) {
            Visualizar v = new Visualizar(this.paginaPreview, this.linhas);
            v.setSaltaUltima(this.ejetar);
            v.setPorta(this.porta);
            v.setLinhas(this.qtdeLinhas);
            v.setColunas(this.qtdeColunas);
            v.setVisible(true);
        } else if (this.ejetar) {
            this.linhas.add("\f");
            this.ps.println("\f");
        }
        this.ps.close();
    }

    public void imprime(String texto) {
        this.imprime(texto, false);
    }

    public void imprime(String texto, boolean saltaLinha) {
        this.imprime(texto, saltaLinha, 0);
    }

    public void imprime(String texto, boolean saltaLinha, int coluna) {
        this.linhaTemp = this.linhaTemp + this.repete(" ", coluna - this.linhaTemp.length()) + texto;
        if (saltaLinha) {
            this.ps.println(this.linhaTemp);
            this.linhas.add(this.linhaTemp + "\n");
            ((ArrayList)this.paginaPreview.get(this.qtdePaginas - 1)).add(new DadosVisualizar(this.linhaTemp, 0));
            ++this.qtdeLinhasAtual;
            this.linhaTemp = "";
        }
        if (this.qtdeLinhasAtual == this.qtdeLinhas) {
            this.ejetar();
        }
    }

    public void ejetar() {
        this.qtdeLinhasAtual = 0;
        ++this.qtdePaginas;
        this.paginaPreview.add(new ArrayList());
        this.ps.print("\f");
    }

    public void setEjetaUltimaPagina(boolean ejetar) {
        this.ejetar = ejetar;
    }

    public void aplicarEfeito(int efeito) {
        this.linhas.add(String.valueOf(efeito));
    }

    public String repete(String texto, int qtde) {
        String retorno = texto;
        if (texto.length() < qtde) {
            while (retorno.length() < qtde) {
                retorno = retorno + texto;
            }
        }
        return retorno;
    }

    public int getQtdeColunas() {
        return this.qtdeColunas;
    }

    public int getQtdeLinhas() {
        return this.qtdeLinhas;
    }

    public int getLinhaAtual() {
        return this.qtdeLinhasAtual;
    }

    public int getPaginaAtual() {
        return this.qtdePaginas;
    }
}

