/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.util.impressao.matricial.CharImpressao;
import jalis.util.impressao.matricial.Constantes;
import java.util.ArrayList;
import java.util.Iterator;

public class Util {
    public static String fixaComprimento(String str, int comp) {
        StringBuilder buf = new StringBuilder();
        if (str.length() > comp) {
            buf.append(str.substring(0, comp));
        } else {
            buf.append(str);
            for (int i = 0; i < comp - str.length(); ++i) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static String gerarBarras(String valor) {
        if (valor != null && valor.matches("\\-?\\d+")) {
            StringBuilder codigos = new StringBuilder("0000");
            ArrayList<String> arr = new ArrayList<String>();
            if (valor.length() % 2 != 0) {
                arr.add(Constantes.CODIGOS[0]);
            }
            for (int i = 0; i < valor.length(); ++i) {
                arr.add(Constantes.CODIGOS[valor.charAt(i) - 48]);
            }
            String[] nuns = arr.toArray(new String[arr.size()]);
            for (int i = 0; i < arr.size() - 1; i += 2) {
                for (int j = 0; j < nuns[i].length(); ++j) {
                    codigos.append(nuns[i].charAt(j));
                    codigos.append(nuns[i + 1].charAt(j));
                }
            }
            codigos.append("100");
            StringBuilder barras = new StringBuilder();
            for (int i = 0; i < codigos.length(); ++i) {
                barras.append(Constantes.BARRAS[(i % 2 == 0 ? 2 : 0) + codigos.charAt(i) - 48]);
            }
            String tmp = Util.tratarBarrasByte(barras.toString());
            barras.delete(0, barras.length());
            barras.append("\u0001\u0002\u0003");
            barras.append(tmp);
            barras.append("\u0001\u0002\u0004");
            return barras.toString();
        }
        return "";
    }

    public static String tratarBarrasByte(String barras) {
        StringBuilder bui = new StringBuilder();
        if (barras.length() < 128) {
            bui.append(CharImpressao.getCaractereGrafico(barras.length()));
            bui.append(barras);
        } else {
            int pos = 0;
            int tam = 127;
            while (pos < barras.length()) {
                bui.append(CharImpressao.getCaractereGrafico(tam));
                bui.append(barras.substring(pos, pos + tam));
                tam = Math.min(barras.length() - (pos += tam), 127);
            }
        }
        return bui.toString();
    }

    public static String formatar(String str) {
        int q0 = 0;
        int q1 = 1;
        int q2 = 2;
        int estado = q0;
        boolean onOff = true;
        StringBuilder buf = new StringBuilder();
        StringBuilder lex = new StringBuilder();
        ArrayList<String> arr = new ArrayList<String>();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\n') {
                Iterator itr = arr.iterator();
                while (itr.hasNext()) {
                    buf.append(CharImpressao.getCaractere((String)itr.next(), false));
                }
                buf.append('\n');
                itr = arr.iterator();
                while (itr.hasNext()) {
                    buf.append(CharImpressao.getCaractere((String)itr.next(), true));
                }
                continue;
            }
            if (estado == q0) {
                if (str.charAt(i) == '\\') {
                    estado = q1;
                    continue;
                }
                if (str.charAt(i) == '<') {
                    estado = q2;
                    onOff = true;
                    lex.delete(0, lex.length());
                    continue;
                }
                buf.append(str.charAt(i));
                continue;
            }
            if (estado == q1) {
                buf.append(str.charAt(i));
                estado = q0;
                continue;
            }
            if (estado != q2) continue;
            if (str.charAt(i) == '/') {
                onOff = false;
                lex.delete(0, lex.length());
                continue;
            }
            if (str.charAt(i) == '>') {
                buf.append(CharImpressao.getCaractere(lex.toString(), onOff));
                estado = q0;
                if (onOff) {
                    arr.add(lex.toString());
                    continue;
                }
                arr.remove(lex.toString());
                continue;
            }
            lex.append(str.charAt(i));
        }
        return buf.toString();
    }

    public static String removerTagsAbreFecha(String str) {
        if (str != null) {
            str = str.replaceAll("\u0001\u0002\u0003", "");
            str = str.replaceAll("\u0001\u0002\u0004", "");
        }
        return str;
    }

    public static String trataCodigoBarras(String str) {
        StringBuilder bui = new StringBuilder();
        if (str != null) {
            int fromIndex = 0;
            int abre = str.indexOf("\u0001\u0002\u0003");
            int fecha = str.indexOf("\u0001\u0002\u0004");
            while (abre > -1 && abre < fecha) {
                bui.append(CharImpressao.trocaTextoPorEspaco(str.substring(fromIndex, abre)));
                bui.append(str.substring(abre + "\u0001\u0002\u0003".length(), fecha));
                fromIndex = fecha + "\u0001\u0002\u0004".length();
                abre = str.indexOf("\u0001\u0002\u0003", fromIndex);
                fecha = str.indexOf("\u0001\u0002\u0004", fromIndex);
                if (abre >= 0 || fromIndex > str.length()) continue;
                bui.append(CharImpressao.trocaTextoPorEspaco(str.substring(fromIndex, str.length())));
            }
        }
        return bui.length() == 0 ? null : bui.toString();
    }

    public static boolean contemBarras(String str) {
        if (str != null) {
            int abre = str.indexOf("\u0001\u0002\u0003");
            int fecha = str.indexOf("\u0001\u0002\u0004");
            return abre > -1 && abre < fecha;
        }
        return false;
    }
}

