/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Interpretador;
import jalis.util.impressao.matricial.Util;
import jalis.util.logger.ErrorLogger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class Relatorio {
    private String[] cabecalho = new String[0];
    private String[] rodape = new String[0];
    private String xmlDetalhe = "";
    private int linhas;
    private int colunas;
    private boolean cupom = false;
    private ArrayList<String[]> itens = new ArrayList();

    public void setCabecalhoRodape(String xml, TableModel tabela) {
        Object[] dados = this.getCampos(tabela);
        String tmp = StringUtil.getValor(xml, "cabecalhoRodape");
        this.linhas = StringUtil.getInt(tmp, "linhas");
        this.colunas = StringUtil.getInt(tmp, "colunas");
        this.cupom = StringUtil.getBoolean(tmp, "cupom");
        this.cabecalho = this.resolverExpressoes(StringUtil.getValor(tmp, "cabecalho"), dados);
        this.rodape = this.resolverExpressoes(StringUtil.getValor(tmp, "rodape"), dados);
        this.xmlDetalhe = StringUtil.getValor(tmp, "detalhe");
    }

    public void addItem(TableModel tabela) {
        this.itens.add(this.resolverExpressoes(this.xmlDetalhe, this.getCampos(tabela)));
    }

    public void addItem(HashMap<String, Object> dados) {
        this.itens.add(this.resolverExpressoes(this.xmlDetalhe, this.getCampos(dados)));
    }

    String[][] getItens() {
        return (String[][])this.itens.toArray((T[])new String[this.itens.size()][]);
    }

    int getQuantidadeLinhas() {
        return this.linhas;
    }

    int getQuantidadeColunas() {
        return this.colunas;
    }

    public boolean isCupom() {
        return this.cupom;
    }

    String[] getCabecalho() {
        return this.cabecalho;
    }

    String[] getRodape() {
        return this.rodape;
    }

    String[] resolverExpressoes(String str, Object[] campos) {
        Estados estado = Estados.q0;
        boolean ordemRstAnterior = true;
        StringBuilder buf = new StringBuilder();
        StringBuilder num = new StringBuilder();
        StringBuilder exp = new StringBuilder();
        Interpretador inter = new Interpretador();
        inter.setCampos(campos);
        try {
            if (str != null) {
                block8: for (int i = 0; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    switch (estado) {
                        case q0: {
                            if (ch == '[') {
                                estado = Estados.q1;
                                continue block8;
                            }
                            if (ch == '{') {
                                estado = Estados.q3;
                                continue block8;
                            }
                            if (ch == '\n') {
                                ordemRstAnterior = true;
                            }
                            buf.append(ch);
                            continue block8;
                        }
                        case q1: {
                            if (ch == '!') {
                                estado = Estados.q2;
                                continue block8;
                            }
                            num.append(ch);
                            continue block8;
                        }
                        case q2: {
                            if (ch == ']') {
                                String tmp = Util.formatar(StringUtil.notNull(inter.resolver(exp.toString())));
                                buf.append(Util.fixaComprimento(tmp, Integer.parseInt(num.toString())));
                                exp.delete(0, exp.length());
                                num.delete(0, num.length());
                                estado = Estados.q0;
                                continue block8;
                            }
                            exp.append(ch);
                            continue block8;
                        }
                        case q3: {
                            if (ch == '}') {
                                buf.append(Util.gerarBarras(StringUtil.notNull(inter.resolver(exp.toString()))));
                                num.delete(0, num.length());
                                exp.delete(0, exp.length());
                                estado = Estados.q0;
                                continue block8;
                            }
                            exp.append(ch);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Relatorio: 172");
        }
        return StringUtil.separarLinhas(Util.formatar(buf.toString()));
    }

    private Object[] getCampos(TableModel tabela) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (tabela.getRowCount() > 0) {
            for (int i = 0; i < tabela.getColumnCount(); ++i) {
                tmp.add(tabela.getColumnName(i));
                tmp.add(tabela.getValueAt(0, i));
            }
        }
        return tmp.toArray();
    }

    private Object[] getCampos(HashMap<String, Object> dados) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (String k : dados.keySet()) {
            tmp.add(k);
            tmp.add(dados.get(k));
        }
        return tmp.toArray();
    }

    public static boolean vazio(String xml) {
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "cabecalhoRodape"))) {
            String cabecalho = StringUtil.getValor(xml, "cabecalho");
            String rodape = StringUtil.getValor(xml, "rodape");
            String detalhe = StringUtil.getValor(xml, "detalhe");
            return Funcoes.textoVazio(cabecalho) || Funcoes.textoVazio(rodape) || Funcoes.textoVazio(detalhe);
        }
        return true;
    }

    static enum Estados {
        q0,
        q1,
        q2,
        q3;

    }
}

