/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.comum.ParametrosLocais;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Interpretador;
import jalis.util.impressao.matricial.CharImpressao;
import jalis.util.impressao.matricial.Mapa;
import jalis.util.impressao.matricial.Util;
import jalis.util.logger.ErrorLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class MapaResolverExpressoesUtil {
    private MapaResolverExpressoesUtil() {
    }

    public static String[] resolverExpressoes(String str, Object[] campos, Map<Integer, String> resAnteriores, Map<String, Object> externos, boolean fixaComprimento) {
        Mapa.Estados estado = Mapa.Estados.q0;
        int ordemRstAnterior = 1;
        StringBuilder buf = new StringBuilder();
        StringBuilder num = new StringBuilder();
        StringBuilder exp = new StringBuilder();
        Interpretador inter = new Interpretador();
        inter.setCampos(campos);
        HashMap<String, Object> dadosExternos = new HashMap<String, Object>();
        if (externos != null) {
            for (String chave : externos.keySet()) {
                dadosExternos.put(chave.toLowerCase(), externos.get(chave));
            }
        }
        try {
            if (str != null) {
                block13: for (int i = 0; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    switch (estado) {
                        case q0: {
                            if (ch == '[') {
                                estado = Mapa.Estados.q1;
                                continue block13;
                            }
                            if (ch == '{') {
                                estado = Mapa.Estados.q3;
                                continue block13;
                            }
                            if (ch == '\u00bf') {
                                estado = Mapa.Estados.q4;
                                continue block13;
                            }
                            if (ch == '\u00b6') {
                                estado = Mapa.Estados.q6;
                                continue block13;
                            }
                            if (ch == '\n') {
                                ordemRstAnterior = 1;
                            }
                            buf.append(ch);
                            continue block13;
                        }
                        case q1: {
                            if (ch == '!') {
                                estado = Mapa.Estados.q2;
                                continue block13;
                            }
                            num.append(ch);
                            continue block13;
                        }
                        case q2: {
                            Object tmp;
                            if (ch == ']') {
                                tmp = Util.formatar(StringUtil.notNull(inter.resolver(exp.toString())));
                                buf.append((String)(fixaComprimento ? Util.fixaComprimento((String)tmp, Integer.parseInt(num.toString())) : tmp));
                                exp.delete(0, exp.length());
                                num.delete(0, num.length());
                                estado = Mapa.Estados.q0;
                                continue block13;
                            }
                            exp.append(ch);
                            continue block13;
                        }
                        case q3: {
                            if (ch == '}') {
                                buf.append(Util.gerarBarras(StringUtil.notNull(inter.resolver(exp.toString()))));
                                num.delete(0, num.length());
                                exp.delete(0, exp.length());
                                estado = Mapa.Estados.q0;
                                continue block13;
                            }
                            exp.append(ch);
                            continue block13;
                        }
                        case q4: {
                            if (ch == '!') {
                                estado = Mapa.Estados.q5;
                                continue block13;
                            }
                            num.append(ch);
                            continue block13;
                        }
                        case q5: {
                            Object tmp;
                            if (ch == '?') {
                                tmp = resAnteriores != null && (tmp = resAnteriores.get(ordemRstAnterior)) != null ? StringUtil.getValor(StringUtil.getTagEmMinusculas((String)tmp), exp.toString().toLowerCase()).replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "") : "";
                                buf.append(Util.fixaComprimento((String)tmp, Integer.parseInt(num.toString())));
                                ++ordemRstAnterior;
                                num.delete(0, num.length());
                                exp.delete(0, exp.length());
                                estado = Mapa.Estados.q0;
                                continue block13;
                            }
                            exp.append(ch);
                            continue block13;
                        }
                        case q6: {
                            if (ch == '!') {
                                estado = Mapa.Estados.q7;
                                continue block13;
                            }
                            num.append(ch);
                            continue block13;
                        }
                        case q7: {
                            Object tmp;
                            if (ch == '|') {
                                tmp = externos.get(exp.toString().toLowerCase());
                                buf.append(Util.fixaComprimento(StringUtil.notNull((String)tmp), Integer.parseInt(num.toString())));
                                num.delete(0, num.length());
                                exp.delete(0, exp.length());
                                estado = Mapa.Estados.q0;
                                continue block13;
                            }
                            exp.append(ch);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Mapa: 226");
        }
        return StringUtil.separarLinhas(Util.formatar(buf.toString()));
    }

    public static Object[] getCampos(TableModel tabela) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (tabela.getRowCount() > 0) {
            for (int i = 0; i < tabela.getColumnCount(); ++i) {
                tmp.add(tabela.getColumnName(i));
                tmp.add(tabela.getValueAt(0, i));
            }
        }
        return tmp.toArray();
    }

    public static void adicionarStrings(StringBuilder strBuilder, String[] strs) {
        MapaResolverExpressoesUtil.adicionarStrings(strBuilder, strs, ParametrosLocais.getParametro("impressaoLaserMapa"), true);
    }

    public static void adicionarStrings(StringBuilder strBuilder, String[] strs, String paramImpressaoLaserMatricial, boolean addQuebra) {
        MapaResolverExpressoesUtil.adicionarStrings(strBuilder, strs, 0, strs.length, paramImpressaoLaserMatricial, addQuebra);
    }

    public static void adicionarStrings(StringBuilder strBuilder, String[] strs, int pos, int qtde) {
        MapaResolverExpressoesUtil.adicionarStrings(strBuilder, strs, pos, qtde, ParametrosLocais.getParametro("impressaoLaserMapa"), true);
    }

    public static void adicionarStrings(StringBuilder strBuilder, String[] strs, int pos, int qtde, String paramImpressaoLaserMatricial, boolean addQuebra) {
        if (strBuilder != null && strs != null && pos > -1 && pos + qtde <= strs.length) {
            for (int i = 0; i < qtde; ++i) {
                String tmp = strs[pos + i] == null ? "" : strs[pos + i];
                strBuilder.append(StringUtil.getStringImpressaoMatricial(Util.removerTagsAbreFecha(tmp)));
                String quebra = "";
                if (addQuebra) {
                    quebra = CharImpressao.QUEBRA_LINHA_EPSON;
                    if (paramImpressaoLaserMatricial != null && paramImpressaoLaserMatricial.equalsIgnoreCase("1")) {
                        quebra = CharImpressao.QUEBRA_LINHA_LASER;
                    }
                }
                if ((tmp = Util.trataCodigoBarras(tmp)) != null && i < qtde - 1 && Util.contemBarras(strs[pos + i + 1] == null ? "" : strs[pos + i + 1])) {
                    strBuilder.append(CharImpressao.getStringEspacamentoLinha(6));
                    strBuilder.append(quebra);
                    strBuilder.append(tmp);
                    strBuilder.append(CharImpressao.getStringEspacamentoLinha(6));
                    strBuilder.append(quebra);
                    strBuilder.append(CharImpressao.getStringEspacamentoLinha(12));
                    continue;
                }
                strBuilder.append(quebra);
            }
        }
    }
}

