/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.util.StringUtil;
import jalis.util.impressao.matricial.MapaResolverExpressoesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class Mapa {
    private String[] cabecalho = new String[0];
    private String[] rodape = new String[0];
    private int linhas;
    private int colunas;
    private ArrayList<String[]> exames = new ArrayList();

    public void setCabecalhoRodape(String xml, TableModel tabela) {
        Object[] dados = MapaResolverExpressoesUtil.getCampos(tabela);
        String tmp = StringUtil.getValor(xml, "cabecalhoRodape");
        this.linhas = StringUtil.getInt(tmp, "linhas");
        this.colunas = StringUtil.getInt(tmp, "colunas");
        this.cabecalho = MapaResolverExpressoesUtil.resolverExpressoes(StringUtil.getValor(tmp, "cabecalho"), dados, null, null, true);
        this.rodape = MapaResolverExpressoesUtil.resolverExpressoes(StringUtil.getValor(tmp, "rodape"), dados, null, null, true);
    }

    public void addExame(String formato, TableModel tabela) {
        this.addExame(formato, tabela, null, null);
    }

    public void addExame(String formato, TableModel tabela, Map<Integer, String> resAnteriores) {
        this.addExame(formato, tabela, resAnteriores, null);
    }

    public void addExame(String formato, TableModel tabela, Map<Integer, String> resAnteriores, Map<String, Object> externos) {
        this.exames.add(MapaResolverExpressoesUtil.resolverExpressoes(formato, MapaResolverExpressoesUtil.getCampos(tabela), resAnteriores, externos, true));
    }

    String[][] getExames() {
        return (String[][])this.exames.toArray((T[])new String[this.exames.size()][]);
    }

    int getQuantidadeLinhas() {
        return this.linhas;
    }

    int getQuantidadeColunas() {
        return this.colunas;
    }

    String[] getCabecalho() {
        return this.cabecalho;
    }

    String[] getRodape() {
        return this.rodape;
    }

    public static int getQuantidadeResultadosAnteriores(String xml) {
        HashMap<String, Integer> camposEncontrados = new HashMap<String, Integer>();
        int contador = 0;
        if (xml != null) {
            boolean abriu = false;
            String campo = "";
            for (int i = 0; i < xml.length(); ++i) {
                char ch = xml.charAt(i);
                if (ch == '\u00bf') {
                    abriu = true;
                    continue;
                }
                if (abriu && ch == '?') {
                    if (camposEncontrados.containsKey((campo = campo.substring(campo.indexOf("!"))).toLowerCase())) {
                        camposEncontrados.put(campo.toLowerCase(), (Integer)camposEncontrados.get(campo.toLowerCase()) + 1);
                    } else {
                        camposEncontrados.put(campo.toLowerCase(), 1);
                    }
                    abriu = false;
                    campo = "";
                    continue;
                }
                if (!abriu) continue;
                campo = campo + ch;
            }
        }
        for (String key : camposEncontrados.keySet()) {
            if (((Integer)camposEncontrados.get(key)).compareTo(contador) <= 0) continue;
            contador = (Integer)camposEncontrados.get(key);
        }
        return contador;
    }

    static enum Estados {
        q0,
        q1,
        q2,
        q3,
        q4,
        q5,
        q6,
        q7;

    }
}

