/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.comum.ParametrosLocais;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.CharImpressao;
import jalis.util.impressao.matricial.Relatorio;
import jalis.util.impressao.matricial.Util;
import jalis.util.logger.ErrorLogger;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.SimpleDoc;

public class ImpressaoRelatorio {
    private static final int PRIMEIRA_LINHA = 3;
    private PrintService service;

    public ImpressaoRelatorio(String nomeImpressora) {
        this.service = Funcoes.localizarImpressora(nomeImpressora);
        if (this.service == null) {
            ErrorLogger.mostraMensagem(null, "A impressora " + nomeImpressora + " n\u00e3o foi localizada", null);
        }
    }

    public boolean imprimir(Relatorio relatorio) {
        return this.imprimir(new Relatorio[]{relatorio});
    }

    public boolean imprimir(Relatorio ... relatorios) {
        if (this.service != null && relatorios != null && relatorios.length > 0) {
            boolean laser = ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1");
            StringBuilder bui = new StringBuilder(CharImpressao.TABELA_CHAR_1_EPSON);
            for (Relatorio relatorio : relatorios) {
                String[] cabecalho = relatorio.getCabecalho();
                String[] rodape = relatorio.getRodape();
                String[][] itens = relatorio.getItens();
                int qtdeLinhas = relatorio.getQuantidadeLinhas();
                int linhaAtual = 3;
                int linhasCorpo = qtdeLinhas - cabecalho.length - rodape.length - 3 + 1;
                boolean cupom = relatorio.isCupom();
                if (!cupom) {
                    bui.append(CharImpressao.getStringQtdeLinhas(qtdeLinhas));
                }
                char pulaPagina = '\f';
                if (cupom || laser) {
                    pulaPagina = ' ';
                }
                for (int i = 0; i < itens.length; ++i) {
                    int livre;
                    if (linhaAtual == 3) {
                        this.adicionarStrings(bui, cabecalho);
                        linhaAtual += cabecalho.length;
                    }
                    if (itens[i].length <= (livre = qtdeLinhas - linhaAtual - rodape.length + 1) && !cupom) {
                        this.adicionarStrings(bui, itens[i]);
                        linhaAtual += itens[i].length;
                        livre -= itens[i].length;
                    } else {
                        int tamanho;
                        if (!cupom && livre != linhasCorpo) {
                            bui.append(CharImpressao.getStringSaltaLinhas(livre));
                            this.adicionarStrings(bui, rodape);
                            bui.append(pulaPagina);
                            this.adicionarStrings(bui, cabecalho);
                            linhaAtual = 3 + cabecalho.length;
                            livre = linhasCorpo;
                        }
                        int indice = 0;
                        for (tamanho = itens[i].length; tamanho > livre; tamanho -= livre) {
                            this.adicionarStrings(bui, itens[i], indice, livre);
                            this.adicionarStrings(bui, rodape);
                            bui.append(pulaPagina);
                            this.adicionarStrings(bui, cabecalho);
                            indice += livre;
                            linhaAtual = 3 + cabecalho.length;
                            livre = linhasCorpo;
                        }
                        this.adicionarStrings(bui, itens[i], indice, tamanho);
                        linhaAtual += tamanho;
                        livre -= tamanho;
                    }
                    if (i == itens.length - 1 && !cupom) {
                        bui.append(CharImpressao.getStringSaltaLinhas(livre));
                        linhaAtual += livre;
                    }
                    if (linhaAtual != qtdeLinhas - rodape.length + 1 && (!cupom || i != itens.length - 1)) continue;
                    this.adicionarStrings(bui, rodape);
                    bui.append(pulaPagina);
                    linhaAtual = 3;
                }
            }
            try {
                SimpleDoc doc = new SimpleDoc(bui.toString().getBytes(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                this.service.createPrintJob().print(doc, null);
                return true;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoRelatorio: 110");
                return false;
            }
        }
        return false;
    }

    public void terminar() {
        try {
            this.service.createPrintJob().print(new SimpleDoc("\f".getBytes(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null), null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoRelatorio: 134");
        }
    }

    private void adicionarStrings(StringBuilder strBuilder, String[] strs) {
        this.adicionarStrings(strBuilder, strs, 0, strs.length);
    }

    private void adicionarStrings(StringBuilder strBuilder, String[] strs, int pos, int qtde) {
        if (strBuilder != null && strs != null && pos > -1 && pos + qtde <= strs.length) {
            for (int i = 0; i < qtde; ++i) {
                String tmp = strs[pos + i] == null ? "" : strs[pos + i];
                strBuilder.append(StringUtil.getStringImpressaoMatricial(Util.removerTagsAbreFecha(tmp)));
                String quebra = CharImpressao.QUEBRA_LINHA_EPSON;
                if (ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1")) {
                    quebra = CharImpressao.QUEBRA_LINHA_LASER;
                }
                if ((tmp = Util.trataCodigoBarras(tmp)) != null && i < qtde - 1 && Util.contemBarras(strs[pos + i + 1] == null ? "" : strs[pos + i + 1])) {
                    strBuilder.append(CharImpressao.getStringEspacamentoLinha(6));
                    strBuilder.append(quebra);
                    strBuilder.append(tmp);
                    strBuilder.append(CharImpressao.getStringEspacamentoLinha(6));
                    strBuilder.append(quebra);
                    strBuilder.append(CharImpressao.getStringEspacamentoLinha(12));
                    continue;
                }
                strBuilder.append(quebra);
            }
        }
    }
}

