/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.comum.ParametrosLocais;
import jalis.util.Funcoes;
import jalis.util.impressao.matricial.CharImpressao;
import jalis.util.impressao.matricial.Mapa;
import jalis.util.impressao.matricial.MapaResolverExpressoesUtil;
import jalis.util.logger.ErrorLogger;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.SimpleDoc;

public class ImpressaoMapa {
    private static final int PRIMEIRA_LINHA = 3;
    private PrintService service;

    public ImpressaoMapa(String nomeImpressora) {
        this.service = Funcoes.localizarImpressora(nomeImpressora);
        if (this.service == null) {
            ErrorLogger.mostraMensagem(null, "A impressora " + nomeImpressora + " n\u00e3o foi localizada", null);
        }
    }

    public void imprimir(Mapa mapa) {
        this.imprimir(new Mapa[]{mapa});
    }

    public void imprimir(Mapa ... mapas) {
        if (this.service != null && mapas != null && mapas.length > 0) {
            boolean laser = ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1");
            StringBuilder bui = new StringBuilder(laser ? CharImpressao.RESET_LASER : CharImpressao.TABELA_CHAR_1_EPSON);
            for (Mapa mapa : mapas) {
                String[] cabecalho = mapa.getCabecalho();
                String[] rodape = mapa.getRodape();
                String[][] exames = mapa.getExames();
                int qtdeLinhas = mapa.getQuantidadeLinhas();
                int linhaAtual = 3;
                int linhasCorpo = qtdeLinhas - cabecalho.length - rodape.length - 3 + 1;
                if (!laser) {
                    bui.append(CharImpressao.getStringQtdeLinhas(qtdeLinhas));
                }
                char pulaPagina = '\f';
                if (laser && (ParametrosLocais.getParametro("impressaoFinalizarCadaMapa") == null || ParametrosLocais.getParametro("impressaoFinalizarCadaMapa").equalsIgnoreCase("0"))) {
                    pulaPagina = ' ';
                }
                for (int i = 0; i < exames.length; ++i) {
                    int livre;
                    if (linhaAtual == 3) {
                        MapaResolverExpressoesUtil.adicionarStrings(bui, cabecalho);
                        linhaAtual += cabecalho.length;
                    }
                    if (exames[i].length <= (livre = qtdeLinhas - linhaAtual - rodape.length + 1)) {
                        MapaResolverExpressoesUtil.adicionarStrings(bui, exames[i]);
                        linhaAtual += exames[i].length;
                        livre -= exames[i].length;
                    } else {
                        int tamanho;
                        if (livre != linhasCorpo) {
                            bui.append(CharImpressao.getStringSaltaLinhas(livre));
                            MapaResolverExpressoesUtil.adicionarStrings(bui, rodape);
                            bui.append(pulaPagina);
                            MapaResolverExpressoesUtil.adicionarStrings(bui, cabecalho);
                            linhaAtual = 3 + cabecalho.length;
                            livre = linhasCorpo;
                        }
                        int indice = 0;
                        for (tamanho = exames[i].length; tamanho > livre; tamanho -= livre) {
                            MapaResolverExpressoesUtil.adicionarStrings(bui, exames[i], indice, livre);
                            MapaResolverExpressoesUtil.adicionarStrings(bui, rodape);
                            bui.append(pulaPagina);
                            MapaResolverExpressoesUtil.adicionarStrings(bui, cabecalho);
                            indice += livre;
                            linhaAtual = 3 + cabecalho.length;
                            livre = linhasCorpo;
                        }
                        MapaResolverExpressoesUtil.adicionarStrings(bui, exames[i], indice, tamanho);
                        linhaAtual += tamanho;
                        livre -= tamanho;
                    }
                    if (i == exames.length - 1) {
                        bui.append(CharImpressao.getStringSaltaLinhas(livre));
                        linhaAtual += livre;
                    }
                    if (linhaAtual != qtdeLinhas - rodape.length + 1) continue;
                    MapaResolverExpressoesUtil.adicionarStrings(bui, rodape);
                    bui.append(pulaPagina);
                    linhaAtual = 3;
                }
            }
            try {
                SimpleDoc doc = new SimpleDoc(bui.toString().getBytes(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                this.service.createPrintJob().print(doc, null);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoMapa: 110");
            }
        }
    }

    public void terminar() {
        try {
            this.service.createPrintJob().print(new SimpleDoc("\f".getBytes(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null), null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoMapa: 134");
        }
    }
}

