/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class GerenciadorAtributos {
    public static final int NEGRITO = 0;
    public static final int ITALICO = 1;
    public static final int SUBLINHADO = 2;
    public static final int SOBRESCRITO = 3;
    public static final int SUBSCRITO = 4;
    public static final int EXPANDIDO = 5;
    public static final int COMPRIMIDO = 6;
    public static final int OITO_LINHAS = 7;
    public static final int PASSADA_DUPLA = 8;
    private ArrayList atributos = new ArrayList();

    GerenciadorAtributos() {
    }

    public String getLexema(int tipo) {
        switch (tipo) {
            case 0: {
                return "n";
            }
            case 1: {
                return "i";
            }
            case 2: {
                return "s";
            }
            case 3: {
                return "sob";
            }
            case 4: {
                return "sub";
            }
            case 5: {
                return "exp";
            }
            case 6: {
                return "comp";
            }
            case 7: {
                return "oitoLinhas";
            }
            case 8: {
                return "2x";
            }
        }
        return "";
    }

    public int getTipo(String lex) {
        if (lex.equalsIgnoreCase("n")) {
            return 0;
        }
        if (lex.equalsIgnoreCase("i")) {
            return 1;
        }
        if (lex.equalsIgnoreCase("s")) {
            return 2;
        }
        if (lex.equalsIgnoreCase("sob")) {
            return 3;
        }
        if (lex.equalsIgnoreCase("sub")) {
            return 4;
        }
        if (lex.equalsIgnoreCase("exp")) {
            return 5;
        }
        if (lex.equalsIgnoreCase("comp")) {
            return 6;
        }
        if (lex.equalsIgnoreCase("oitoLinhas")) {
            return 7;
        }
        if (lex.equalsIgnoreCase("2x")) {
            return 8;
        }
        return -1;
    }

    public void limpar() {
        this.atributos.clear();
    }

    public void setAtributo(int atributo, int posIni, int posFin) {
        boolean add = true;
        int[][] tmp = this.getAtributosConflitantes(atributo, posIni, posFin);
        for (int i = 0; i < tmp.length; ++i) {
            if (posIni >= tmp[i][1] && posFin <= tmp[i][2]) {
                if (posIni > tmp[i][1]) {
                    this.atributos.add(new int[]{atributo, tmp[i][1], posIni});
                }
                if (posFin < tmp[i][2]) {
                    this.atributos.add(new int[]{atributo, posFin, tmp[i][2]});
                }
                add = false;
            } else {
                posIni = Math.min(posIni, tmp[i][1]);
                posFin = Math.max(posFin, tmp[i][2]);
            }
            this.atributos.remove(tmp[i]);
        }
        if (add) {
            this.atributos.add(new int[]{atributo, posIni, posFin});
        }
    }

    public void inserirIntervalo(int posIni, int posFin) {
        int comp = posFin - posIni;
        int[][] tmp = (int[][])this.atributos.toArray((T[])new int[this.atributos.size()][]);
        for (int i = 0; i < tmp.length; ++i) {
            if (posIni <= tmp[i][1]) {
                int[] nArray = tmp[i];
                nArray[1] = nArray[1] + comp;
            }
            if (posIni > tmp[i][2]) continue;
            int[] nArray = tmp[i];
            nArray[2] = nArray[2] + comp;
        }
    }

    public void removerIntervalo(int posIni, int posFin) {
        int comp = posFin - posIni;
        int[][] tmp = (int[][])this.atributos.toArray((T[])new int[this.atributos.size()][]);
        for (int i = 0; i < tmp.length; ++i) {
            if (this.conflitante(posIni, posFin, tmp[i][1], tmp[i][2])) {
                if (posIni <= tmp[i][1] && posFin >= tmp[i][2]) {
                    this.atributos.remove(tmp[i]);
                    continue;
                }
                if (posIni > tmp[i][1] && posFin < tmp[i][2]) {
                    int[] nArray = tmp[i];
                    nArray[2] = nArray[2] - comp;
                    continue;
                }
                if (posIni <= tmp[i][1]) {
                    tmp[i][1] = posIni;
                    int[] nArray = tmp[i];
                    nArray[2] = nArray[2] - comp;
                    continue;
                }
                tmp[i][2] = posIni;
                continue;
            }
            if (posIni >= tmp[i][1]) continue;
            int[] nArray = tmp[i];
            nArray[1] = nArray[1] - comp;
            int[] nArray2 = tmp[i];
            nArray2[2] = nArray2[2] - comp;
        }
    }

    public int[][] getAtributos() {
        return (int[][])this.atributos.toArray((T[])new int[this.atributos.size()][]);
    }

    public int[] getPosicoes() {
        int[][] tmp = (int[][])this.atributos.toArray((T[])new int[this.atributos.size()][]);
        int[] intervalos = new int[tmp.length * 2];
        for (int i = 0; i < tmp.length; ++i) {
            intervalos[i * 2] = tmp[i][1];
            intervalos[i * 2 + 1] = tmp[i][2];
        }
        Arrays.sort(intervalos);
        int ult = -1;
        int pos = 0;
        int cont = 0;
        for (int i = 0; i < intervalos.length; ++i) {
            if (intervalos[i] == ult) continue;
            ++cont;
            ult = intervalos[i];
        }
        ult = -1;
        int[] res = new int[cont];
        for (int i = 0; i < intervalos.length; ++i) {
            if (intervalos[i] == ult) continue;
            res[pos++] = intervalos[i];
            ult = intervalos[i];
        }
        return res;
    }

    public Object[] getAttributeSet() {
        ArrayList<Object> a = new ArrayList<Object>();
        int[] inter = this.getPosicoes();
        for (int i = 0; i < inter.length - 1; ++i) {
            a.add(this.getAtributoIntervalo(inter[i], inter[i + 1]));
            a.add(new Integer(inter[i]));
            a.add(new Integer(inter[i + 1]));
        }
        return a.toArray();
    }

    private int[][] getAtributosConflitantes(int atr, int posIni, int posFin) {
        ArrayList<int[]> conf = new ArrayList<int[]>();
        int[][] tmp = (int[][])this.atributos.toArray((T[])new int[this.atributos.size()][]);
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i][0] != atr || !this.conflitante(posIni, posFin, tmp[i][1], tmp[i][2])) continue;
            conf.add(tmp[i]);
        }
        return (int[][])conf.toArray((T[])new int[conf.size()][]);
    }

    private boolean conflitante(int posIniA, int posFinA, int posIniB, int posFinB) {
        return posIniA >= posIniB && posIniA <= posFinB || posFinA >= posIniB && posFinA <= posFinB || posIniA <= posIniB && posFinA >= posFinB;
    }

    public MutableAttributeSet getAtributoIntervalo(int posIni, int posFin) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        int[][] tmp = (int[][])this.atributos.toArray((T[])new int[this.atributos.size()][]);
        block10: for (int i = 0; i < tmp.length; ++i) {
            if (posIni < tmp[i][1] || posFin > tmp[i][2]) continue;
            switch (tmp[i][0]) {
                case 0: {
                    StyleConstants.setBold(a, true);
                    continue block10;
                }
                case 1: {
                    StyleConstants.setItalic(a, true);
                    continue block10;
                }
                case 2: {
                    StyleConstants.setUnderline(a, true);
                    continue block10;
                }
                case 3: {
                    StyleConstants.setSuperscript(a, true);
                    continue block10;
                }
                case 4: {
                    StyleConstants.setSubscript(a, true);
                    continue block10;
                }
                case 5: {
                    StyleConstants.setFontSize(a, 15);
                    continue block10;
                }
                case 6: {
                    StyleConstants.setFontSize(a, 9);
                    continue block10;
                }
                case 7: {
                    StyleConstants.setBackground(a, Color.lightGray);
                }
            }
        }
        return a;
    }
}

