/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.util.DialogoLista;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.expressao.AbstractEstiloDocumento;
import jalis.util.expressao.DialogoFuncao;
import jalis.util.expressao.DialogoFuncaoFactory;
import jalis.util.expressao.parser.ExpressaoException;
import jalis.util.expressao.parser.Sintatico;
import jalis.util.impressao.matricial.Campo;
import jalis.util.impressao.matricial.DocumentoMapa;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;

public class EditorSMS
extends JDialog
implements ActionListener,
FocusListener,
CaretListener,
DisposeListener {
    private static final String COMBO_OK = "ok";
    private static final String COMBO_CANCELADO = "cancelado";
    private transient LayoutManager borderLayout = new BorderLayout();
    JPanel panelArea = new JPanel(new BorderLayout());
    JPanel panelCentral = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelLeste = new JPanel(new FlowLayout());
    JPanel panelSul = new JPanel(new BorderLayout());
    JPanel panelFormatoCabecalho = new JPanel(new BorderLayout());
    JPanel panelExpressao = new JPanel(this.borderLayout);
    DocumentoMapa docFormatoCabecalho = new DocumentoMapa();
    JTextPane textFormatoCabecalho = ComponenteFactory.novoJTextPane(this.docFormatoCabecalho);
    JTextPane textExpressao = ComponenteFactory.novoJTextPane();
    JScrollPane scrollExpressao = new JScrollPane(this.textExpressao);
    JLabel labelErro = new JLabel();
    JLabel labelOrigem = new JLabel("Origem:");
    JLabel labelExterno = new JLabel("Campo Externo:");
    JComboBox comboOrigem = new JComboBox();
    JComboBox comboExternos = new JComboBox();
    JButton buttonExpressao = new JButton("Express\u00e3o");
    JButton buttonBanco = new JButton("Banco");
    JButton buttonSe = new JButton("Se");
    JButton buttonCopia = new JButton("Copia");
    JButton buttonVazio = new JButton("Vazio");
    JButton buttonZero = new JButton("Zero");
    JButton buttonExtenso = new JButton("Extenso");
    JButton buttonTamanho = new JButton("Tamanho");
    JButton buttonNumero = new JButton("Numero");
    JButton buttonData = new JButton("Data");
    JButton buttonSomaData = new JButton("SomaData");
    JButton buttonOk = new JButton("OK");
    JButton buttonCancelar = new JButton("Cancelar");
    JButton buttonExportar = new JButton("Exportar");
    JButton buttonImportar = new JButton("Importar");
    private boolean tratandoExpressao;
    private boolean ok = false;
    private int posCursor;
    private DocumentoMapa docSelecionado;
    private transient Campo resAnteriorSelecionado;
    private transient Campo externoSelecionado;
    private String[] campos = new String[0];
    private JTextPane ultimoTextPane;
    private ChangeListener eventoErro = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractEstiloDocumento doc = (AbstractEstiloDocumento)e.getSource();
            doc.removeChangeListener(this);
            EditorSMS.this.labelErro.setText("");
        }
    };

    public static EditorSMS novaInstancia(Object pai) {
        EditorSMS editor = null;
        if (pai instanceof Frame) {
            return new EditorSMS((Frame)pai, "Editor de mapa", true);
        }
        if (pai instanceof Dialog) {
            return new EditorSMS((Dialog)pai, "Editor de mapa", true);
        }
        return editor;
    }

    public EditorSMS(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public EditorSMS(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setCampoDoBanco(String[] campoBanco) {
        this.campos = campoBanco;
        StringUtil.ordenar(this.campos);
    }

    public String getFormato() {
        return this.docFormatoCabecalho.getTexto();
    }

    public void setFormato(String formato) {
        if (formato.contains("[") && !formato.contains("2!")) {
            formato = formato.replace("[", "[2!");
        }
        this.docFormatoCabecalho.setTexto(formato);
    }

    public void setAtributosExame(String atributos) {
        try {
            this.comboOrigem.removeAllItems();
            this.comboOrigem.addItem("");
            this.comboOrigem.addItem("dataResultado");
            String tmp = StringUtil.getValor(atributos, "exame");
            tmp = StringUtil.getValor(tmp, "pagina");
            tmp = StringUtil.getValor(tmp, "itens");
            tmp = StringUtil.getValor(tmp, "corpo");
            for (String comp : StringUtil.getListValores(tmp, "componente")) {
                tmp = StringUtil.getValor(comp, "atributos");
                if (!StringUtil.getBoolean(tmp, "resultadoAnterior")) continue;
                this.comboOrigem.addItem(StringUtil.getValor(tmp, "nome"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditorSMS: 269");
        }
    }

    public void setAtributosPergunta(String atributos) {
        try {
            this.comboExternos.removeAllItems();
            this.comboExternos.addItem("");
            Class<Digitavel> classDigitavel = Digitavel.class;
            String tmp = StringUtil.getValor(atributos, "exame");
            tmp = StringUtil.getValor(tmp, "pagina");
            tmp = StringUtil.getValor(tmp, "itens");
            tmp = StringUtil.getValor(tmp, "corpo");
            for (String comp : StringUtil.getListValores(tmp, "componente")) {
                tmp = StringUtil.getValor(comp, "atributos");
                if (!classDigitavel.isAssignableFrom(Class.forName(StringUtil.getValor(comp, "tipo")))) continue;
                this.comboExternos.addItem(StringUtil.getValor(tmp, "nome"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditorSMS: 286");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.comboOrigem && this.resAnteriorSelecionado != null && this.comboOrigem.getActionCommand().equals(COMBO_OK)) {
                this.resAnteriorSelecionado.campo = (String)this.comboOrigem.getSelectedItem();
            } else if (o == this.comboExternos && this.externoSelecionado != null && this.comboExternos.getActionCommand().equals(COMBO_OK)) {
                this.externoSelecionado.campo = (String)this.comboExternos.getSelectedItem();
            } else if (o == this.buttonExpressao) {
                if (this.ultimoTextPane != null) {
                    String str = "[]";
                    int pos = this.ultimoTextPane.getCaretPosition();
                    this.ultimoTextPane.getDocument().insertString(pos, str, null);
                    this.ultimoTextPane.setCaretPosition(pos + 1);
                    ScreenUtil.requisitarFoco(this.textExpressao);
                    this.ultimoTextPane = null;
                }
            } else if (o == this.buttonOk || o == this.buttonCancelar) {
                boolean bl = this.ok = o == this.buttonOk;
                if (!this.ok || this.validarExpressoes()) {
                    this.dispose();
                }
            } else if (o == this.buttonExportar) {
                JFileChooser fc = ComponenteFactory.novoJFileChooser();
                fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Mapa", "map"));
                if (fc.showSaveDialog(this) == 0) {
                    StringUtil.escreverArquivoTexto(this.addExtensao(fc.getSelectedFile().getPath()), this.getFormato());
                }
            } else if (o == this.buttonImportar) {
                JFileChooser fc = ComponenteFactory.novoJFileChooser();
                fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Mapa", "map"));
                if (fc.showOpenDialog(this) == 0) {
                    String tmp = StringUtil.lerArquivoTexto(fc.getSelectedFile().getPath());
                    this.setFormato(tmp);
                }
            } else if (o == this.buttonBanco) {
                DialogoLista dl = DialogoLista.novaInstancia(this, "Campos do banco");
                dl.setItens(this.campos);
                dl.setVisible(true);
                if (dl.ok()) {
                    int pos = this.textExpressao.getCaretPosition();
                    this.textExpressao.getDocument().insertString(pos, dl.getItemSelecionado(), null);
                    this.textExpressao.requestFocus();
                }
            } else {
                DialogoFuncao df = this.getDialogo(o);
                if (df != null) {
                    df.setCamposBanco(this.campos);
                    df.setVisible(true);
                    if (df.ok()) {
                        this.textExpressao.getDocument().insertString(this.textExpressao.getCaretPosition(), df.getExpressao(), null);
                        this.textExpressao.requestFocus();
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EditorSMS: 356");
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            JTextPane text = (JTextPane)e.getSource();
            this.posCursor = text.getCaretPosition();
            if (!this.tratandoExpressao) {
                this.panelExpressao.removeAll();
                this.panelExpressao.setBorder(BorderFactory.createTitledBorder(" "));
                this.docSelecionado = (DocumentoMapa)text.getDocument();
                StyledDocument sdoc = this.docSelecionado.getDocumentoExpressao(this.posCursor);
                if (sdoc instanceof AbstractEstiloDocumento) {
                    AbstractEstiloDocumento absDoc = (AbstractEstiloDocumento)sdoc;
                    absDoc.setTextComponent(this.textExpressao);
                    this.textExpressao.setStyledDocument(absDoc);
                    this.panelExpressao.setLayout(this.borderLayout);
                    this.panelExpressao.add((Component)this.scrollExpressao, "Center");
                    this.panelExpressao.setBorder(BorderFactory.createTitledBorder("Express\u00e3o"));
                    absDoc.destacarTokens();
                }
                this.resAnteriorSelecionado = this.docSelecionado.getCampoResAnterior(this.posCursor);
                if (this.resAnteriorSelecionado != null) {
                    this.panelExpressao.setLayout(null);
                    this.panelExpressao.add(this.labelOrigem);
                    this.panelExpressao.add(this.comboOrigem);
                    this.panelExpressao.setBorder(BorderFactory.createTitledBorder("Resultado Anterior"));
                    this.comboOrigem.setActionCommand(COMBO_CANCELADO);
                    this.comboOrigem.setSelectedIndex(0);
                    this.comboOrigem.setSelectedItem(this.resAnteriorSelecionado.campo);
                    this.comboOrigem.setActionCommand(COMBO_OK);
                }
                this.externoSelecionado = this.docSelecionado.getCampoExterno(this.posCursor);
                if (this.externoSelecionado != null) {
                    this.panelExpressao.setLayout(null);
                    this.panelExpressao.add(this.labelExterno);
                    this.panelExpressao.add(this.comboExternos);
                    this.panelExpressao.setBorder(BorderFactory.createTitledBorder("Campos Externos"));
                    this.comboExternos.setActionCommand(COMBO_CANCELADO);
                    if (this.comboExternos.getItemCount() > 0) {
                        this.comboExternos.setSelectedIndex(0);
                        this.comboExternos.setSelectedItem(this.externoSelecionado.campo);
                    }
                    this.comboExternos.setActionCommand(COMBO_OK);
                }
                this.panelExpressao.revalidate();
                this.panelExpressao.repaint();
            }
            if (text.hasFocus()) {
                int[] tmp = StringUtil.getLinhaColuna(text.getText(), this.posCursor, 10);
                if (text == this.textFormatoCabecalho) {
                    TitledBorder borda = (TitledBorder)this.panelFormatoCabecalho.getBorder();
                    borda.setTitle("Formato [" + tmp[0] + "," + tmp[1] + "]");
                    this.panelFormatoCabecalho.repaint();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EditorSMS: 412");
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.comboOrigem) {
            if (this.docSelecionado != null) {
                this.docSelecionado.selecionarResAnterior(this.posCursor);
            }
            this.tratandoExpressao = false;
            this.habilitarDesabilitar(false);
        } else if (o == this.comboExternos) {
            if (this.docSelecionado != null) {
                this.docSelecionado.selecionarCampoExterno(this.posCursor);
            }
            this.tratandoExpressao = false;
            this.habilitarDesabilitar(false);
        } else if (o == this.textExpressao) {
            if (this.docSelecionado != null) {
                this.tratandoExpressao = true;
                this.docSelecionado.selecionarCampoExpressao(this.posCursor);
            }
            this.habilitarDesabilitar(true);
        } else if (o == this.textFormatoCabecalho) {
            JTextPane text = (JTextPane)o;
            int pos = text.getCaretPosition();
            if (this.docSelecionado != null) {
                this.docSelecionado.removerSelecao();
                text.setCaretPosition(pos);
            }
            this.tratandoExpressao = false;
            this.ultimoTextPane = text;
            this.habilitarDesabilitar(false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTextPane text;
        if (e.getSource() instanceof JTextPane && (text = (JTextPane)e.getSource()) == this.textFormatoCabecalho) {
            TitledBorder borda = (TitledBorder)this.panelFormatoCabecalho.getBorder();
            borda.setTitle("Formato");
            this.panelFormatoCabecalho.repaint();
        }
    }

    public boolean validarExpressoes() throws Exception {
        Object[] tmp = this.docFormatoCabecalho.getDocumentos();
        for (int i = 0; i <= tmp.length - 2; i += 2) {
            if (this.validarDocumento(this.docFormatoCabecalho, tmp[i + 1], (Integer)tmp[i])) continue;
            return false;
        }
        return true;
    }

    private boolean validarDocumento(DocumentoMapa docExp, Object doc, int pos) throws Exception {
        if (doc instanceof AbstractEstiloDocumento) {
            AbstractEstiloDocumento adoc = (AbstractEstiloDocumento)doc;
            Sintatico sin = new Sintatico();
            try {
                sin.analisar(adoc.getText(0, adoc.getLength()));
            }
            catch (ExpressaoException e) {
                if (this.docSelecionado != null) {
                    this.docSelecionado.removerSelecao();
                }
                this.textExpressao.setDocument(adoc);
                adoc.destacarErro(e.pos);
                adoc.addChangeListener(this.eventoErro);
                docExp.selecionarCampoExpressao(pos);
                this.labelErro.setText(" " + e.getMessage());
                this.textExpressao.setCaretPosition(e.pos);
                this.textExpressao.requestFocus();
                this.panelExpressao.revalidate();
                this.docSelecionado = docExp;
                return false;
            }
        }
        return true;
    }

    private void habilitarDesabilitar(boolean focoExpressao) {
        this.buttonBanco.setVisible(focoExpressao);
        this.buttonSe.setVisible(focoExpressao);
        this.buttonCopia.setVisible(focoExpressao);
        this.buttonVazio.setVisible(focoExpressao);
        this.buttonZero.setVisible(focoExpressao);
        this.buttonExtenso.setVisible(focoExpressao);
        this.buttonTamanho.setVisible(focoExpressao);
        this.buttonNumero.setVisible(focoExpressao);
        this.buttonData.setVisible(focoExpressao);
        this.buttonSomaData.setVisible(focoExpressao);
        this.buttonExpressao.setVisible(!focoExpressao);
    }

    private void iniciar() {
        JPanel panelAux = new JPanel(new FlowLayout(2, 3, 3));
        Font fonte = new Font("Monospaced", 0, 11);
        this.setSize(new Dimension(730, 590));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelArea, "Center");
        this.getContentPane().add((Component)this.panelSul, "South");
        this.panelArea.add((Component)this.panelCentral, "Center");
        this.panelArea.add((Component)this.panelLeste, "East");
        this.panelArea.add((Component)this.labelErro, "South");
        this.panelCentral.add(this.panelFormatoCabecalho);
        this.panelCentral.add(this.panelExpressao);
        this.panelLeste.setPreferredSize(new Dimension(120, 10));
        this.panelLeste.add(this.buttonBanco);
        this.panelLeste.add(this.buttonSe);
        this.panelLeste.add(this.buttonCopia);
        this.panelLeste.add(this.buttonVazio);
        this.panelLeste.add(this.buttonZero);
        this.panelLeste.add(this.buttonExtenso);
        this.panelLeste.add(this.buttonTamanho);
        this.panelLeste.add(this.buttonNumero);
        this.panelLeste.add(this.buttonData);
        this.panelLeste.add(this.buttonSomaData);
        this.panelLeste.add(this.buttonExpressao);
        this.panelSul.add((Component)panelAux, "East");
        this.panelSul.setBorder(BorderFactory.createEtchedBorder());
        panelAux.add(this.buttonOk);
        panelAux.add(this.buttonCancelar);
        panelAux = new JPanel(new FlowLayout(0, 3, 3));
        this.panelSul.add((Component)panelAux, "Center");
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonImportar);
        this.panelFormatoCabecalho.add((Component)new JScrollPane(this.textFormatoCabecalho), "Center");
        this.panelFormatoCabecalho.setPreferredSize(new Dimension(580, 250));
        this.panelFormatoCabecalho.setBorder(BorderFactory.createTitledBorder("Formato"));
        this.panelExpressao.setPreferredSize(new Dimension(580, 140));
        this.panelExpressao.setBorder(BorderFactory.createTitledBorder(" "));
        this.textFormatoCabecalho.setFont(fonte);
        this.textFormatoCabecalho.addFocusListener(this);
        this.textFormatoCabecalho.addCaretListener(this);
        this.textExpressao.setFont(fonte);
        this.textExpressao.addFocusListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonExportar.addActionListener(this);
        this.buttonImportar.addActionListener(this);
        this.labelErro.setForeground(Color.red);
        this.labelErro.setPreferredSize(new Dimension(10, 30));
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.labelOrigem.setBounds(10, 20, 60, 22);
        this.comboOrigem.setBounds(70, 20, 160, 22);
        this.comboOrigem.addFocusListener(this);
        this.comboOrigem.addActionListener(this);
        this.labelExterno.setBounds(10, 20, 110, 22);
        this.comboExternos.setBounds(120, 20, 160, 22);
        this.comboExternos.addFocusListener(this);
        this.comboExternos.addActionListener(this);
        Insets margens = new Insets(3, 3, 3, 3);
        Dimension tamanho = new Dimension(110, 25);
        Component[] c = this.panelLeste.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JButton b = (JButton)c[i];
            b.setMargin(margens);
            b.setPreferredSize(tamanho);
            b.setHorizontalAlignment(2);
            b.addActionListener(this);
        }
        this.habilitarDesabilitar(false);
    }

    private DialogoFuncao getDialogo(Object botao) {
        if (botao == this.buttonSe) {
            return DialogoFuncaoFactory.criarDialogoFuncao(0, this);
        }
        if (botao == this.buttonCopia) {
            return DialogoFuncaoFactory.criarDialogoFuncao(1, this);
        }
        if (botao == this.buttonVazio) {
            return DialogoFuncaoFactory.criarDialogoFuncao(2, this);
        }
        if (botao == this.buttonZero) {
            return DialogoFuncaoFactory.criarDialogoFuncao(3, this);
        }
        if (botao == this.buttonExtenso) {
            return DialogoFuncaoFactory.criarDialogoFuncao(4, this);
        }
        if (botao == this.buttonTamanho) {
            return DialogoFuncaoFactory.criarDialogoFuncao(5, this);
        }
        if (botao == this.buttonNumero) {
            return DialogoFuncaoFactory.criarDialogoFuncao(6, this);
        }
        if (botao == this.buttonData) {
            return DialogoFuncaoFactory.criarDialogoFuncao(7, this);
        }
        if (botao == this.buttonSomaData) {
            return DialogoFuncaoFactory.criarDialogoFuncao(8, this);
        }
        return null;
    }

    private String addExtensao(String arquivo) {
        if (arquivo != null && !arquivo.endsWith(".map")) {
            arquivo = arquivo + ".map";
        }
        return arquivo;
    }
}

