/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.util.DialogoLista;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.expressao.AbstractEstiloDocumento;
import jalis.util.expressao.DialogoFuncao;
import jalis.util.expressao.DialogoFuncaoFactory;
import jalis.util.expressao.parser.ExpressaoException;
import jalis.util.expressao.parser.Sintatico;
import jalis.util.impressao.matricial.Campo;
import jalis.util.impressao.matricial.DocumentoMapa;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;

public class EditorMapa
extends JDialog
implements ActionListener,
FocusListener,
CaretListener,
DisposeListener {
    private static final String COMBO_OK = "ok";
    private static final String COMBO_CANCELADO = "cancelado";
    public static final int FORMATO = 0;
    public static final int CABECALHO_RODAPE = 1;
    private LayoutManager borderLayout = new BorderLayout();
    JPanel panelArea = new JPanel(new BorderLayout());
    JPanel panelCentral = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelLeste = new JPanel(new FlowLayout());
    JPanel panelSul = new JPanel(new BorderLayout());
    JPanel panelFormatoCabecalho = new JPanel(new BorderLayout());
    JPanel panelRodape = new JPanel(new BorderLayout());
    JPanel panelExpressao = new JPanel(this.borderLayout);
    DocumentoMapa docFormatoCabecalho = new DocumentoMapa();
    DocumentoMapa docRodape = new DocumentoMapa();
    JTextPane textFormatoCabecalho = ComponenteFactory.novoJTextPane(this.docFormatoCabecalho);
    JTextPane textRodape = ComponenteFactory.novoJTextPane(this.docRodape);
    JTextPane textExpressao = ComponenteFactory.novoJTextPane();
    JTextField textLinhas = new JTextField();
    JTextField textColunas = new JTextField();
    JScrollPane scrollExpressao = new JScrollPane(this.textExpressao);
    JLabel labelErro = new JLabel();
    JLabel labelLinhas = new JLabel("  Linhas: ");
    JLabel labelColunas = new JLabel("  Colunas: ");
    JLabel labelOrigem = new JLabel("Origem:");
    JLabel labelExterno = new JLabel("Campo Externo:");
    JComboBox comboOrigem = new JComboBox();
    JComboBox comboExternos = new JComboBox();
    JButton buttonExpressao = new JButton("Express\u00e3o");
    JButton buttonBarras = new JButton("Barras");
    JButton buttonResAnterior = new JButton("Res. Anterior");
    JButton buttonCampoExterno = new JButton("Campo Externo");
    JButton buttonBanco = new JButton("Banco");
    JButton buttonSe = new JButton("Se");
    JButton buttonCopia = new JButton("Copia");
    JButton buttonVazio = new JButton("Vazio");
    JButton buttonZero = new JButton("Zero");
    JButton buttonExtenso = new JButton("Extenso");
    JButton buttonTamanho = new JButton("Tamanho");
    JButton buttonNumero = new JButton("Numero");
    JButton buttonData = new JButton("Data");
    JButton buttonSomaData = new JButton("SomaData");
    JButton buttonNegrito = new JButton("Negrito");
    JButton buttonItalico = new JButton("It\u00e1lico");
    JButton buttonSublinhado = new JButton("Sublinhado");
    JButton buttonSobrescrito = new JButton("Sobrescrito");
    JButton buttonSubscrito = new JButton("Subscrito");
    JButton buttonExpandido = new JButton("Expandido");
    JButton buttonComprimido = new JButton("Comprimido");
    JButton buttonOitoLinhas = new JButton("8 linhas/p");
    JButton buttonOk = new JButton("Ok");
    JButton buttonCancelar = new JButton("Cancelar");
    JButton buttonExportar = new JButton("Exportar");
    JButton buttonImportar = new JButton("Importar");
    private int tipo;
    private boolean tratandoExpressao;
    private boolean ok = false;
    private int posCursor;
    private DocumentoMapa docSelecionado;
    private Campo resAnteriorSelecionado;
    private Campo externoSelecionado;
    private String[] campos = new String[0];
    private JTextPane ultimoTextPane;
    private ChangeListener eventoErro = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractEstiloDocumento doc = (AbstractEstiloDocumento)e.getSource();
            doc.removeChangeListener(this);
            EditorMapa.this.labelErro.setText("");
        }
    };

    public static EditorMapa novaInstancia(Object pai, int tipo) {
        EditorMapa editor = null;
        if (pai instanceof Frame) {
            return new EditorMapa((Frame)pai, "Editor de mapa", true, tipo);
        }
        if (pai instanceof Dialog) {
            return new EditorMapa((Dialog)pai, "Editor de mapa", true, tipo);
        }
        return editor;
    }

    public EditorMapa(Frame pai, String titulo, boolean modal, int tipo) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar(tipo);
        ScreenUtil.centralizar(this);
    }

    public EditorMapa(Dialog pai, String titulo, boolean modal, int tipo) {
        super(pai, titulo, modal);
        this.iniciar(tipo);
        ScreenUtil.centralizar(this);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setCampoDoBanco(String[] campoBanco) {
        this.campos = campoBanco;
        StringUtil.ordenar(this.campos);
    }

    public int getTipo() {
        return this.tipo;
    }

    public String getFormato() {
        return this.docFormatoCabecalho.getTexto();
    }

    public void setFormato(String formato) {
        this.docFormatoCabecalho.setTexto(formato);
    }

    public String getCabecalhoRodape() {
        StringBuilder bui = new StringBuilder(StringUtil.getTag("cabecalho", this.docFormatoCabecalho.getTexto()));
        bui.append(StringUtil.getTag("linhas", this.textLinhas.getText()));
        bui.append(StringUtil.getTag("colunas", this.textColunas.getText()));
        bui.append(StringUtil.getTag("rodape", this.docRodape.getTexto()));
        return StringUtil.getTag("cabecalhoRodape", bui.toString());
    }

    public void setCabecalhoRodape(String valor) {
        if (valor != null) {
            valor = StringUtil.getValor(valor, "cabecalhoRodape");
            this.textLinhas.setText(StringUtil.getValor(valor, "linhas"));
            this.textColunas.setText(StringUtil.getValor(valor, "colunas"));
            this.docFormatoCabecalho.setTexto(StringUtil.getValor(valor, "cabecalho"));
            this.docRodape.setTexto(StringUtil.getValor(valor, "rodape"));
            if (this.textLinhas.getText().trim().length() == 0) {
                this.textLinhas.setText("66");
            }
            if (this.textColunas.getText().trim().length() == 0) {
                this.textColunas.setText("80");
            }
        }
    }

    public void setAtributosExame(String atributos) {
        try {
            this.comboOrigem.removeAllItems();
            this.comboOrigem.addItem("");
            this.comboOrigem.addItem("dataResultado");
            String tmp = StringUtil.getValor(atributos, "exame");
            tmp = StringUtil.getValor(tmp, "pagina");
            tmp = StringUtil.getValor(tmp, "itens");
            tmp = StringUtil.getValor(tmp, "corpo");
            for (String comp : StringUtil.getListValores(tmp, "componente")) {
                tmp = StringUtil.getValor(comp, "atributos");
                if (!StringUtil.getBoolean(tmp, "resultadoAnterior")) continue;
                this.comboOrigem.addItem(StringUtil.getValor(tmp, "nome"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditorMapa: 269");
        }
    }

    public void setAtributosPergunta(String atributos) {
        try {
            this.comboExternos.removeAllItems();
            this.comboExternos.addItem("");
            Class<Digitavel> classDigitavel = Digitavel.class;
            String tmp = StringUtil.getValor(atributos, "exame");
            tmp = StringUtil.getValor(tmp, "pagina");
            tmp = StringUtil.getValor(tmp, "itens");
            tmp = StringUtil.getValor(tmp, "corpo");
            for (String comp : StringUtil.getListValores(tmp, "componente")) {
                tmp = StringUtil.getValor(comp, "atributos");
                if (!classDigitavel.isAssignableFrom(Class.forName(StringUtil.getValor(comp, "tipo")))) continue;
                this.comboExternos.addItem(StringUtil.getValor(tmp, "nome"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditorMapa: 286");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.comboOrigem && this.resAnteriorSelecionado != null && this.comboOrigem.getActionCommand().equals(COMBO_OK)) {
                this.resAnteriorSelecionado.campo = (String)this.comboOrigem.getSelectedItem();
            } else if (o == this.comboExternos && this.externoSelecionado != null && this.comboExternos.getActionCommand().equals(COMBO_OK)) {
                this.externoSelecionado.campo = (String)this.comboExternos.getSelectedItem();
            } else if (o == this.buttonExpressao || o == this.buttonBarras || o == this.buttonResAnterior || o == this.buttonCampoExterno) {
                if (this.ultimoTextPane != null) {
                    String str = "";
                    str = o == this.buttonExpressao ? "[]" : (o == this.buttonBarras ? "{}" : (o == this.buttonResAnterior ? "\u00bf?" : "\u00b6|"));
                    int pos = this.ultimoTextPane.getCaretPosition();
                    this.ultimoTextPane.getDocument().insertString(pos, str, null);
                    this.ultimoTextPane.setCaretPosition(pos + 1);
                    if (o == this.buttonResAnterior) {
                        ScreenUtil.requisitarFoco(this.comboOrigem);
                    } else if (o == this.buttonCampoExterno) {
                        ScreenUtil.requisitarFoco(this.comboExternos);
                    } else {
                        ScreenUtil.requisitarFoco(this.textExpressao);
                    }
                    this.ultimoTextPane = null;
                }
            } else if (o == this.buttonOk || o == this.buttonCancelar) {
                boolean bl = this.ok = o == this.buttonOk;
                if (!this.ok || this.validarExpressoes()) {
                    this.dispose();
                }
            } else if (o == this.buttonExportar) {
                JFileChooser fc = ComponenteFactory.novoJFileChooser();
                fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Mapa", "map"));
                if (fc.showSaveDialog(this) == 0) {
                    StringUtil.escreverArquivoTexto(this.addExtensao(fc.getSelectedFile().getPath()), this.tipo == 1 ? this.getCabecalhoRodape() : this.getFormato());
                }
            } else if (o == this.buttonImportar) {
                JFileChooser fc = ComponenteFactory.novoJFileChooser();
                fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Mapa", "map"));
                if (fc.showOpenDialog(this) == 0) {
                    String tmp = StringUtil.lerArquivoTexto(fc.getSelectedFile().getPath());
                    if (this.tipo == 1) {
                        this.setCabecalhoRodape(tmp);
                    } else {
                        this.setFormato(tmp);
                    }
                }
            } else if (o == this.buttonBanco) {
                DialogoLista dl = DialogoLista.novaInstancia(this, "Campos do banco");
                dl.setItens(this.campos);
                dl.setVisible(true);
                if (dl.ok()) {
                    int pos = this.textExpressao.getCaretPosition();
                    this.textExpressao.getDocument().insertString(pos, dl.getItemSelecionado(), null);
                    this.textExpressao.requestFocus();
                }
            } else if (o == this.buttonNegrito || o == this.buttonItalico || o == this.buttonSublinhado || o == this.buttonSobrescrito || o == this.buttonSubscrito || o == this.buttonExpandido || o == this.buttonComprimido || o == this.buttonOitoLinhas) {
                if (this.ultimoTextPane != null) {
                    int end;
                    DocumentoMapa doc = (DocumentoMapa)this.ultimoTextPane.getDocument();
                    int start = this.ultimoTextPane.getSelectionStart();
                    if (start == (end = this.ultimoTextPane.getSelectionEnd()) || doc.contextoCampo(start) || doc.contextoCampo(end)) {
                        return;
                    }
                    int tipo = 0;
                    if (o == this.buttonNegrito) {
                        tipo = 0;
                    } else if (o == this.buttonItalico) {
                        tipo = 1;
                    } else if (o == this.buttonSublinhado) {
                        tipo = 2;
                    } else if (o == this.buttonSobrescrito) {
                        tipo = 3;
                    } else if (o == this.buttonSubscrito) {
                        tipo = 4;
                    } else if (o == this.buttonExpandido) {
                        tipo = 5;
                    } else if (o == this.buttonComprimido) {
                        tipo = 6;
                    } else if (o == this.buttonOitoLinhas) {
                        tipo = 7;
                    }
                    doc.aplicarAtributo(tipo, start, end);
                    this.ultimoTextPane.setSelectionStart(start);
                    this.ultimoTextPane.setSelectionEnd(end);
                }
            } else {
                DialogoFuncao df = this.getDialogo(o);
                if (df != null) {
                    df.setCamposBanco(this.campos);
                    df.setVisible(true);
                    if (df.ok()) {
                        this.textExpressao.getDocument().insertString(this.textExpressao.getCaretPosition(), df.getExpressao(), null);
                        this.textExpressao.requestFocus();
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EditorMapa: 356");
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            JTextPane text = (JTextPane)e.getSource();
            this.posCursor = text.getCaretPosition();
            if (!this.tratandoExpressao) {
                this.panelExpressao.removeAll();
                this.panelExpressao.setBorder(BorderFactory.createTitledBorder(" "));
                this.docSelecionado = (DocumentoMapa)text.getDocument();
                StyledDocument sdoc = this.docSelecionado.getDocumentoExpressao(this.posCursor);
                if (sdoc instanceof AbstractEstiloDocumento) {
                    AbstractEstiloDocumento absDoc = (AbstractEstiloDocumento)sdoc;
                    absDoc.setTextComponent(this.textExpressao);
                    this.textExpressao.setStyledDocument(absDoc);
                    this.panelExpressao.setLayout(this.borderLayout);
                    this.panelExpressao.add((Component)this.scrollExpressao, "Center");
                    this.panelExpressao.setBorder(BorderFactory.createTitledBorder("Express\u00e3o"));
                    absDoc.destacarTokens();
                }
                this.resAnteriorSelecionado = this.docSelecionado.getCampoResAnterior(this.posCursor);
                if (this.resAnteriorSelecionado != null) {
                    this.panelExpressao.setLayout(null);
                    this.panelExpressao.add(this.labelOrigem);
                    this.panelExpressao.add(this.comboOrigem);
                    this.panelExpressao.setBorder(BorderFactory.createTitledBorder("Resultado Anterior"));
                    this.comboOrigem.setActionCommand(COMBO_CANCELADO);
                    this.comboOrigem.setSelectedIndex(0);
                    this.comboOrigem.setSelectedItem(this.resAnteriorSelecionado.campo);
                    this.comboOrigem.setActionCommand(COMBO_OK);
                }
                this.externoSelecionado = this.docSelecionado.getCampoExterno(this.posCursor);
                if (this.externoSelecionado != null) {
                    this.panelExpressao.setLayout(null);
                    this.panelExpressao.add(this.labelExterno);
                    this.panelExpressao.add(this.comboExternos);
                    this.panelExpressao.setBorder(BorderFactory.createTitledBorder("Campos Externos"));
                    this.comboExternos.setActionCommand(COMBO_CANCELADO);
                    if (this.comboExternos.getItemCount() > 0) {
                        this.comboExternos.setSelectedIndex(0);
                        this.comboExternos.setSelectedItem(this.externoSelecionado.campo);
                    }
                    this.comboExternos.setActionCommand(COMBO_OK);
                }
                this.panelExpressao.revalidate();
                this.panelExpressao.repaint();
            }
            if (text.hasFocus()) {
                TitledBorder borda;
                int[] tmp = StringUtil.getLinhaColuna(text.getText(), this.posCursor, 10);
                if (text == this.textFormatoCabecalho) {
                    borda = (TitledBorder)this.panelFormatoCabecalho.getBorder();
                    borda.setTitle((this.tipo == 1 ? "Cabe\u00e7alho " : "Formato ") + "[" + tmp[0] + "," + tmp[1] + "]");
                    this.panelFormatoCabecalho.repaint();
                } else if (text == this.textRodape) {
                    borda = (TitledBorder)this.panelRodape.getBorder();
                    borda.setTitle("Rodap\u00e9 [" + tmp[0] + "," + tmp[1] + "]");
                    this.panelRodape.repaint();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EditorMapa: 412");
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object o = e.getSource();
        if (o == this.comboOrigem) {
            if (this.docSelecionado != null) {
                this.docSelecionado.selecionarResAnterior(this.posCursor);
            }
            this.tratandoExpressao = false;
            this.habilitarDesabilitar(false);
        } else if (o == this.comboExternos) {
            if (this.docSelecionado != null) {
                this.docSelecionado.selecionarCampoExterno(this.posCursor);
            }
            this.tratandoExpressao = false;
            this.habilitarDesabilitar(false);
        } else if (o == this.textExpressao) {
            if (this.docSelecionado != null) {
                this.tratandoExpressao = true;
                this.docSelecionado.selecionarCampoExpressao(this.posCursor);
            }
            this.habilitarDesabilitar(true);
        } else if (o == this.textFormatoCabecalho || o == this.textRodape) {
            JTextPane text = (JTextPane)o;
            int pos = text.getCaretPosition();
            if (this.docSelecionado != null) {
                this.docSelecionado.removerSelecao();
                text.setCaretPosition(pos);
            }
            this.tratandoExpressao = false;
            this.ultimoTextPane = text;
            this.habilitarDesabilitar(false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof JTextPane) {
            JTextPane text = (JTextPane)e.getSource();
            if (text == this.textFormatoCabecalho) {
                TitledBorder borda = (TitledBorder)this.panelFormatoCabecalho.getBorder();
                borda.setTitle(this.tipo == 1 ? "Cabe\u00e7alho" : "Formato");
                this.panelFormatoCabecalho.repaint();
            } else if (text == this.textRodape) {
                TitledBorder borda = (TitledBorder)this.panelRodape.getBorder();
                borda.setTitle("Rodap\u00e9");
                this.panelRodape.repaint();
            }
        }
    }

    public boolean validarExpressoes() throws Exception {
        int i;
        Object[] tmp = this.docFormatoCabecalho.getDocumentos();
        for (i = 0; i <= tmp.length - 2; i += 2) {
            if (this.validarDocumento(this.docFormatoCabecalho, tmp[i + 1], (Integer)tmp[i])) continue;
            return false;
        }
        tmp = this.docRodape.getDocumentos();
        for (i = 0; i <= tmp.length - 2; i += 2) {
            if (this.validarDocumento(this.docRodape, tmp[i + 1], (Integer)tmp[i])) continue;
            return false;
        }
        return true;
    }

    private boolean validarDocumento(DocumentoMapa docExp, Object doc, int pos) throws Exception {
        if (doc instanceof AbstractEstiloDocumento) {
            AbstractEstiloDocumento adoc = (AbstractEstiloDocumento)doc;
            Sintatico sin = new Sintatico();
            try {
                sin.analisar(adoc.getText(0, adoc.getLength()));
            }
            catch (ExpressaoException e) {
                if (this.docSelecionado != null) {
                    this.docSelecionado.removerSelecao();
                }
                this.textExpressao.setDocument(adoc);
                adoc.destacarErro(e.pos);
                adoc.addChangeListener(this.eventoErro);
                docExp.selecionarCampoExpressao(pos);
                this.labelErro.setText(" " + e.getMessage());
                this.textExpressao.setCaretPosition(e.pos);
                this.textExpressao.requestFocus();
                this.panelExpressao.revalidate();
                this.docSelecionado = docExp;
                return false;
            }
        }
        return true;
    }

    private void habilitarDesabilitar(boolean focoExpressao) {
        this.buttonBanco.setVisible(focoExpressao);
        this.buttonSe.setVisible(focoExpressao);
        this.buttonCopia.setVisible(focoExpressao);
        this.buttonVazio.setVisible(focoExpressao);
        this.buttonZero.setVisible(focoExpressao);
        this.buttonExtenso.setVisible(focoExpressao);
        this.buttonTamanho.setVisible(focoExpressao);
        this.buttonNumero.setVisible(focoExpressao);
        this.buttonData.setVisible(focoExpressao);
        this.buttonSomaData.setVisible(focoExpressao);
        this.buttonExpressao.setVisible(!focoExpressao);
        this.buttonBarras.setVisible(!focoExpressao);
        this.buttonResAnterior.setVisible(!focoExpressao);
        this.buttonCampoExterno.setVisible(!focoExpressao);
        this.buttonNegrito.setVisible(!focoExpressao);
        this.buttonItalico.setVisible(!focoExpressao);
        this.buttonSublinhado.setVisible(!focoExpressao);
        this.buttonSobrescrito.setVisible(!focoExpressao);
        this.buttonSubscrito.setVisible(!focoExpressao);
        this.buttonExpandido.setVisible(!focoExpressao);
        this.buttonComprimido.setVisible(!focoExpressao);
        this.buttonOitoLinhas.setVisible(!focoExpressao);
    }

    private void iniciar(int tipo) {
        JPanel panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.tipo = tipo;
        Font fonte = new Font("Monospaced", 0, 11);
        this.setSize(new Dimension(730, tipo == 1 ? 550 : 490));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelArea, "Center");
        this.getContentPane().add((Component)this.panelSul, "South");
        this.panelArea.add((Component)this.panelCentral, "Center");
        this.panelArea.add((Component)this.panelLeste, "East");
        this.panelArea.add((Component)this.labelErro, "South");
        this.panelCentral.add(this.panelFormatoCabecalho);
        if (tipo == 1) {
            this.textLinhas.setPreferredSize(new Dimension(70, 22));
            this.textColunas.setPreferredSize(new Dimension(70, 22));
            this.panelCentral.add((Component)this.labelLinhas, 0);
            this.panelCentral.add((Component)this.textLinhas, 1);
            this.panelCentral.add((Component)this.labelColunas, 2);
            this.panelCentral.add((Component)this.textColunas, 3);
            this.textRodape.setFont(fonte);
            this.textRodape.addFocusListener(this);
            this.textRodape.addCaretListener(this);
            this.panelRodape.setBorder(BorderFactory.createTitledBorder("Rodap\u00e9"));
            this.panelRodape.add((Component)new JScrollPane(this.textRodape), "Center");
            this.panelRodape.setPreferredSize(new Dimension(580, 140));
            this.panelCentral.add(this.panelRodape);
        }
        this.panelCentral.add(this.panelExpressao);
        this.panelLeste.setPreferredSize(new Dimension(120, 10));
        this.panelLeste.add(this.buttonBanco);
        this.panelLeste.add(this.buttonSe);
        this.panelLeste.add(this.buttonCopia);
        this.panelLeste.add(this.buttonVazio);
        this.panelLeste.add(this.buttonZero);
        this.panelLeste.add(this.buttonExtenso);
        this.panelLeste.add(this.buttonTamanho);
        this.panelLeste.add(this.buttonNumero);
        this.panelLeste.add(this.buttonData);
        this.panelLeste.add(this.buttonSomaData);
        this.panelLeste.add(this.buttonExpressao);
        this.panelLeste.add(this.buttonBarras);
        this.panelLeste.add(this.buttonResAnterior);
        this.panelLeste.add(this.buttonCampoExterno);
        this.panelLeste.add(this.buttonNegrito);
        this.panelLeste.add(this.buttonItalico);
        this.panelLeste.add(this.buttonSublinhado);
        this.panelLeste.add(this.buttonSobrescrito);
        this.panelLeste.add(this.buttonSubscrito);
        this.panelLeste.add(this.buttonExpandido);
        this.panelLeste.add(this.buttonComprimido);
        this.panelLeste.add(this.buttonOitoLinhas);
        this.panelSul.add((Component)panelAux, "East");
        this.panelSul.setBorder(BorderFactory.createEtchedBorder());
        panelAux.add(this.buttonOk);
        panelAux.add(this.buttonCancelar);
        panelAux = new JPanel(new FlowLayout(0, 3, 3));
        this.panelSul.add((Component)panelAux, "Center");
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonImportar);
        this.panelFormatoCabecalho.add((Component)new JScrollPane(this.textFormatoCabecalho), "Center");
        this.panelFormatoCabecalho.setPreferredSize(new Dimension(580, tipo == 0 ? 250 : 140));
        this.panelFormatoCabecalho.setBorder(BorderFactory.createTitledBorder(tipo == 0 ? "Formato" : "Cabe\u00e7alho"));
        this.panelExpressao.setPreferredSize(new Dimension(580, 140));
        this.panelExpressao.setBorder(BorderFactory.createTitledBorder(" "));
        this.textFormatoCabecalho.setFont(fonte);
        this.textFormatoCabecalho.addFocusListener(this);
        this.textFormatoCabecalho.addCaretListener(this);
        this.textExpressao.setFont(fonte);
        this.textExpressao.addFocusListener(this);
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonExportar.addActionListener(this);
        this.buttonImportar.addActionListener(this);
        this.labelErro.setForeground(Color.red);
        this.labelErro.setPreferredSize(new Dimension(10, 30));
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.labelOrigem.setBounds(10, 20, 60, 22);
        this.comboOrigem.setBounds(70, 20, 160, 22);
        this.comboOrigem.addFocusListener(this);
        this.comboOrigem.addActionListener(this);
        this.labelExterno.setBounds(10, 20, 110, 22);
        this.comboExternos.setBounds(120, 20, 160, 22);
        this.comboExternos.addFocusListener(this);
        this.comboExternos.addActionListener(this);
        Insets margens = new Insets(3, 3, 3, 3);
        Dimension tamanho = new Dimension(110, 25);
        Component[] c = this.panelLeste.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JButton b = (JButton)c[i];
            b.setMargin(margens);
            b.setPreferredSize(tamanho);
            b.setHorizontalAlignment(2);
            b.addActionListener(this);
        }
        this.habilitarDesabilitar(false);
    }

    private DialogoFuncao getDialogo(Object botao) {
        if (botao == this.buttonSe) {
            return DialogoFuncaoFactory.criarDialogoFuncao(0, this);
        }
        if (botao == this.buttonCopia) {
            return DialogoFuncaoFactory.criarDialogoFuncao(1, this);
        }
        if (botao == this.buttonVazio) {
            return DialogoFuncaoFactory.criarDialogoFuncao(2, this);
        }
        if (botao == this.buttonZero) {
            return DialogoFuncaoFactory.criarDialogoFuncao(3, this);
        }
        if (botao == this.buttonExtenso) {
            return DialogoFuncaoFactory.criarDialogoFuncao(4, this);
        }
        if (botao == this.buttonTamanho) {
            return DialogoFuncaoFactory.criarDialogoFuncao(5, this);
        }
        if (botao == this.buttonNumero) {
            return DialogoFuncaoFactory.criarDialogoFuncao(6, this);
        }
        if (botao == this.buttonData) {
            return DialogoFuncaoFactory.criarDialogoFuncao(7, this);
        }
        if (botao == this.buttonSomaData) {
            return DialogoFuncaoFactory.criarDialogoFuncao(8, this);
        }
        return null;
    }

    private String addExtensao(String arquivo) {
        if (arquivo != null && !arquivo.endsWith(".map")) {
            arquivo = arquivo + ".map";
        }
        return arquivo;
    }
}

