/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.util.StringUtil;
import jalis.util.impressao.matricial.EstiloDocumento;
import jalis.util.impressao.matricial.GerenciadorAtributos;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DocumentoRelatorio
extends DefaultStyledDocument {
    static final char ABRE_EXP = '[';
    static final char FECHA_EXP = ']';
    static final char ABRE_BAR = '{';
    static final char FECHA_BAR = '}';
    private ArrayList<Document> docs = new ArrayList();
    private GerenciadorAtributos gerenciador = new GerenciadorAtributos();
    private SimpleAttributeSet simples = new SimpleAttributeSet();

    public void setTexto(String txt) {
        if (txt != null) {
            try {
                StringBuilder bui = new StringBuilder();
                StringBuilder num = new StringBuilder();
                StringBuilder exp = new StringBuilder();
                StringBuilder lex = new StringBuilder();
                ArrayList<int[]> arr = new ArrayList<int[]>();
                Estados estado = Estados.q0;
                int contador = 0;
                boolean onOff = true;
                this.docs.clear();
                this.gerenciador.limpar();
                block10: for (int i = 0; i < txt.length(); ++i) {
                    char ch = txt.charAt(i);
                    switch (estado) {
                        case q0: {
                            if (ch == '\\') {
                                estado = Estados.q1;
                                continue block10;
                            }
                            if (ch == '<') {
                                estado = Estados.q2;
                                onOff = true;
                                lex.delete(0, lex.length());
                                continue block10;
                            }
                            if (ch == '[') {
                                estado = Estados.q3;
                            } else if (ch == '{') {
                                estado = Estados.q5;
                            }
                            if (ch == '[' || ch == '{') {
                                (ch == '{' ? exp : num).delete(0, (ch == '{' ? exp : num).length());
                            } else {
                                ++contador;
                            }
                            bui.append(ch);
                            continue block10;
                        }
                        case q1: {
                            estado = Estados.q0;
                            bui.append(ch);
                            ++contador;
                            continue block10;
                        }
                        case q2: {
                            if (ch == '/') {
                                onOff = false;
                                lex.delete(0, lex.length());
                                continue block10;
                            }
                            if (ch == '>') {
                                estado = Estados.q0;
                                if (onOff) {
                                    arr.add(new int[]{this.gerenciador.getTipo(lex.toString()), contador, -1});
                                    continue block10;
                                }
                                int tipo = this.gerenciador.getTipo(lex.toString());
                                int[][] ints = (int[][])arr.toArray((T[])new int[arr.size()][]);
                                for (int j = 0; j < ints.length; ++j) {
                                    if (ints[j][0] != tipo) continue;
                                    this.gerenciador.setAtributo(tipo, ints[j][1], contador);
                                    arr.remove(ints[j]);
                                    continue block10;
                                }
                                continue block10;
                            }
                            lex.append(ch);
                            continue block10;
                        }
                        case q3: {
                            if (ch == '!') {
                                estado = Estados.q4;
                                exp.delete(0, exp.length());
                                continue block10;
                            }
                            num.append(ch);
                            continue block10;
                        }
                        case q4: {
                            if (ch == ']') {
                                estado = Estados.q0;
                                int size = Integer.parseInt(num.toString());
                                bui.append(StringUtil.repeteCaractere(' ', size - 2)).append(']');
                                this.docs.add(new EstiloDocumento(exp.toString()));
                                contador += size;
                                continue block10;
                            }
                            exp.append(ch);
                            continue block10;
                        }
                        case q5: {
                            if (ch == '}') {
                                estado = Estados.q0;
                                bui.append(ch);
                                this.docs.add(new EstiloDocumento(exp.toString()));
                                contador += 2;
                                continue block10;
                            }
                            exp.append(ch);
                        }
                    }
                }
                super.remove(0, this.getLength());
                super.insertString(0, bui.toString(), this.simples);
                this.atualizarAtributos();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 176");
            }
        }
    }

    public String getTexto() {
        StringBuilder bui = new StringBuilder();
        try {
            boolean exp;
            String str = this.getText(0, this.getLength());
            int[][] atr = this.gerenciador.getAtributos();
            int[] pos = this.gerenciador.getPosicoes();
            int aux = 0;
            for (int i = 0; i < pos.length; ++i) {
                bui.append(this.trataCaracteres(str.substring(aux, pos[i])));
                bui.append(this.getTags(pos[i], atr));
                aux = pos[i];
            }
            bui.append(this.trataCaracteres(str.substring(aux, str.length())));
            str = bui.toString();
            bui.delete(0, bui.length());
            aux = 0;
            int abre = this.min(str.indexOf(91), str.indexOf(123));
            int fecha = this.min(str.indexOf(93), str.indexOf(125));
            int posExp = 0;
            boolean posRes = false;
            boolean posExt = false;
            boolean bl = exp = abre == str.indexOf(91);
            while (abre > -1 && abre < fecha) {
                bui.append(str.substring(aux, abre + 1));
                if (exp) {
                    bui.append(fecha - abre + 1);
                    bui.append('!');
                }
                bui.append(this.docs.get(posExp).getText(0, this.docs.get(posExp).getLength()));
                bui.append(exp ? (char)']' : '}');
                ++posExp;
                int[] nArray = new int[2];
                aux = fecha + 1;
                nArray[0] = str.indexOf(91, aux);
                nArray[1] = str.indexOf(123, aux);
                abre = this.min(nArray);
                fecha = this.min(str.indexOf(93, aux), str.indexOf(125, aux));
                exp = abre == str.indexOf(91, aux);
            }
            bui.append(str.substring(aux, str.length()));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 237");
        }
        return bui.toString();
    }

    private int min(int ... nuns) {
        int menor = -1;
        for (int n : nuns) {
            if (menor != -1 && (n <= -1 || n >= menor)) continue;
            menor = n;
        }
        return menor;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet atr) throws BadLocationException {
        boolean exp = this.contexto(offs, '[', ']');
        boolean bar = this.contexto(offs, '{', '}');
        if (!exp && !bar && this.validarEntrada(str) || exp && str.matches("[ |\\]]+") || bar && str.matches("[\\}]+")) {
            super.insertString(offs, str, this.gerenciador.getAtributoIntervalo(offs - 1, offs));
            this.gerenciador.inserirIntervalo(offs, offs + str.length());
            this.tratarInsercao(offs, str);
        }
    }

    private String trataCaracteres(String str) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\' || str.charAt(i) == '<' || str.charAt(i) == '>') {
                bui.append('\\');
            }
            bui.append(str.charAt(i));
        }
        return bui.toString();
    }

    private boolean validarEntrada(String str) {
        boolean retorno = true;
        boolean abertoExp = false;
        boolean abertoBar = false;
        boolean abertoRes = false;
        boolean abertoExt = false;
        for (int i = 0; i < str.length() && retorno; ++i) {
            char ch = str.charAt(i);
            if (abertoExp || abertoBar || abertoRes || abertoExt) {
                if (ch == ']') {
                    abertoExp = abertoBar || abertoRes || abertoExt;
                    retorno = !abertoExp;
                    continue;
                }
                if (ch == '}') {
                    abertoBar = abertoExp || abertoRes || abertoExt;
                    retorno = !abertoBar;
                    continue;
                }
                retorno = Character.isSpaceChar(ch);
                continue;
            }
            retorno = ch != ']' && ch != '}';
            abertoExp = ch == '[';
            abertoBar = ch == '{';
        }
        return retorno;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        this.tratarRemocao(offs, this.getText(offs, len));
        super.remove(offs, len);
        this.gerenciador.removerIntervalo(offs, offs + len);
        int[][] tmp = this.getColchetesChaves();
        if (tmp.length > this.docs.size()) {
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i][0] >= offs || offs > tmp[i][1]) continue;
                this.docs.add(i, new EstiloDocumento());
                break;
            }
        }
    }

    public void aplicarAtributo(int tipo, int posIni, int posFin) {
        try {
            this.gerenciador.setAtributo(tipo, posIni, posFin);
            this.setCharacterAttributes(0, this.getLength(), this.simples, true);
            this.atualizarAtributos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 378");
        }
    }

    public Object[] getDocumentos() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        int[][] colchetes = this.getColchetesChaves();
        for (int i = 0; i < colchetes.length; ++i) {
            if (i >= this.docs.size()) continue;
            tmp.add(new Integer(colchetes[i][0] + 1));
            tmp.add(this.docs.get(i));
        }
        return tmp.toArray();
    }

    public StyledDocument getDocumentoExpressao(int pos) {
        int i = this.getIndiceCampoBarraExpressao(pos);
        if (i > -1 && i < this.docs.size()) {
            return (StyledDocument)this.docs.get(i);
        }
        return null;
    }

    public void selecionarCampoExpressao(int pos) {
        try {
            int[][] tmp = this.getColchetesChaves();
            for (int i = 0; i < tmp.length; ++i) {
                if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
                MutableAttributeSet selecionado = this.gerenciador.getAtributoIntervalo(tmp[i][0], tmp[i][1]);
                StyleConstants.setBackground(selecionado, Color.blue);
                StyleConstants.setForeground(selecionado, Color.white);
                this.setCharacterAttributes(tmp[i][0], tmp[i][1] - tmp[i][0] + 1, selecionado, true);
                break;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 451");
        }
    }

    public void removerSelecao() {
        try {
            this.setCharacterAttributes(0, this.getLength(), this.simples, true);
            this.atualizarAtributos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 487");
        }
    }

    public boolean contextoCampo(int pos) {
        return this.contexto(pos, '[', ']') || this.contexto(pos, '{', '}');
    }

    private boolean contexto(int pos, char abre, char fecha) {
        boolean res = false;
        try {
            String str = this.getText(0, this.getLength());
            for (int i = 0; i < str.length() && i < pos; ++i) {
                if (str.charAt(i) == abre) {
                    res = true;
                    continue;
                }
                if (str.charAt(i) != fecha) continue;
                res = false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 521");
        }
        return res;
    }

    private void atualizarAtributos() {
        int[] pos = this.gerenciador.getPosicoes();
        for (int i = 1; i < pos.length; ++i) {
            int a = pos[i - 1];
            int b = pos[i];
            this.setCharacterAttributes(a, b - a, this.gerenciador.getAtributoIntervalo(a, b), true);
        }
    }

    private String getTags(int pos, int[][] atributos) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < atributos.length; ++i) {
            if (pos != atributos[i][1] && pos != atributos[i][2]) continue;
            bui.append("<");
            if (pos == atributos[i][2]) {
                bui.append("/");
            }
            bui.append(this.gerenciador.getLexema(atributos[i][0]));
            bui.append(">");
        }
        return bui.toString();
    }

    private void tratarInsercao(int pos, String str) {
        int abre = 0;
        boolean abreRes = false;
        boolean abreExt = false;
        for (int i = 0; i < str.length(); ++i) {
            int tmp;
            char ch = str.charAt(i);
            if (ch == '[' || ch == '{') {
                ++abre;
                tmp = this.getIndiceCampoBarraExpressao(pos + i + 1);
                if (tmp <= -1) continue;
                this.docs.add(tmp, new EstiloDocumento());
                continue;
            }
            if (ch != ']' && ch != '}') continue;
            if (abre == 0) {
                tmp = this.getIndiceCampoBarraExpressao(pos + i);
                if (tmp <= -1) continue;
                this.docs.add(tmp, new EstiloDocumento());
                continue;
            }
            --abre;
        }
    }

    private void tratarRemocao(int pos, String str) {
        int abre = 0;
        boolean abreRes = false;
        boolean abreExt = false;
        int indiceOff = 0;
        boolean indiceOffRes = false;
        boolean indiceOffExt = false;
        for (int i = 0; i < str.length(); ++i) {
            int indice;
            char ch = str.charAt(i);
            if (ch == '[' || ch == '{') {
                ++abre;
                indice = this.getIndiceCampoBarraExpressao(pos + i + 1);
                if (indice <= -1) continue;
                this.docs.remove(indice - indiceOff);
                ++indiceOff;
                continue;
            }
            if (ch != ']' && ch != '}') continue;
            if (abre == 0) {
                indice = this.getIndiceCampoBarraExpressao(pos + i);
                if (indice <= -1) continue;
                this.docs.remove(indice - indiceOff);
                ++indiceOff;
                continue;
            }
            --abre;
        }
    }

    private int getIndiceCampoBarraExpressao(int pos) {
        int[][] tmp = this.getColchetesChaves();
        for (int i = 0; i < tmp.length; ++i) {
            if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
            return i;
        }
        return -1;
    }

    private int[][] getColchetesChaves() {
        ArrayList<int[]> colCha = new ArrayList<int[]>();
        try {
            boolean q0 = false;
            boolean q1 = true;
            boolean estado = false;
            int abre = 0;
            String str = this.getText(0, this.getLength());
            for (int i = 0; i < str.length(); ++i) {
                if (!estado) {
                    if (str.charAt(i) != '[' && str.charAt(i) != '{') continue;
                    abre = i;
                    estado = true;
                    continue;
                }
                if (!estado) continue;
                if (str.charAt(i) == '[' || str.charAt(i) == '{') {
                    abre = i;
                    continue;
                }
                if (str.charAt(i) != ']' && str.charAt(i) != '}') continue;
                colCha.add(new int[]{abre, i});
                estado = false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoRelatorio: 726");
        }
        return (int[][])colCha.toArray((T[])new int[colCha.size()][]);
    }

    private static enum Estados {
        q0,
        q1,
        q2,
        q3,
        q4,
        q5;

    }
}

