/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.util.StringUtil;
import jalis.util.impressao.matricial.Campo;
import jalis.util.impressao.matricial.EstiloDocumento;
import jalis.util.impressao.matricial.GerenciadorAtributos;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DocumentoMapa
extends DefaultStyledDocument {
    static final char ABRE_RES = '\u00bf';
    static final char FECHA_RES = '?';
    static final char ABRE_EXP = '[';
    static final char FECHA_EXP = ']';
    static final char ABRE_BAR = '{';
    static final char FECHA_BAR = '}';
    static final char ABRE_EXT = '\u00b6';
    static final char FECHA_EXT = '|';
    private ArrayList<Document> docs = new ArrayList();
    private ArrayList<Campo> resAnteriores = new ArrayList();
    private ArrayList<Campo> externos = new ArrayList();
    private GerenciadorAtributos gerenciador = new GerenciadorAtributos();
    private SimpleAttributeSet simples = new SimpleAttributeSet();

    public void setTexto(String txt) {
        if (txt != null) {
            try {
                StringBuilder bui = new StringBuilder();
                StringBuilder num = new StringBuilder();
                StringBuilder exp = new StringBuilder();
                StringBuilder lex = new StringBuilder();
                ArrayList<int[]> arr = new ArrayList<int[]>();
                Estados estado = Estados.q0;
                int contador = 0;
                boolean onOff = true;
                this.docs.clear();
                this.gerenciador.limpar();
                block14: for (int i = 0; i < txt.length(); ++i) {
                    char ch = txt.charAt(i);
                    switch (estado) {
                        case q0: {
                            if (ch == '\\') {
                                estado = Estados.q1;
                                continue block14;
                            }
                            if (ch == '<') {
                                estado = Estados.q2;
                                onOff = true;
                                lex.delete(0, lex.length());
                                continue block14;
                            }
                            if (ch == '[') {
                                estado = Estados.q3;
                            } else if (ch == '{') {
                                estado = Estados.q5;
                            } else if (ch == '\u00bf') {
                                estado = Estados.q6;
                            } else if (ch == '\u00b6') {
                                estado = Estados.q8;
                            }
                            if (ch == '[' || ch == '{' || ch == '\u00bf' || ch == '\u00b6') {
                                (ch == '{' ? exp : num).delete(0, (ch == '{' ? exp : num).length());
                            } else {
                                ++contador;
                            }
                            bui.append(ch);
                            continue block14;
                        }
                        case q1: {
                            estado = Estados.q0;
                            bui.append(ch);
                            ++contador;
                            continue block14;
                        }
                        case q2: {
                            if (ch == '/') {
                                onOff = false;
                                lex.delete(0, lex.length());
                                continue block14;
                            }
                            if (ch == '>') {
                                estado = Estados.q0;
                                if (onOff) {
                                    arr.add(new int[]{this.gerenciador.getTipo(lex.toString()), contador, -1});
                                    continue block14;
                                }
                                int tipo = this.gerenciador.getTipo(lex.toString());
                                int[][] ints = (int[][])arr.toArray((T[])new int[arr.size()][]);
                                for (int j = 0; j < ints.length; ++j) {
                                    if (ints[j][0] != tipo) continue;
                                    this.gerenciador.setAtributo(tipo, ints[j][1], contador);
                                    arr.remove(ints[j]);
                                    continue block14;
                                }
                                continue block14;
                            }
                            lex.append(ch);
                            continue block14;
                        }
                        case q3: {
                            if (ch == '!') {
                                estado = Estados.q4;
                                exp.delete(0, exp.length());
                                continue block14;
                            }
                            num.append(ch);
                            continue block14;
                        }
                        case q4: {
                            int size;
                            if (ch == ']') {
                                estado = Estados.q0;
                                size = Integer.parseInt(num.toString());
                                bui.append(StringUtil.repeteCaractere(' ', size - 2)).append(']');
                                this.docs.add(new EstiloDocumento(exp.toString()));
                                contador += size;
                                continue block14;
                            }
                            exp.append(ch);
                            continue block14;
                        }
                        case q5: {
                            if (ch == '}') {
                                estado = Estados.q0;
                                bui.append(ch);
                                this.docs.add(new EstiloDocumento(exp.toString()));
                                contador += 2;
                                continue block14;
                            }
                            exp.append(ch);
                            continue block14;
                        }
                        case q6: {
                            if (ch == '!') {
                                estado = Estados.q7;
                                exp.delete(0, exp.length());
                                continue block14;
                            }
                            num.append(ch);
                            continue block14;
                        }
                        case q7: {
                            int size;
                            if (ch == '?') {
                                estado = Estados.q0;
                                size = Integer.parseInt(num.toString());
                                bui.append(StringUtil.repeteCaractere(' ', size - 2)).append('?');
                                this.resAnteriores.add(new Campo(exp.toString()));
                                contador += size;
                                continue block14;
                            }
                            exp.append(ch);
                            continue block14;
                        }
                        case q8: {
                            if (ch == '!') {
                                estado = Estados.q9;
                                exp.delete(0, exp.length());
                                continue block14;
                            }
                            num.append(ch);
                            continue block14;
                        }
                        case q9: {
                            int size;
                            if (ch == '|') {
                                estado = Estados.q0;
                                size = Integer.parseInt(num.toString());
                                bui.append(StringUtil.repeteCaractere(' ', size - 2)).append('|');
                                this.externos.add(new Campo(exp.toString()));
                                contador += size;
                                continue block14;
                            }
                            exp.append(ch);
                        }
                    }
                }
                super.remove(0, this.getLength());
                super.insertString(0, bui.toString(), this.simples);
                this.atualizarAtributos();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 176");
            }
        }
    }

    public String getTexto() {
        StringBuilder bui = new StringBuilder();
        try {
            boolean ext;
            String str = this.getText(0, this.getLength());
            int[][] atr = this.gerenciador.getAtributos();
            int[] pos = this.gerenciador.getPosicoes();
            int aux = 0;
            for (int i = 0; i < pos.length; ++i) {
                bui.append(this.trataCaracteres(str.substring(aux, pos[i])));
                bui.append(this.getTags(pos[i], atr));
                aux = pos[i];
            }
            bui.append(this.trataCaracteres(str.substring(aux, str.length())));
            str = bui.toString();
            bui.delete(0, bui.length());
            aux = 0;
            int abre = this.min(str.indexOf(91), str.indexOf(123), str.indexOf(191), str.indexOf(182));
            int fecha = this.min(str.indexOf(93), str.indexOf(125), str.indexOf(63), str.indexOf(124));
            int posExp = 0;
            int posRes = 0;
            int posExt = 0;
            boolean exp = abre == str.indexOf(91);
            boolean res = abre == str.indexOf(191);
            boolean bl = ext = abre == str.indexOf(182);
            while (abre > -1 && abre < fecha) {
                bui.append(str.substring(aux, abre + 1));
                if (res || ext) {
                    bui.append(fecha - abre + 1);
                    bui.append('!');
                    bui.append(res ? this.resAnteriores.get((int)posRes).campo : this.externos.get((int)posExt).campo);
                    bui.append(res ? (char)'?' : '|');
                    if (res) {
                        ++posRes;
                    } else {
                        ++posExt;
                    }
                } else {
                    if (exp) {
                        bui.append(fecha - abre + 1);
                        bui.append('!');
                    }
                    bui.append(this.docs.get(posExp).getText(0, this.docs.get(posExp).getLength()));
                    bui.append(exp ? (char)']' : '}');
                    ++posExp;
                }
                int[] nArray = new int[4];
                aux = fecha + 1;
                nArray[0] = str.indexOf(91, aux);
                nArray[1] = str.indexOf(123, aux);
                nArray[2] = str.indexOf(191, aux);
                nArray[3] = str.indexOf(182, aux);
                abre = this.min(nArray);
                fecha = this.min(str.indexOf(93, aux), str.indexOf(125, aux), str.indexOf(63, aux), str.indexOf(124, aux));
                exp = abre == str.indexOf(91, aux);
                res = abre == str.indexOf(191, aux);
                ext = abre == str.indexOf(182, aux);
            }
            bui.append(str.substring(aux, str.length()));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 237");
        }
        return bui.toString();
    }

    private int min(int ... nuns) {
        int menor = -1;
        for (int n : nuns) {
            if (menor != -1 && (n <= -1 || n >= menor)) continue;
            menor = n;
        }
        return menor;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet atr) throws BadLocationException {
        boolean exp = this.contexto(offs, '[', ']');
        boolean bar = this.contexto(offs, '{', '}');
        boolean res = this.contexto(offs, '\u00bf', '?');
        boolean ext = this.contexto(offs, '\u00b6', '|');
        if (!exp && !bar && !res && !ext && this.validarEntrada(str) || exp && str.matches("[ |\\]]+") || bar && str.matches("[\\}]+") || res && str.matches("[ |\\?]+") || ext && str.matches("[ |\\|]+")) {
            super.insertString(offs, str, this.gerenciador.getAtributoIntervalo(offs - 1, offs));
            this.gerenciador.inserirIntervalo(offs, offs + str.length());
            this.tratarInsercao(offs, str);
        }
    }

    private String trataCaracteres(String str) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\' || str.charAt(i) == '<' || str.charAt(i) == '>') {
                bui.append('\\');
            }
            bui.append(str.charAt(i));
        }
        return bui.toString();
    }

    private boolean validarEntrada(String str) {
        boolean retorno = true;
        boolean abertoExp = false;
        boolean abertoBar = false;
        boolean abertoRes = false;
        boolean abertoExt = false;
        for (int i = 0; i < str.length() && retorno; ++i) {
            char ch = str.charAt(i);
            if (abertoExp || abertoBar || abertoRes || abertoExt) {
                if (ch == ']') {
                    abertoExp = abertoBar || abertoRes || abertoExt;
                    retorno = !abertoExp;
                    continue;
                }
                if (ch == '}') {
                    abertoBar = abertoExp || abertoRes || abertoExt;
                    retorno = !abertoBar;
                    continue;
                }
                if (ch == '?') {
                    abertoRes = abertoExp || abertoBar || abertoExt;
                    retorno = !abertoRes;
                    continue;
                }
                if (ch == '|') {
                    abertoExt = abertoExp || abertoBar || abertoRes;
                    retorno = !abertoExt;
                    continue;
                }
                retorno = Character.isSpaceChar(ch);
                continue;
            }
            retorno = ch != ']' && ch != '}' && ch != '?' && ch != '|';
            abertoExp = ch == '[';
            abertoBar = ch == '{';
            abertoRes = ch == '\u00bf';
            abertoExt = ch == '\u00b6';
        }
        return retorno;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        int i;
        this.tratarRemocao(offs, this.getText(offs, len));
        super.remove(offs, len);
        this.gerenciador.removerIntervalo(offs, offs + len);
        int[][] tmp = this.getColchetesChaves();
        if (tmp.length > this.docs.size()) {
            for (i = 0; i < tmp.length; ++i) {
                if (tmp[i][0] >= offs || offs > tmp[i][1]) continue;
                this.docs.add(i, new EstiloDocumento());
                break;
            }
        }
        if ((tmp = this.getResultadosAnteriores()).length > this.resAnteriores.size()) {
            for (i = 0; i < tmp.length; ++i) {
                if (tmp[i][0] >= offs || offs > tmp[i][1]) continue;
                this.resAnteriores.add(i, new Campo(""));
                break;
            }
        }
        if ((tmp = this.getCamposExternos()).length > this.externos.size()) {
            for (i = 0; i < tmp.length; ++i) {
                if (tmp[i][0] >= offs || offs > tmp[i][1]) continue;
                this.externos.add(i, new Campo(""));
                break;
            }
        }
    }

    public void aplicarAtributo(int tipo, int posIni, int posFin) {
        try {
            this.gerenciador.setAtributo(tipo, posIni, posFin);
            this.setCharacterAttributes(0, this.getLength(), this.simples, true);
            this.atualizarAtributos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 378");
        }
    }

    public Object[] getDocumentos() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        int[][] colchetes = this.getColchetesChaves();
        for (int i = 0; i < colchetes.length; ++i) {
            if (i >= this.docs.size()) continue;
            tmp.add(new Integer(colchetes[i][0] + 1));
            tmp.add(this.docs.get(i));
        }
        return tmp.toArray();
    }

    public StyledDocument getDocumentoExpressao(int pos) {
        int i = this.getIndiceCampoBarraExpressao(pos);
        if (i > -1 && i < this.docs.size()) {
            return (StyledDocument)this.docs.get(i);
        }
        return null;
    }

    Campo getCampoResAnterior(int pos) {
        int i = this.getIndiceResultadoAnterior(pos);
        if (i > -1 && i < this.resAnteriores.size()) {
            return this.resAnteriores.get(i);
        }
        return null;
    }

    Campo getCampoExterno(int pos) {
        int i = this.getIndiceCampoExterno(pos);
        if (i > -1 && i < this.externos.size()) {
            return this.externos.get(i);
        }
        return null;
    }

    public void selecionarCampoExpressao(int pos) {
        try {
            int[][] tmp = this.getColchetesChaves();
            for (int i = 0; i < tmp.length; ++i) {
                if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
                MutableAttributeSet selecionado = this.gerenciador.getAtributoIntervalo(tmp[i][0], tmp[i][1]);
                StyleConstants.setBackground(selecionado, Color.blue);
                StyleConstants.setForeground(selecionado, Color.white);
                this.setCharacterAttributes(tmp[i][0], tmp[i][1] - tmp[i][0] + 1, selecionado, true);
                break;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 451");
        }
    }

    public void selecionarResAnterior(int pos) {
        try {
            int[][] tmp = this.getResultadosAnteriores();
            for (int i = 0; i < tmp.length; ++i) {
                if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
                MutableAttributeSet selecionado = this.gerenciador.getAtributoIntervalo(tmp[i][0], tmp[i][1]);
                StyleConstants.setBackground(selecionado, Color.blue);
                StyleConstants.setForeground(selecionado, Color.white);
                this.setCharacterAttributes(tmp[i][0], tmp[i][1] - tmp[i][0] + 1, selecionado, true);
                break;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 474");
        }
    }

    public void selecionarCampoExterno(int pos) {
        try {
            int[][] tmp = this.getCamposExternos();
            for (int i = 0; i < tmp.length; ++i) {
                if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
                MutableAttributeSet selecionado = this.gerenciador.getAtributoIntervalo(tmp[i][0], tmp[i][1]);
                StyleConstants.setBackground(selecionado, Color.blue);
                StyleConstants.setForeground(selecionado, Color.white);
                this.setCharacterAttributes(tmp[i][0], tmp[i][1] - tmp[i][0] + 1, selecionado, true);
                break;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 474");
        }
    }

    public void removerSelecao() {
        try {
            this.setCharacterAttributes(0, this.getLength(), this.simples, true);
            this.atualizarAtributos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 487");
        }
    }

    public boolean contextoCampo(int pos) {
        return this.contexto(pos, '[', ']') || this.contexto(pos, '{', '}') || this.contexto(pos, '\u00bf', '?') || this.contexto(pos, '\u00b6', '|');
    }

    private boolean contexto(int pos, char abre, char fecha) {
        boolean res = false;
        try {
            String str = this.getText(0, this.getLength());
            for (int i = 0; i < str.length() && i < pos; ++i) {
                if (str.charAt(i) == abre) {
                    res = true;
                    continue;
                }
                if (str.charAt(i) != fecha) continue;
                res = false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 521");
        }
        return res;
    }

    private void atualizarAtributos() {
        int[] pos = this.gerenciador.getPosicoes();
        for (int i = 1; i < pos.length; ++i) {
            int a = pos[i - 1];
            int b = pos[i];
            this.setCharacterAttributes(a, b - a, this.gerenciador.getAtributoIntervalo(a, b), true);
        }
    }

    private String getTags(int pos, int[][] atributos) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < atributos.length; ++i) {
            if (pos != atributos[i][1] && pos != atributos[i][2]) continue;
            bui.append("<");
            if (pos == atributos[i][2]) {
                bui.append("/");
            }
            bui.append(this.gerenciador.getLexema(atributos[i][0]));
            bui.append(">");
        }
        return bui.toString();
    }

    private void tratarInsercao(int pos, String str) {
        int abre = 0;
        int abreRes = 0;
        int abreExt = 0;
        for (int i = 0; i < str.length(); ++i) {
            int tmp;
            char ch = str.charAt(i);
            if (ch == '[' || ch == '{') {
                ++abre;
                tmp = this.getIndiceCampoBarraExpressao(pos + i + 1);
                if (tmp > -1) {
                    this.docs.add(tmp, new EstiloDocumento());
                }
            } else if (ch == ']' || ch == '}') {
                if (abre == 0) {
                    tmp = this.getIndiceCampoBarraExpressao(pos + i);
                    if (tmp > -1) {
                        this.docs.add(tmp, new EstiloDocumento());
                    }
                } else {
                    --abre;
                }
            }
            if (ch == '\u00bf') {
                ++abreRes;
                tmp = this.getIndiceResultadoAnterior(pos + i + 1);
                if (tmp > -1) {
                    this.resAnteriores.add(tmp, new Campo(""));
                }
            } else if (ch == '?') {
                if (abreRes == 0) {
                    tmp = this.getIndiceResultadoAnterior(pos + i);
                    if (tmp > -1) {
                        this.resAnteriores.add(tmp, new Campo(""));
                    }
                } else {
                    --abreRes;
                }
            }
            if (ch == '\u00b6') {
                ++abreExt;
                tmp = this.getIndiceCampoExterno(pos + i + 1);
                if (tmp <= -1) continue;
                this.externos.add(tmp, new Campo(""));
                continue;
            }
            if (ch != '|') continue;
            if (abreExt == 0) {
                tmp = this.getIndiceCampoExterno(pos + i);
                if (tmp <= -1) continue;
                this.externos.add(tmp, new Campo(""));
                continue;
            }
            --abreExt;
        }
    }

    private void tratarRemocao(int pos, String str) {
        int abre = 0;
        int abreRes = 0;
        int abreExt = 0;
        int indiceOff = 0;
        int indiceOffRes = 0;
        int indiceOffExt = 0;
        for (int i = 0; i < str.length(); ++i) {
            int indice;
            char ch = str.charAt(i);
            if (ch == '[' || ch == '{') {
                ++abre;
                indice = this.getIndiceCampoBarraExpressao(pos + i + 1);
                if (indice > -1) {
                    this.docs.remove(indice - indiceOff);
                    ++indiceOff;
                }
            } else if (ch == ']' || ch == '}') {
                if (abre == 0) {
                    indice = this.getIndiceCampoBarraExpressao(pos + i);
                    if (indice > -1) {
                        this.docs.remove(indice - indiceOff);
                        ++indiceOff;
                    }
                } else {
                    --abre;
                }
            }
            if (ch == '\u00bf') {
                ++abreRes;
                indice = this.getIndiceResultadoAnterior(pos + i + 1);
                if (indice > -1) {
                    this.resAnteriores.remove(indice - indiceOffRes);
                    ++indiceOffRes;
                }
            } else if (ch == '?') {
                if (abreRes == 0) {
                    indice = this.getIndiceResultadoAnterior(pos + i);
                    if (indice > -1) {
                        this.resAnteriores.remove(indice - indiceOffRes);
                        ++indiceOffRes;
                    }
                } else {
                    --abreRes;
                }
            }
            if (ch == '\u00b6') {
                ++abreExt;
                indice = this.getIndiceCampoExterno(pos + i + 1);
                if (indice <= -1) continue;
                this.externos.remove(indice - indiceOffExt);
                ++indiceOffExt;
                continue;
            }
            if (ch != '|') continue;
            if (abreExt == 0) {
                indice = this.getIndiceCampoExterno(pos + i);
                if (indice <= -1) continue;
                this.externos.remove(indice - indiceOffExt);
                ++indiceOffExt;
                continue;
            }
            --abreExt;
        }
    }

    private int getIndiceCampoBarraExpressao(int pos) {
        int[][] tmp = this.getColchetesChaves();
        for (int i = 0; i < tmp.length; ++i) {
            if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
            return i;
        }
        return -1;
    }

    private int getIndiceResultadoAnterior(int pos) {
        int[][] tmp = this.getResultadosAnteriores();
        for (int i = 0; i < tmp.length; ++i) {
            if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
            return i;
        }
        return -1;
    }

    private int getIndiceCampoExterno(int pos) {
        int[][] tmp = this.getCamposExternos();
        for (int i = 0; i < tmp.length; ++i) {
            if (pos <= tmp[i][0] || pos > tmp[i][1]) continue;
            return i;
        }
        return -1;
    }

    private int[][] getColchetesChaves() {
        ArrayList<int[]> colCha = new ArrayList<int[]>();
        try {
            boolean q0 = false;
            boolean q1 = true;
            boolean estado = false;
            int abre = 0;
            String str = this.getText(0, this.getLength());
            for (int i = 0; i < str.length(); ++i) {
                if (!estado) {
                    if (str.charAt(i) != '[' && str.charAt(i) != '{') continue;
                    abre = i;
                    estado = true;
                    continue;
                }
                if (!estado) continue;
                if (str.charAt(i) == '[' || str.charAt(i) == '{') {
                    abre = i;
                    continue;
                }
                if (str.charAt(i) != ']' && str.charAt(i) != '}') continue;
                colCha.add(new int[]{abre, i});
                estado = false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 726");
        }
        return (int[][])colCha.toArray((T[])new int[colCha.size()][]);
    }

    private int[][] getCamposExternos() {
        ArrayList<int[]> ext = new ArrayList<int[]>();
        try {
            String str = this.getText(0, this.getLength());
            boolean aberto = false;
            int pos = 0;
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (!aberto && ch == '\u00b6') {
                    pos = i;
                    aberto = true;
                    continue;
                }
                if (!aberto) continue;
                if (ch == '\u00b6') {
                    pos = i;
                    continue;
                }
                if (ch != '|') continue;
                ext.add(new int[]{pos, i});
                aberto = false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 708");
        }
        return (int[][])ext.toArray((T[])new int[ext.size()][]);
    }

    private int[][] getResultadosAnteriores() {
        ArrayList<int[]> res = new ArrayList<int[]>();
        try {
            String str = this.getText(0, this.getLength());
            boolean aberto = false;
            int pos = 0;
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (!aberto && ch == '\u00bf') {
                    pos = i;
                    aberto = true;
                    continue;
                }
                if (!aberto) continue;
                if (ch == '\u00bf') {
                    pos = i;
                    continue;
                }
                if (ch != '?') continue;
                res.add(new int[]{pos, i});
                aberto = false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoMapa: 763");
        }
        return (int[][])res.toArray((T[])new int[res.size()][]);
    }

    private static enum Estados {
        q0,
        q1,
        q2,
        q3,
        q4,
        q5,
        q6,
        q7,
        q8,
        q9;

    }
}

