/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao.matricial;

import jalis.comum.ParametrosLocais;

public class CharImpressao {
    public static String ESC = String.valueOf('\u001b');
    public static String BEEP = String.valueOf('\u0007');
    public static String NEGRITO_ON_EPSON = ESC + "E";
    public static String NEGRITO_OFF_EPSON = ESC + "F";
    public static String ITALICO_ON_EPSON = ESC + "4";
    public static String ITALICO_OFF_EPSON = ESC + "5";
    public static String SOBRESCRITO_ON_EPSON = ESC + "S0";
    public static String SUBSCRITO_ON_EPSON = ESC + "S1";
    public static String SUBLINHADO_ON_EPSON = ESC + "-1";
    public static String SUBLINHADO_OFF_EPSON = ESC + "-0";
    public static String SOBRE_SUBSCRITO_OFF_EPSON = ESC + "T";
    public static String COMPRIMIDO_ON_EPSON = ESC + '\u000f';
    public static String COMPRIMIDO_OFF_EPSON = String.valueOf('\u0012');
    public static String EXPANDIDO_ON_EPSON = ESC + '\u000e';
    public static String EXPANDIDO_OFF_EPSON = String.valueOf('\u0014');
    public static String OITO_LINHAS_EPSON = ESC + "0";
    public static String SEIS_LINHAS_EPSON = ESC + "2";
    public static String TABELA_CHAR_1_EPSON = ESC + "t" + '\u0001';
    public static String QUEBRA_LINHA_EPSON = String.valueOf('\n') + '\r';
    public static String PASSADA_DUPLA_ON_EPSON = ESC + "G";
    public static String PASSADA_DUPLA_OFF_EPSON = ESC + "H";
    public static String NEGRITO_ON_LASER = ESC + "(s3B";
    public static String NEGRITO_OFF_LASER = ESC + "(s-3B";
    public static String ITALICO_ON_LASER = ESC + "(s1S";
    public static String ITALICO_OFF_LASER = ESC + "(s0S";
    public static String SOBRESCRITO_ON_LASER = ESC + "S0";
    public static String SUBSCRITO_ON_LASER = ESC + "S1";
    public static String SUBLINHADO_ON_LASER = ESC + "&d0D";
    public static String SUBLINHADO_OFF_LASER = ESC + "&d@";
    public static String SOBRE_SUBSCRITO_OFF_LASER = ESC + "T";
    public static String COMPRIMIDO_ON_LASER = ESC + "(s16.67H" + ESC + "(s8.5V";
    public static String COMPRIMIDO_OFF_LASER = ESC + "(s10H" + ESC + "(s12V";
    public static String EXPANDIDO_ON_LASER = ESC + "(s6H";
    public static String EXPANDIDO_OFF_LASER = ESC + "(s10C";
    public static String OITO_LINHAS_LASER = ESC + "0";
    public static String SEIS_LINHAS_LASER = ESC + "2";
    public static String TABELA_CHAR_1_LASER = ESC + "t" + '\u0001';
    public static String RESET_LASER = ESC + "(s0S" + ESC + "(s0T" + ESC + "(10U" + ESC + "(s0P" + ESC + "&a1L";
    public static String QUEBRA_LINHA_LASER = QUEBRA_LINHA_EPSON;

    public static String getCaractereGrafico(int qtde) {
        return ESC + "L" + (char)(qtde % 256) + (char)(qtde / 256);
    }

    public static String getStringSaltaLinhas(int qtde) {
        boolean laser;
        boolean bl = laser = ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1");
        if (laser) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < qtde; ++i) {
                buf.append(QUEBRA_LINHA_LASER);
            }
            return buf.toString();
        }
        return ESC + "f" + '\u0001' + (char)qtde;
    }

    public static String getStringEspacamentoLinha(int n) {
        return ESC + "A" + (char)n;
    }

    public static String getStringQtdeLinhas(int linhas) {
        return ESC + "C" + (char)linhas;
    }

    public static String getCaractere(String lexema, boolean onOff) {
        String passadaDuplaOff;
        String lex = lexema != null ? lexema.trim() : "";
        boolean laser = ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1");
        String negritoOn = laser ? NEGRITO_ON_LASER : NEGRITO_ON_EPSON;
        String negritoOff = laser ? NEGRITO_OFF_LASER : NEGRITO_OFF_EPSON;
        String italicoOn = laser ? ITALICO_ON_LASER : ITALICO_ON_EPSON;
        String italicoOff = laser ? ITALICO_OFF_LASER : ITALICO_OFF_EPSON;
        String sublinhadoOn = laser ? SUBLINHADO_ON_LASER : SUBLINHADO_ON_EPSON;
        String sublinhadoOff = laser ? SUBLINHADO_OFF_LASER : SUBLINHADO_OFF_EPSON;
        String sobrescritoOn = laser ? SOBRESCRITO_ON_LASER : SOBRESCRITO_ON_EPSON;
        String subescritoOn = laser ? SUBSCRITO_ON_LASER : SUBSCRITO_ON_EPSON;
        String sobrescritoOff = laser ? SOBRE_SUBSCRITO_OFF_LASER : SOBRE_SUBSCRITO_OFF_EPSON;
        String comprimidoOn = laser ? COMPRIMIDO_ON_LASER : COMPRIMIDO_ON_EPSON;
        String comprimidoOff = laser ? COMPRIMIDO_OFF_LASER : COMPRIMIDO_OFF_EPSON;
        String expandidoOn = laser ? EXPANDIDO_ON_LASER : EXPANDIDO_ON_EPSON;
        String expandidoOff = laser ? EXPANDIDO_OFF_LASER : EXPANDIDO_OFF_EPSON;
        String oitoLinhas = laser ? OITO_LINHAS_LASER : OITO_LINHAS_EPSON;
        String seisLinhas = laser ? SEIS_LINHAS_LASER : SEIS_LINHAS_EPSON;
        String passadaDuplaOn = laser ? "" : PASSADA_DUPLA_ON_EPSON;
        String string = passadaDuplaOff = laser ? "" : PASSADA_DUPLA_OFF_EPSON;
        if (lex.equalsIgnoreCase("beep")) {
            return String.valueOf(BEEP);
        }
        if (lex.equalsIgnoreCase("n")) {
            return onOff ? negritoOn : negritoOff;
        }
        if (lex.equalsIgnoreCase("i")) {
            return onOff ? italicoOn : italicoOff;
        }
        if (lex.equalsIgnoreCase("s")) {
            return onOff ? sublinhadoOn : sublinhadoOff;
        }
        if (lex.equalsIgnoreCase("sob")) {
            return onOff ? sobrescritoOn : sobrescritoOff;
        }
        if (lex.equalsIgnoreCase("sub")) {
            return onOff ? subescritoOn : sobrescritoOff;
        }
        if (lex.equalsIgnoreCase("comp")) {
            return onOff ? comprimidoOn : comprimidoOff;
        }
        if (lex.equalsIgnoreCase("exp")) {
            return onOff ? expandidoOn : expandidoOff;
        }
        if (lex.equalsIgnoreCase("oitoLinhas")) {
            return onOff ? oitoLinhas : seisLinhas;
        }
        if (lex.equalsIgnoreCase("2x")) {
            return onOff ? passadaDuplaOn : passadaDuplaOff;
        }
        return "";
    }

    static String trocaTextoPorEspaco(String str) {
        StringBuilder bui = new StringBuilder(str);
        boolean q0 = false;
        boolean q1 = true;
        int q2 = 2;
        int q3 = 3;
        int q4 = 4;
        int estado = 0;
        block6: for (int i = 0; i < bui.length(); ++i) {
            char ch = bui.charAt(i);
            switch (estado) {
                case 0: {
                    if (ch == '\u001b') {
                        estado = 1;
                        continue block6;
                    }
                    if (ch <= ' ' || ch >= '\u007f') continue block6;
                    bui.setCharAt(i, ' ');
                    continue block6;
                }
                case 1: {
                    if (ch == 'S' || ch == '-' || ch == 't' || ch == 'A' || ch == 'C') {
                        estado = 2;
                        continue block6;
                    }
                    if (ch == 'L' || ch == 'f') {
                        estado = 3;
                        continue block6;
                    }
                    estado = 0;
                    continue block6;
                }
                case 2: 
                case 4: {
                    estado = 0;
                    continue block6;
                }
                case 3: {
                    estado = 4;
                }
            }
        }
        return bui.toString();
    }
}

