/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao;

import br.com.thread.openpdf.text.Document;
import br.com.thread.openpdf.text.DocumentException;
import br.com.thread.openpdf.text.pdf.PRStream;
import br.com.thread.openpdf.text.pdf.PdfName;
import br.com.thread.openpdf.text.pdf.PdfNumber;
import br.com.thread.openpdf.text.pdf.PdfObject;
import br.com.thread.openpdf.text.pdf.PdfReader;
import br.com.thread.openpdf.text.pdf.PdfSmartCopy;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class OtimizadorImagensPDF {
    public static ByteArrayOutputStream retornaPDFOtimizado(byte[] pdf, float qualidadeCompressao) throws IOException, DocumentException {
        if (qualidadeCompressao == 0.0f) {
            qualidadeCompressao = 100.0f;
        }
        PdfReader reader = new PdfReader(pdf);
        int n = reader.getXrefSize();
        for (int i = 0; i < n; ++i) {
            byte[] img;
            BufferedImage bi;
            PRStream stream;
            PdfObject pdfsubtype;
            PdfObject object = reader.getPdfObject(i);
            if (object == null || !object.isStream() || (pdfsubtype = (stream = (PRStream)object).get(PdfName.SUBTYPE)) == null || !pdfsubtype.toString().equals(PdfName.IMAGE.toString()) || (bi = ImageIO.read(new ByteArrayInputStream(img = PdfReader.getStreamBytesRaw((PRStream)stream)))) == null) continue;
            int width = bi.getWidth();
            int height = bi.getHeight();
            ByteArrayOutputStream imgBytes = new ByteArrayOutputStream();
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(imgBytes);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(qualidadeCompressao / 100.0f);
            IIOImage imagemNova = new IIOImage(bi, null, null);
            writer.write(null, imagemNova, param);
            writer.dispose();
            ios.flush();
            ios.close();
            stream.setData(imgBytes.toByteArray(), false, 9);
            stream.put(PdfName.TYPE, (PdfObject)PdfName.XOBJECT);
            stream.put(PdfName.SUBTYPE, (PdfObject)PdfName.IMAGE);
            stream.put(PdfName.FILTER, (PdfObject)PdfName.DCTDECODE);
            stream.put(PdfName.WIDTH, (PdfObject)new PdfNumber(width));
            stream.put(PdfName.HEIGHT, (PdfObject)new PdfNumber(height));
            stream.put(PdfName.BITSPERCOMPONENT, (PdfObject)new PdfNumber(8));
            stream.put(PdfName.COLORSPACE, (PdfObject)PdfName.DEVICERGB);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document document = new Document();
        PdfSmartCopy pdfCopy = new PdfSmartCopy(document, (OutputStream)bos);
        document.open();
        int pageNumber = 0;
        while (pageNumber < reader.getNumberOfPages()) {
            pdfCopy.addPage(pdfCopy.getImportedPage(reader, ++pageNumber));
        }
        document.close();
        pdfCopy.close();
        reader.close();
        return bos;
    }
}

