/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.impressao;

import jalis.laboratorio.impressao.Documento;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TamanhoPersonalizado;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.OrientationRequested;

public class ImpressaoTexto
implements Printable {
    private List<List<String>> paginas;
    private String texto;
    private Font fonte;
    private PageFormat formatoPagina = new PageFormat();

    private ImpressaoTexto(String texto, String configuracao, Font fonte) {
        this.paginas = new ArrayList<List<String>>();
        this.texto = texto;
        this.fonte = fonte;
    }

    public static void imprimir(String impressora, String texto) {
        ImpressaoTexto.imprimir(impressora, null, texto, null);
    }

    public static void imprimir(String impressora, String texto, Font fonte) {
        ImpressaoTexto.imprimir(impressora, null, texto, fonte);
    }

    public static void imprimir(String impressora, String configuracao, String texto) {
        ImpressaoTexto.imprimir(impressora, configuracao, texto, null);
    }

    public static void imprimir(String impressora, final String configuracao, final String texto, final Font fonte) {
        final PrintService ps = Funcoes.localizarImpressora(impressora);
        if (ps == null) {
            Funcoes.mensagem(null, "A impressora " + impressora + " n\u00e3o foi localizada", 2);
        } else {
            new Thread("ThreadImpressaoTexto"){

                @Override
                public void run() {
                    try {
                        PrinterJob job = PrinterJob.getPrinterJob();
                        job.setJobName("Impressao de texto - Jalis");
                        job.setPrintService(ps);
                        job.setPrintable(new ImpressaoTexto(texto, configuracao, fonte), ImpressaoTexto.getAtributosPagina(configuracao));
                        job.setCopies(1);
                        job.print();
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoTexto: 70");
                    }
                }
            }.start();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        FontMetrics fm;
        Graphics2D g2d = (Graphics2D)graphics;
        if (this.fonte != null) {
            g2d.setFont(this.fonte);
        }
        g2d.setColor(Color.black);
        FontMetrics fontMetrics = fm = this.fonte != null ? g2d.getFontMetrics(this.fonte) : g2d.getFontMetrics();
        if (this.paginas.size() == 0) {
            this.gerarPaginas(pageFormat, fm);
        }
        if (pageIndex >= this.paginas.size()) {
            return 1;
        }
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2d.setClip(0, 0, (int)pageFormat.getPaper().getWidth() - 100, (int)pageFormat.getPaper().getHeight());
        List<String> pagina = this.paginas.get(pageIndex);
        int y = 10;
        for (String linha : pagina) {
            g2d.drawString(linha, 0, y += fm.getAscent());
            y += fm.getDescent() + fm.getLeading();
        }
        return 0;
    }

    private void gerarPaginas(PageFormat pageFormat, FontMetrics fm) {
        int toIndex;
        int y = 0;
        int fromIndex = 0;
        int height = (int)pageFormat.getPaper().getHeight();
        List<String> linhas = StringUtil.quebrarEmColunas(this.texto, (int)pageFormat.getWidth() - 100, fm);
        for (toIndex = 1; toIndex < linhas.size(); ++toIndex) {
            if ((y += fm.getAscent()) + fm.getHeight() > height) {
                this.paginas.add(linhas.subList(fromIndex, toIndex));
                fromIndex = toIndex;
                y = fm.getAscent();
            }
            y += fm.getDescent() + fm.getLeading();
        }
        this.paginas.add(linhas.size() == 0 ? new ArrayList() : linhas.subList(fromIndex, toIndex));
    }

    @Deprecated
    private static PrintRequestAttributeSet getAtributos(String configuracao) {
        float h;
        if (configuracao == null) {
            return null;
        }
        configuracao = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(configuracao, "exame"), "pagina"), "propriedades");
        HashPrintRequestAttributeSet atributos = new HashPrintRequestAttributeSet();
        String tmp = StringUtil.getValor(configuracao, "dimensoes");
        float w = Documento.valorPropriedadeMM(tmp, "largura");
        if (w > (h = Documento.valorPropriedadeMM(tmp, "altura"))) {
            atributos.add(OrientationRequested.LANDSCAPE);
            atributos.add(new MediaSize(h, w, 1000, TamanhoPersonalizado.PERSONALIZADO).getMediaSizeName());
        } else {
            atributos.add(OrientationRequested.PORTRAIT);
            atributos.add(new MediaSize(w, h, 1000, TamanhoPersonalizado.PERSONALIZADO).getMediaSizeName());
        }
        float mE = Documento.valorPropriedadeMM(configuracao, "margemEsquerda");
        float mD = Documento.valorPropriedadeMM(configuracao, "margemDireita");
        float mS = Documento.valorPropriedadeMM(configuracao, "margemSuperior");
        float mI = Documento.valorPropriedadeMM(configuracao, "margemInferior");
        if (w > h) {
            atributos.add(new MediaPrintableArea(mS, mE, h - mS - mI, w - mE - mD, 1000));
        } else {
            atributos.add(new MediaPrintableArea(mE, mS, w - mE - mD, h - mS - mI, 1000));
        }
        return atributos;
    }

    private static PageFormat getAtributosPagina(String configuracao) {
        if (configuracao == null) {
            return null;
        }
        configuracao = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(configuracao, "exame"), "pagina"), "propriedades");
        String tmp = StringUtil.getValor(configuracao, "dimensoes");
        float w = Documento.valorPropriedadeMM(tmp, "largura");
        float h = Documento.valorPropriedadeMM(tmp, "altura");
        float mE = Documento.valorPropriedadeMM(configuracao, "margemEsquerda");
        float mD = Documento.valorPropriedadeMM(configuracao, "margemDireita");
        float mS = Documento.valorPropriedadeMM(configuracao, "margemSuperior");
        float mI = Documento.valorPropriedadeMM(configuracao, "margemInferior");
        PageFormat formatoPagina = new PageFormat();
        Paper paper = new Paper();
        paper.setSize(ScreenUtil.getPixelsDeMilimetros(w), ScreenUtil.getPixelsDeMilimetros(h));
        paper.setImageableArea(mS, mE, w - mS - mI, h - mE - mD);
        formatoPagina = new PageFormat();
        formatoPagina.setOrientation(w > h ? 0 : 1);
        formatoPagina.setPaper(paper);
        return formatoPagina;
    }
}

