/*
 * Decompiled with CFR 0.152.
 */
package jalis.util.expressao.parser;

import jalis.util.expressao.parser.Lexico;
import java.util.ArrayList;
import java.util.List;

public class Token {
    public static final int IDENT = 0;
    public static final int TEXTO = 1;
    public static final int CHAR = 2;
    public static final int DECIMAL = 3;
    public static final int INTEIRO = 4;
    public static final int VERDADEIRO = 5;
    public static final int FALSO = 6;
    public static final int SE = 7;
    public static final int COPIA = 8;
    public static final int VAZIO = 9;
    public static final int ZERO = 10;
    public static final int DATA = 11;
    public static final int EXTENSO = 12;
    public static final int NUMERO = 13;
    public static final int SOMADATA = 14;
    public static final int TAMANHO = 15;
    public static final int SOMATORIO = 16;
    public static final int MEDIA = 17;
    public static final int CONTEM = 18;
    public static final int E = 19;
    public static final int OU = 20;
    public static final int ABRE = 21;
    public static final int FECHA = 22;
    public static final int MENOR = 23;
    public static final int MAIOR = 24;
    public static final int MENOR_IGUAL = 25;
    public static final int MAIOR_IGUAL = 26;
    public static final int IGUAL = 27;
    public static final int DIFERENTE = 28;
    public static final int MULTI = 29;
    public static final int DIV = 30;
    public static final int MENOS = 31;
    public static final int MAIS = 32;
    public static final int PONTO_VIRGULA = 33;
    public static final int NULO = 34;
    public static final int CARACTER = 35;
    public static final int CARACTERESC = 36;
    public static final int SOMATORIO_AVANCADO = 37;
    public static final int TP_LEXICO = 0;
    public static final int TP_SINTATICO = 1;
    public static final int TP_SEMANTICO = 2;
    public int tipoErro = -1;
    public boolean erro = false;
    public String erroDesc = "";
    public String lexema = "";
    public int id = -1;
    public int pos;

    public String toString() {
        return this.lexema + (this.erro ? "  err: " + this.erroDesc : "  id: " + Token.getIdStr(this.id)) + "  pos: " + Integer.toString(this.pos);
    }

    public boolean funcao() {
        switch (this.id) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 35: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public boolean operadorMatematico() {
        switch (this.id) {
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public boolean operadorRelacional() {
        switch (this.id) {
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean operadorLogico() {
        switch (this.id) {
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public boolean operador() {
        return this.operadorMatematico() || this.operadorRelacional() || this.operadorLogico();
    }

    public boolean literal() {
        switch (this.id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Object instancia() {
        switch (this.id) {
            case 1: 
            case 2: {
                return this.lexema.substring(1, this.lexema.length() - 1);
            }
            case 3: {
                return new Double(this.lexema.replace(',', '.'));
            }
            case 4: {
                return new Long(this.lexema);
            }
            case 5: {
                return Boolean.TRUE;
            }
            case 6: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static List<String> getIdentificadores(Lexico lex) {
        ArrayList<String> idents = new ArrayList<String>();
        if (lex != null) {
            Token tk = lex.getProxToken();
            while (tk.id != 34 && !tk.erro) {
                if (tk.id == 0) {
                    idents.add(tk.lexema);
                }
                tk = lex.getProxToken();
            }
        }
        return idents;
    }

    public static String getIdStr(int id) {
        switch (id) {
            case 0: {
                return "IDENT";
            }
            case 7: {
                return "SE";
            }
            case 8: {
                return "COPIA";
            }
            case 9: {
                return "VAZIO";
            }
            case 10: {
                return "ZERO";
            }
            case 11: {
                return "DATA";
            }
            case 12: {
                return "EXTENSO";
            }
            case 13: {
                return "NUMERO";
            }
            case 14: {
                return "SOMADATA";
            }
            case 15: {
                return "TAMANHO";
            }
            case 16: {
                return "SOMATORIO";
            }
            case 37: {
                return "SOMATORIOAVANCADO";
            }
            case 17: {
                return "MEDIA";
            }
            case 18: {
                return "CONTEM";
            }
            case 35: {
                return "CARACTER";
            }
            case 36: {
                return "CARACTERESC";
            }
            case 19: {
                return "E";
            }
            case 20: {
                return "OU";
            }
            case 1: {
                return "TEXTO";
            }
            case 2: {
                return "CHAR";
            }
            case 4: {
                return "INTEIRO";
            }
            case 3: {
                return "DECIMAL";
            }
            case 5: {
                return "VERDADEIRO";
            }
            case 6: {
                return "FALSO";
            }
            case 21: {
                return "(";
            }
            case 22: {
                return ")";
            }
            case 32: {
                return "+";
            }
            case 31: {
                return "-";
            }
            case 29: {
                return "*";
            }
            case 30: {
                return "/";
            }
            case 33: {
                return ";";
            }
            case 27: {
                return "=";
            }
            case 24: {
                return ">";
            }
            case 23: {
                return "<";
            }
            case 26: {
                return ">=";
            }
            case 25: {
                return "<=";
            }
            case 28: {
                return "<>";
            }
            case 34: {
                return "NULO";
            }
        }
        return "";
    }
}

